/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;

public abstract class AbstractForestBuilder
implements Comparator<NavigableEdge> {
    private final @NonNull Set<@NonNull NavigableEdge> forwardEdges = new HashSet<NavigableEdge>();
    private final @NonNull Set<@NonNull NavigableEdge> manyToOneEdges = new HashSet<NavigableEdge>();
    private final @NonNull Map<@NonNull NavigableEdge, @NonNull Integer> traversedEdge2depth = new HashMap<NavigableEdge, Integer>();
    private final @NonNull Map<@NonNull Node, @Nullable NavigableEdge> traversedNode2incomingEdge = new HashMap<Node, NavigableEdge>();

    protected AbstractForestBuilder(@NonNull Iterable<@NonNull Node> rootNodes, @NonNull Iterable<@NonNull NavigableEdge> edges) {
        for (Node rootNode : rootNodes) {
            this.traversedNode2incomingEdge.put(rootNode, null);
        }
        for (NavigableEdge edge : edges) {
            this.addEdge(edge);
        }
        this.analyze(this.traversedNode2incomingEdge.keySet());
    }

    protected void addEdge(@NonNull NavigableEdge edge) {
        if (!edge.isSecondary()) {
            this.forwardEdges.add(edge);
            if (edge.getEdgeSource().isClass() && edge.getOppositeEdge() == null) {
                this.manyToOneEdges.add(edge);
            }
        }
    }

    public void analyze(@NonNull Iterable<@NonNull Node> rootNodes) {
        HashSet<@NonNull Node> moreNodes = Sets.newHashSet(rootNodes);
        int depth = 0;
        while (moreNodes.size() > 0) {
            Node targetNode;
            HashSet<@NonNull Node> moreMoreNodes = new HashSet<Node>();
            for (Node sourceNode : moreNodes) {
                for (NavigableEdge forwardEdge : sourceNode.getNavigationEdges()) {
                    if (!this.forwardEdges.contains(forwardEdge) || this.traversedNode2incomingEdge.containsKey(targetNode = RegionUtil.getCastTarget((Node)forwardEdge.getEdgeTarget()))) continue;
                    this.traversedNode2incomingEdge.put(targetNode, forwardEdge);
                    moreMoreNodes.add(targetNode);
                    this.traversedEdge2depth.put(forwardEdge, depth);
                }
            }
            if (moreMoreNodes.isEmpty()) {
                for (NavigableEdge forwardEdge : this.forwardEdges) {
                    Node sourceNode;
                    @Nullable NavigableEdge backwardEdge = forwardEdge.getOppositeEdge();
                    if (backwardEdge == null || !this.traversedNode2incomingEdge.containsKey(sourceNode = backwardEdge.getEdgeSource()) || this.traversedNode2incomingEdge.containsKey(targetNode = backwardEdge.getEdgeTarget())) continue;
                    this.traversedNode2incomingEdge.put(targetNode, backwardEdge);
                    moreMoreNodes.add(targetNode);
                    this.traversedEdge2depth.put(backwardEdge, depth);
                    break;
                }
                if (moreMoreNodes.isEmpty()) {
                    for (NavigableEdge manyToOneEdge : this.manyToOneEdges) {
                        Node targetNode2;
                        Node sourceNode = manyToOneEdge.getEdgeTarget();
                        if (!this.traversedNode2incomingEdge.containsKey(sourceNode) || this.traversedNode2incomingEdge.containsKey(targetNode2 = manyToOneEdge.getEdgeSource())) continue;
                        this.traversedNode2incomingEdge.put(targetNode2, manyToOneEdge);
                        moreMoreNodes.add(targetNode2);
                        this.traversedEdge2depth.put(manyToOneEdge, depth);
                        break;
                    }
                }
            }
            moreNodes = moreMoreNodes;
            ++depth;
        }
    }

    @Override
    public int compare(@NonNull NavigableEdge o1, @NonNull NavigableEdge o2) {
        Integer d1 = this.traversedEdge2depth.get(o1);
        Integer d2 = this.traversedEdge2depth.get(o2);
        assert (d1 != null && d2 != null);
        if (d1 != d2) {
            return d1 - d2;
        }
        String n1 = o1.getDisplayName();
        String n2 = o2.getDisplayName();
        return n1.compareTo(n2);
    }

    protected @NonNull Iterable<@NonNull NavigableEdge> getForwardEdges() {
        return this.forwardEdges;
    }

    public @Nullable NavigableEdge getParentEdge(@NonNull Node node) {
        return this.traversedNode2incomingEdge.get(node);
    }

    protected @NonNull Iterable<@NonNull NavigableEdge> getTraversedEdges() {
        return this.traversedEdge2depth.keySet();
    }
}

