/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.merger;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.AbstractMerger;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;

class Correlator {
    protected final @NonNull MappingRegion primaryRegion;
    protected final @NonNull MappingRegion secondaryRegion;
    protected final @NonNull CorrelationStrategy strategy;
    protected final @NonNull Map<@NonNull Node, @NonNull Node> secondaryNode2primaryNode = new HashMap<Node, Node>();
    protected final @NonNull Map<@NonNull CompleteClass, @NonNull List<@NonNull Node>> completeClass2primaryNodes;
    protected final boolean debugFailures = AbstractMerger.FAILURE.isActive();

    public static @Nullable Correlator correlate(@NonNull MappingRegion secondaryRegion, @NonNull MappingRegion primaryRegion, @NonNull CorrelationStrategy strategy, @Nullable Map<@NonNull Node, @NonNull Node> primaryNode2secondaryNode) {
        Correlator correlator = new Correlator(primaryRegion, secondaryRegion, strategy, primaryNode2secondaryNode);
        return correlator.correlate() ? correlator : null;
    }

    protected Correlator(@NonNull MappingRegion primaryRegion, @NonNull MappingRegion secondaryRegion, @NonNull CorrelationStrategy strategy, @Nullable Map<@NonNull Node, @NonNull Node> primaryNode2secondaryNode) {
        this.primaryRegion = primaryRegion;
        this.secondaryRegion = secondaryRegion;
        this.strategy = strategy;
        this.completeClass2primaryNodes = RegionUtil.getCompleteClass2Nodes((Region)primaryRegion);
        if (primaryNode2secondaryNode != null) {
            for (Map.Entry<Node, Node> entry : primaryNode2secondaryNode.entrySet()) {
                this.secondaryNode2primaryNode.put(entry.getValue(), entry.getKey());
            }
        }
    }

    protected boolean correlate() {
        if (!this.correlateHeadNodes()) {
            return false;
        }
        if (!this.correlateNavigablePredicates()) {
            return false;
        }
        Set<@NonNull Node> navigableNodes = this.secondaryNode2primaryNode.keySet();
        if (!this.correlateComputedPredicates()) {
            return false;
        }
        this.correlateResidualComputations(navigableNodes);
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean correlateComputation(@NonNull Node firstNode, @NonNull Node secondNode, @NonNull Map<@NonNull Node, @NonNull Node> first2second) {
        Node node = first2second.get(firstNode);
        if (node != null) {
            return node == secondNode;
        }
        if (firstNode.getNodeRole() != secondNode.getNodeRole()) {
            return false;
        }
        if (!ClassUtil.safeEquals((Object)firstNode.getName(), (Object)secondNode.getName())) {
            return false;
        }
        HashMap<@NonNull Node, @NonNull Node> nestedFirst2second = new HashMap<Node, Node>(first2second);
        nestedFirst2second.put(firstNode, secondNode);
        @NonNull ArrayList residualSecondArgumentEdges = Lists.newArrayList((Iterable)secondNode.getArgumentEdges());
        for (Edge firstEdge : firstNode.getArgumentEdges()) {
            boolean gotIt = false;
            for (Edge secondEdge : residualSecondArgumentEdges) {
                if (!ClassUtil.safeEquals((Object)firstEdge.getName(), (Object)secondEdge.getName())) continue;
                if (!this.correlateComputation(firstEdge.getEdgeSource(), secondEdge.getEdgeSource(), nestedFirst2second)) {
                    return false;
                }
                gotIt = true;
                residualSecondArgumentEdges.remove(secondEdge);
                break;
            }
            if (gotIt) continue;
            return false;
        }
        first2second.putAll(nestedFirst2second);
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean correlateComputedPredicates() {
        @NonNull Iterable primaryTrueNodes = this.primaryRegion.getTrueNodes();
        @NonNull Iterable secondaryTrueNodes = this.secondaryRegion.getTrueNodes();
        int primaryTrueSize = Iterables.size((Iterable)primaryTrueNodes);
        if (primaryTrueSize != Iterables.size((Iterable)secondaryTrueNodes)) {
            return false;
        }
        if (primaryTrueSize == 0) {
            return true;
        }
        HashMap<@NonNull Node, @NonNull Node> primary2secondary = new HashMap<Node, Node>();
        if (primaryTrueSize == 1) {
            Node secondaryTrueNode;
            Node primaryTrueNode = (Node)primaryTrueNodes.iterator().next();
            if (!this.correlateComputation(primaryTrueNode, secondaryTrueNode = (Node)secondaryTrueNodes.iterator().next(), primary2secondary)) {
                return false;
            }
        } else {
            @NonNull HashSet residualSecondaryTrueNodes = Sets.newHashSet((Iterable)secondaryTrueNodes);
            for (Node primaryTrueNode : primaryTrueNodes) {
                boolean gotIt = false;
                for (Node secondaryTrueNode : residualSecondaryTrueNodes) {
                    HashMap<Node, Node> primary2secondary2;
                    if (!this.correlateComputation(primaryTrueNode, secondaryTrueNode, primary2secondary2 = new HashMap<Node, Node>())) continue;
                    gotIt = true;
                    primary2secondary.putAll(primary2secondary2);
                    residualSecondaryTrueNodes.remove(secondaryTrueNode);
                    break;
                }
                if (gotIt) continue;
                return false;
            }
        }
        for (Node primaryNode : primary2secondary.keySet()) {
            Node equivalentNode = (Node)primary2secondary.get(primaryNode);
            assert (equivalentNode != null);
            this.secondaryNode2primaryNode.put(equivalentNode, primaryNode);
        }
        return true;
    }

    protected boolean correlateHeadNodes() {
        List secondaryHeadNodes = this.secondaryRegion.getHeadNodes();
        if (secondaryHeadNodes.size() != 1) {
            if (this.debugFailures) {
                AbstractMerger.FAILURE.println("More than 1 secondary head nodes: " + secondaryHeadNodes.size());
            }
            return false;
        }
        Node secondaryHeadNode = (Node)secondaryHeadNodes.get(0);
        CompleteClass completeClass = secondaryHeadNode.getCompleteClass();
        List<@NonNull Node> primaryNodes = this.completeClass2primaryNodes.get(completeClass);
        if (primaryNodes == null) {
            if (this.debugFailures) {
                AbstractMerger.FAILURE.println("No primary nodes of type: " + completeClass);
            }
            return false;
        }
        Node primaryHeadNode = this.secondaryNode2primaryNode.get(secondaryHeadNode);
        if (primaryHeadNode != null) {
            return true;
        }
        primaryHeadNode = this.selectMergedHeadNode(secondaryHeadNode, primaryNodes);
        if (primaryHeadNode == null) {
            primaryHeadNode = this.selectMergedHeadNode(secondaryHeadNode, primaryNodes);
            if (this.debugFailures) {
                AbstractMerger.FAILURE.println("No primary head node to match: " + secondaryHeadNode);
            }
            return false;
        }
        this.secondaryNode2primaryNode.put(secondaryHeadNode, primaryHeadNode);
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean correlateNavigablePredicates() {
        HashSet<@NonNull Node> secondaryNodes = new HashSet<Node>(this.secondaryNode2primaryNode.keySet());
        ArrayList<@NonNull Node> secondaryNodesWorkList = new ArrayList<Node>(secondaryNodes);
        int i = 0;
        while (i < secondaryNodesWorkList.size()) {
            Node primarySourceNode;
            @NonNull Node secondarySourceNode = (Node)secondaryNodesWorkList.get(i);
            if (!this.strategy.navigableNodesMatch(secondarySourceNode, primarySourceNode = this.secondaryNode2primaryNode.get(secondarySourceNode))) {
                return false;
            }
            for (NavigableEdge uncastSecondaryEdge : secondarySourceNode.getNavigationEdges()) {
                Node uncastSecondaryTargetNode = uncastSecondaryEdge.getEdgeTarget();
                @NonNull Iterable secondaryTargetNodes = RegionUtil.getCastTargets((Node)uncastSecondaryTargetNode, (boolean)true);
                if (primarySourceNode != null) {
                    NavigableEdge uncastPrimaryEdge = primarySourceNode.getNavigationEdge(RegionUtil.getProperty((NavigableEdge)uncastSecondaryEdge));
                    if (!this.strategy.navigableEdgesMatch(uncastSecondaryEdge, uncastPrimaryEdge)) {
                        return false;
                    }
                    if (uncastPrimaryEdge != null) {
                        CompleteClass targetCompleteClass;
                        Node uncastPrimaryTargetNode = uncastPrimaryEdge.getEdgeTarget();
                        if (uncastSecondaryTargetNode.isExplicitNull() != uncastPrimaryTargetNode.isExplicitNull()) {
                            if (this.debugFailures) {
                                AbstractMerger.FAILURE.println("Inconsistent ExplicitNull: " + uncastSecondaryTargetNode);
                            }
                            return false;
                        }
                        HashMap<@NonNull CompleteClass, @NonNull Node> completeClass2primaryTargetNodes = new HashMap<CompleteClass, Node>();
                        for (Node primaryTargetNode : RegionUtil.getCastTargets((Node)uncastPrimaryTargetNode, (boolean)true)) {
                            targetCompleteClass = primaryTargetNode.getCompleteClass();
                            Node oldNode = completeClass2primaryTargetNodes.put(targetCompleteClass, primaryTargetNode);
                            if (oldNode == null) continue;
                            if (this.debugFailures) {
                                AbstractMerger.FAILURE.println("Inconsistent paths to: " + targetCompleteClass);
                            }
                            return false;
                        }
                        for (Node secondaryTargetNode : secondaryTargetNodes) {
                            targetCompleteClass = secondaryTargetNode.getCompleteClass();
                            Node primaryTargetNode = (Node)completeClass2primaryTargetNodes.remove(targetCompleteClass);
                            if (primaryTargetNode == null) continue;
                            Node primaryTargetNode2 = this.secondaryNode2primaryNode.get(secondaryTargetNode);
                            if (primaryTargetNode2 == null) {
                                this.secondaryNode2primaryNode.put(secondaryTargetNode, primaryTargetNode);
                                continue;
                            }
                            if (primaryTargetNode == primaryTargetNode2) continue;
                            if (this.debugFailures) {
                                AbstractMerger.FAILURE.println("Inconsistent paths to: " + primaryTargetNode + ", " + primaryTargetNode2);
                            }
                            return false;
                        }
                    }
                }
                for (Node secondaryTargetNode : secondaryTargetNodes) {
                    if (!secondaryNodes.add(secondaryTargetNode)) continue;
                    secondaryNodesWorkList.add(secondaryTargetNode);
                }
            }
            ++i;
        }
        return true;
    }

    protected void correlateResidualComputations(@NonNull Iterable<@NonNull Node> secondaryNodes) {
        for (Node secondaryNode : secondaryNodes) {
            Node primaryNode = this.secondaryNode2primaryNode.get(secondaryNode);
            assert (primaryNode != null);
            HashMap<@NonNull Node, @NonNull Node> secondary2primary2 = new HashMap<Node, Node>();
            if (!this.correlateComputation(secondaryNode, primaryNode, secondary2primary2)) continue;
            this.secondaryNode2primaryNode.putAll(secondary2primary2);
        }
    }

    public @NonNull Map<@NonNull Node, @NonNull Node> getNode2Node() {
        return this.secondaryNode2primaryNode;
    }

    protected @Nullable Node selectMergedHeadNode(@NonNull Node headNode, @NonNull List<@NonNull Node> mergedNodes) {
        if (mergedNodes.size() == 1) {
            Node mergedNode = mergedNodes.get(0);
            return mergedNode;
        }
        if (mergedNodes.size() == 0) {
            return null;
        }
        Iterable predicateEdges = headNode.getPredicateEdges();
        for (Node mergedNode : mergedNodes) {
            boolean ok;
            boolean bl = ok = !mergedNode.isIterator();
            if (ok) {
                for (NavigableEdge predicateEdge : predicateEdges) {
                    Property property = RegionUtil.getProperty((NavigableEdge)predicateEdge);
                    Node navigation = mergedNode.getNavigationTarget(property);
                    if (navigation != null) continue;
                    ok = false;
                    break;
                }
            }
            if (!ok) continue;
            return mergedNode;
        }
        return null;
    }

    static abstract class AbstractCorrelationStrategy
    implements CorrelationStrategy {
        protected final boolean debugFailures = AbstractMerger.FAILURE.isActive();

        AbstractCorrelationStrategy() {
        }

        @Override
        public boolean navigableEdgesMatch(@NonNull NavigableEdge secondaryEdge, @Nullable NavigableEdge primaryEdge) {
            return true;
        }

        @Override
        public boolean navigableNodesMatch(@NonNull Node secondaryNode, @Nullable Node primaryNode) {
            if (primaryNode == null) {
                if (secondaryNode.isPredicated()) {
                    if (this.debugFailures) {
                        AbstractMerger.FAILURE.println("Missing predicated match for : " + secondaryNode);
                    }
                    return false;
                }
                return true;
            }
            assert (secondaryNode.isExplicitNull() == primaryNode.isExplicitNull());
            return true;
        }
    }

    private static interface CorrelationStrategy {
        public boolean navigableEdgesMatch(@NonNull NavigableEdge var1, @Nullable NavigableEdge var2);

        public boolean navigableNodesMatch(@NonNull Node var1, @Nullable Node var2);
    }
}

