/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ContentsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CastEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CastInitializerCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedConditionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedConditionVisitor;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.ConstantTargetCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.MultipleEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.NavigableEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.NonNullInitializerCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.PredicateEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.PredicateNavigationEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.impl.RegionImpl;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class FallibilityAnalysis {
    public static final @NonNull TracingOption GLOBAL = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/fallibility/global");
    public static final @NonNull TracingOption LOCAL = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/fallibility/local");
    protected final @NonNull TransformationAnalysis transformationAnalysis;
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ContentsAnalysis<@NonNull RuleRegion> originalContentsAnalysis;
    private @Nullable RegionAnalysis failSometimes = null;
    private @NonNull Map<@NonNull RegionAnalysis, @NonNull Set<@NonNull RegionAnalysis>> consumer2producers = new HashMap<RegionAnalysis, Set<RegionAnalysis>>();

    public FallibilityAnalysis(@NonNull TransformationAnalysis transformationAnalysis) {
        this.transformationAnalysis = transformationAnalysis;
        this.scheduleManager = transformationAnalysis.getScheduleManager();
        this.originalContentsAnalysis = this.scheduleManager.getOriginalContentsAnalysis();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void accumulate(@NonNull RegionAnalysis consumingRegionAnalysis) {
        String name = consumingRegionAnalysis.getName();
        if ("mTmapIfExp_success_t1atlCondition_t1atlElse_t1atlTh".equals(name)) {
            this.getClass();
        }
        Visitor visitor = new Visitor(consumingRegionAnalysis);
        Map<@NonNull CheckedCondition, @NonNull Object> check2regionOrRegions = visitor.analyze();
        HashSet<@NonNull RegionAnalysis> producingRegionAnalyses = new HashSet<RegionAnalysis>();
        HashSet<@NonNull Edge> checkedEdges = new HashSet<Edge>();
        HashSet<@NonNull Node> checkedNodes = new HashSet<Node>();
        for (CheckedCondition checkedCondition : check2regionOrRegions.keySet()) {
            Node conditionNode;
            Iterable<@NonNull Edge> conditionEdges = checkedCondition.getEdges();
            if (conditionEdges != null) {
                for (Edge conditionEdge : conditionEdges) {
                    checkedEdges.add(conditionEdge);
                }
            }
            if ((conditionNode = checkedCondition.getNode()) != null) {
                checkedNodes.add(conditionNode);
            }
            Object regionOrRegions = check2regionOrRegions.get(checkedCondition);
            assert (regionOrRegions != null);
            if (regionOrRegions instanceof RegionAnalysis) {
                producingRegionAnalyses.add((RegionAnalysis)regionOrRegions);
                continue;
            }
            @NonNull Iterable producingRegions = (Iterable)regionOrRegions;
            for (RegionAnalysis producingRegionAnalysis : producingRegions) {
                producingRegionAnalyses.add(producingRegionAnalysis);
            }
        }
        @NonNull Set old = this.consumer2producers.put(consumingRegionAnalysis, producingRegionAnalyses);
        assert (old == null);
    }

    private @NonNull RegionAnalysis createPseudoRegionAnalysis(@NonNull String name) {
        RegionImpl dummyRegion = new RegionImpl(){

            public List<Node> getHeadNodes() {
                return Collections.emptyList();
            }
        };
        dummyRegion.setName(name);
        return new RegionAnalysis(this.transformationAnalysis, (Region)dummyRegion);
    }

    public @NonNull RegionAnalysis getFailSometimes() {
        RegionAnalysis failSometimes2 = this.failSometimes;
        if (failSometimes2 == null) {
            this.failSometimes = failSometimes2 = this.createPseudoRegionAnalysis("\u00abfailSometimes\u00bb");
            this.consumer2producers.put(failSometimes2, Sets.newHashSet((Object[])new RegionAnalysis[]{failSometimes2}));
        }
        return failSometimes2;
    }

    public void install() {
        if (LOCAL.isActive()) {
            ArrayList<@NonNull RegionAnalysis> consumers = new ArrayList<RegionAnalysis>(this.consumer2producers.keySet());
            Collections.sort(consumers, NameUtil.NAMEABLE_COMPARATOR);
            for (RegionAnalysis consumingRegionAnalysis : consumers) {
                StringBuilder s = new StringBuilder();
                s.append(consumingRegionAnalysis + " <=");
                Set<@NonNull RegionAnalysis> producers = this.consumer2producers.get(consumingRegionAnalysis);
                assert (producers != null);
                ArrayList<@NonNull RegionAnalysis> sortedProducers = new ArrayList<RegionAnalysis>(producers);
                Collections.sort(sortedProducers, NameUtil.NAMEABLE_COMPARATOR);
                for (RegionAnalysis producingRegionAnalysis : sortedProducers) {
                    s.append(" " + producingRegionAnalysis);
                }
                LOCAL.println(s.toString());
            }
        }
        Map<@NonNull RegionAnalysis, @NonNull Set<@NonNull RegionAnalysis>> consumer2producersClosure = CompilerUtil.computeClosure(this.consumer2producers);
        for (RegionAnalysis consumingRegionAnalysis : consumer2producersClosure.keySet()) {
            Set<@NonNull RegionAnalysis> fallibilities = consumer2producersClosure.get(consumingRegionAnalysis);
            assert (fallibilities != null);
        }
        if (GLOBAL.isActive()) {
            ArrayList<@NonNull RegionAnalysis> consumers = new ArrayList<RegionAnalysis>(consumer2producersClosure.keySet());
            Collections.sort(consumers, NameUtil.NAMEABLE_COMPARATOR);
            for (RegionAnalysis consumingRegionAnalysis : consumers) {
                StringBuilder s = new StringBuilder();
                s.append(consumingRegionAnalysis + " <=");
                Set<@NonNull RegionAnalysis> producers = consumer2producersClosure.get(consumingRegionAnalysis);
                assert (producers != null);
                ArrayList<@NonNull RegionAnalysis> sortedProducers = new ArrayList<RegionAnalysis>(producers);
                Collections.sort(sortedProducers, NameUtil.NAMEABLE_COMPARATOR);
                for (RegionAnalysis producingRegionAnalysis : sortedProducers) {
                    s.append(" " + producingRegionAnalysis);
                }
                GLOBAL.println(s.toString());
            }
        }
    }

    protected class Visitor
    implements CheckedConditionVisitor<Object> {
        protected final @NonNull RegionAnalysis regionAnalysis;
        protected final @NonNull Map<@NonNull CheckedCondition, @NonNull Object> check2regionOrRegions = new HashMap<CheckedCondition, Object>();

        public Visitor(RegionAnalysis regionAnalysis) {
            this.regionAnalysis = regionAnalysis;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void addFallibility(@NonNull CheckedCondition checkedCondition, @NonNull RegionAnalysis producingRegionAnalysis) {
            Object regionOrRegions;
            if (LOCAL.isActive()) {
                LOCAL.println(this.regionAnalysis + " may fail because " + checkedCondition + " produced by " + producingRegionAnalysis);
            }
            if ((regionOrRegions = this.check2regionOrRegions.get(checkedCondition)) == null) {
                this.check2regionOrRegions.put(checkedCondition, producingRegionAnalysis);
            } else if (regionOrRegions instanceof RegionAnalysis) {
                if (regionOrRegions != producingRegionAnalysis) {
                    HashSet<@NonNull RegionAnalysis> regions = new HashSet<RegionAnalysis>();
                    this.check2regionOrRegions.put(checkedCondition, regions);
                    regions.add((RegionAnalysis)regionOrRegions);
                    regions.add(producingRegionAnalysis);
                }
            } else {
                @NonNull Set regions = (Set)regionOrRegions;
                regions.add(producingRegionAnalysis);
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull Map<@NonNull CheckedCondition, @NonNull Object> analyze() {
            Object region = this.regionAnalysis.getRegion();
            @NonNull Iterable headNodes = QVTscheduleUtil.getHeadNodes(region);
            Iterable<@NonNull Node> constantInputNodes = this.regionAnalysis.getConstantInputNodes();
            @NonNull Iterable rootNodes = Iterables.concat((Iterable)headNodes, constantInputNodes);
            Iterable<@NonNull NavigableEdge> navigableEdges = this.regionAnalysis.getOldPrimaryNavigableEdges();
            ReachabilityForest checkedReachabilityForest = new ReachabilityForest(rootNodes, navigableEdges);
            RegionAnalysis regionAnalysis = FallibilityAnalysis.this.transformationAnalysis.getRegionAnalysis((Region)region);
            CheckedConditionAnalysis analysis = new CheckedConditionAnalysis(regionAnalysis, checkedReachabilityForest){

                @Override
                protected @Nullable Set<@NonNull Property> computeCheckedProperties() {
                    return null;
                }
            };
            Set<@NonNull CheckedCondition> checkedConditions = analysis.computeCheckedConditions();
            for (CheckedCondition checkedCondition : checkedConditions) {
                checkedCondition.accept(this);
            }
            return this.check2regionOrRegions;
        }

        @Override
        public Object visitCastEdgeCheckedCondition(@NonNull CastEdgeCheckedCondition castEdgeCheckedCondition) {
            NavigableEdge castEdge = castEdgeCheckedCondition.getCastEdge();
            Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)castEdge);
            if (!sourceNode.isDispatch()) {
                this.addFallibility(castEdgeCheckedCondition, FallibilityAnalysis.this.getFailSometimes());
            }
            return null;
        }

        @Override
        public Object visitCastInitializerCheckedCondition(@NonNull CastInitializerCheckedCondition castInitializerCheckedCondition) {
            this.addFallibility(castInitializerCheckedCondition, FallibilityAnalysis.this.getFailSometimes());
            return null;
        }

        @Override
        public Object visitConstantTargetCheckedCondition(@NonNull ConstantTargetCheckedCondition constantTargetCheckedCondition) {
            this.addFallibility(constantTargetCheckedCondition, FallibilityAnalysis.this.getFailSometimes());
            return null;
        }

        @Override
        public Object visitMultipleEdgeCheckedCondition(@NonNull MultipleEdgeCheckedCondition multipleEdgeCheckedCondition) {
            this.addFallibility(multipleEdgeCheckedCondition, FallibilityAnalysis.this.getFailSometimes());
            return null;
        }

        @Override
        public Object visitNavigableEdgeCheckedCondition(@NonNull NavigableEdgeCheckedCondition navigableEdgeCheckedCondition) {
            this.addFallibility(navigableEdgeCheckedCondition, FallibilityAnalysis.this.getFailSometimes());
            return null;
        }

        @Override
        public Object visitNonNullInitializerCheckedCondition(@NonNull NonNullInitializerCheckedCondition nonNullInitializerCheckedCondition) {
            this.addFallibility(nonNullInitializerCheckedCondition, FallibilityAnalysis.this.getFailSometimes());
            return null;
        }

        @Override
        public Object visitPredicateEdgeCheckedCondition(@NonNull PredicateEdgeCheckedCondition predicateEdgeCheckedCondition) {
            this.addFallibility(predicateEdgeCheckedCondition, FallibilityAnalysis.this.getFailSometimes());
            return null;
        }

        @Override
        public Object visitPredicateNavigationEdgeCheckedCondition(@NonNull PredicateNavigationEdgeCheckedCondition predicateNavigationEdgeCheckedCondition) {
            boolean allSuccessesResolved = true;
            NavigationEdge navigationEdge = predicateNavigationEdgeCheckedCondition.getNavigationEdge();
            if (!navigationEdge.isSuccess()) {
                allSuccessesResolved = false;
            } else {
                Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)navigationEdge);
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)navigationEdge);
                if (!(targetNode instanceof BooleanLiteralNode) || !((BooleanLiteralNode)targetNode).isBooleanValue()) {
                    allSuccessesResolved = false;
                } else {
                    ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)sourceNode);
                    Iterable<@NonNull RuleRegion> contentsGetProducingRegions = FallibilityAnalysis.this.originalContentsAnalysis.getProducingRegions(classDatum);
                    for (RuleRegion producingRegion : contentsGetProducingRegions) {
                        RegionAnalysis producingRegionAnalysis = FallibilityAnalysis.this.transformationAnalysis.getRegionAnalysis((Region)producingRegion);
                        this.addFallibility(predicateNavigationEdgeCheckedCondition, producingRegionAnalysis);
                    }
                }
            }
            if (!allSuccessesResolved) {
                this.addFallibility(predicateNavigationEdgeCheckedCondition, FallibilityAnalysis.this.getFailSometimes());
            }
            return null;
        }
    }
}

