/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.PrimitiveLiteralExp;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.pivot.qvtcore.util.AbstractExtendingQVTcoreVisitor;

public class IsConstantExpressionVisitor
extends AbstractExtendingQVTcoreVisitor<Boolean, Object> {
    protected final @Nullable Set<@NonNull Object> knownConstants;
    private Set<@NonNull Object> myConstants = null;

    public IsConstantExpressionVisitor(@Nullable Set<@NonNull Object> knownConstants) {
        super(null);
        this.knownConstants = knownConstants;
    }

    public boolean isConstant(@Nullable Visitable visitable) {
        return visitable != null && (Boolean)visitable.accept((Visitor)this) != false;
    }

    public boolean isConstant(@Nullable Iterable<? extends Visitable> visitables) {
        if (visitables != null) {
            for (Visitable visitable : visitables) {
                if (this.isConstant(visitable)) continue;
                return false;
            }
        }
        return true;
    }

    public @NonNull Boolean visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    public @NonNull Boolean visitCollectionItem(@NonNull CollectionItem collectionItem) {
        return this.isConstant((Visitable)collectionItem.getOwnedItem());
    }

    public @NonNull Boolean visitCollectionLiteralExp(@NonNull CollectionLiteralExp collectionLiteralExp) {
        return this.isConstant(collectionLiteralExp.getOwnedParts());
    }

    public @NonNull Boolean visitCollectionRange(@NonNull CollectionRange collectionRange) {
        if (this.isConstant((Visitable)collectionRange.getOwnedFirst()) && this.isConstant((Visitable)collectionRange.getOwnedLast())) {
            return true;
        }
        return false;
    }

    public @NonNull Boolean visitElement(@NonNull Element element) {
        return false;
    }

    public @NonNull Boolean visitEnumLiteralExp(@NonNull EnumLiteralExp enumLiteralExp) {
        return true;
    }

    public @NonNull Boolean visitIfExp(@NonNull IfExp ifExp) {
        if (this.isConstant((Visitable)ifExp.getOwnedCondition()) && this.isConstant((Visitable)ifExp.getOwnedThen()) && this.isConstant((Visitable)ifExp.getOwnedElse())) {
            return true;
        }
        return false;
    }

    public @NonNull Boolean visitLetExp(@NonNull LetExp letExp) {
        if (this.isConstant((Visitable)letExp.getOwnedVariable()) && this.isConstant((Visitable)letExp.getOwnedIn())) {
            return true;
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Boolean visitLoopExp(@NonNull LoopExp loopExp) {
        if (!this.isConstant((Visitable)loopExp.getOwnedSource())) {
            return false;
        }
        if (this.myConstants == null) {
            this.myConstants = this.knownConstants != null ? new HashSet<Object>(this.knownConstants) : new HashSet<Object>();
        }
        @NonNull Iterable ownedIterators = PivotUtil.getOwnedIterators((LoopExp)loopExp);
        Iterables.addAll(this.myConstants, (Iterable)ownedIterators);
        if (this.isConstant(ownedIterators) && this.isConstant((Visitable)loopExp.getOwnedBody())) {
            return true;
        }
        return false;
    }

    public @NonNull Boolean visitMapLiteralExp(@NonNull MapLiteralExp mapLiteralExp) {
        return this.isConstant(mapLiteralExp.getOwnedParts());
    }

    public @NonNull Boolean visitMapLiteralPart(@NonNull MapLiteralPart mapLiteralPart) {
        if (this.isConstant((Visitable)mapLiteralPart.getOwnedKey()) && this.isConstant((Visitable)mapLiteralPart.getOwnedValue())) {
            return true;
        }
        return false;
    }

    public @NonNull Boolean visitNavigationCallExp(@NonNull NavigationCallExp navigationCallExp) {
        return this.isConstant((Visitable)navigationCallExp.getOwnedSource());
    }

    public @NonNull Boolean visitOperationCallExp(@NonNull OperationCallExp operationCallExp) {
        if (this.isConstant((Visitable)operationCallExp.getOwnedSource()) && this.isConstant(operationCallExp.getOwnedArguments())) {
            return true;
        }
        return false;
    }

    public @NonNull Boolean visitPrimitiveLiteralExp(@NonNull PrimitiveLiteralExp object) {
        return true;
    }

    public @NonNull Boolean visitShadowExp(@NonNull ShadowExp shadowExp) {
        return this.isConstant(shadowExp.getOwnedParts());
    }

    public @NonNull Boolean visitShadowPart(@NonNull ShadowPart shadowPart) {
        return this.isConstant((Visitable)shadowPart.getOwnedInit());
    }

    public @NonNull Boolean visitTupleLiteralExp(@NonNull TupleLiteralExp tupleLiteralExp) {
        return this.isConstant(tupleLiteralExp.getOwnedParts());
    }

    public @NonNull Boolean visitTupleLiteralPart(@NonNull TupleLiteralPart tupleLiteralPart) {
        return this.isConstant((Visitable)tupleLiteralPart.getOwnedInit());
    }

    public @NonNull Boolean visitTypeExp(@NonNull TypeExp typeExp) {
        return true;
    }

    public @NonNull Boolean visitVariable(@NonNull Variable variable) {
        if (this.isConstant((Visitable)variable.getOwnedInit())) {
            return true;
        }
        if (this.myConstants != null) {
            return this.myConstants.contains(variable);
        }
        if (this.knownConstants != null) {
            return this.knownConstants.contains(variable);
        }
        return false;
    }

    public @NonNull Boolean visitVariableExp(@NonNull VariableExp variableExp) {
        return this.isConstant((Visitable)variableExp.getReferredVariable());
    }
}

