/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorVariable;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.NumericLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.BasicPartition2Mapping;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionRangeNode;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.EnumLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.IfNode;
import org.eclipse.qvtd.pivot.qvtschedule.IteratorNode;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NullLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.NumericLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.OperationCallNode;
import org.eclipse.qvtd.pivot.qvtschedule.OperationParameterEdge;
import org.eclipse.qvtd.pivot.qvtschedule.OperationSelfEdge;
import org.eclipse.qvtd.pivot.qvtschedule.PatternTypedNode;
import org.eclipse.qvtd.pivot.qvtschedule.PatternVariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.ShadowNode;
import org.eclipse.qvtd.pivot.qvtschedule.ShadowPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.StringLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessNode;
import org.eclipse.qvtd.pivot.qvtschedule.TypeLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.util.AbstractExtendingQVTscheduleVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeLibraryHelper;

public class QVTs2QVTiNodeVisitor
extends AbstractExtendingQVTscheduleVisitor<TypedElement, BasicPartition2Mapping> {
    private static int depth = 0;
    protected final @NonNull QVTimperativeHelper helper;
    protected final @NonNull QVTruntimeLibraryHelper qvtruntimeLibraryHelper;
    protected final @NonNull Set<@NonNull Edge> resultEdges = new HashSet<Edge>();

    public QVTs2QVTiNodeVisitor(@NonNull BasicPartition2Mapping context) {
        super((Object)context);
        this.helper = context.getHelper();
        this.qvtruntimeLibraryHelper = context.getQVTruntimeLibraryHelper();
    }

    @Deprecated
    protected @Nullable OCLExpression basicGetExpression(@NonNull Node node) {
        return (OCLExpression)this.basicGetTypedElement(node);
    }

    protected @Nullable TypedElement basicGetTypedElement(@NonNull Node node) {
        if (++depth > 50) {
            throw new IllegalStateException();
        }
        try {
            VariableDeclaration variable = ((BasicPartition2Mapping)this.context).basicGetVariable(node);
            if (variable != null) {
                assert (!node.isNullLiteral());
                VariableExp variableExp = PivotUtil.createVariableExp((VariableDeclaration)variable);
                return variableExp;
            }
            if (node.isThis()) {
                VariableExp variableExp = ((BasicPartition2Mapping)this.context).createContextVariableExp();
                return variableExp;
            }
            TypedElement typedElement = (TypedElement)node.accept((Visitor)this);
            return typedElement;
        }
        finally {
            --depth;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable LoopExp doIterationCallNode(@NonNull OperationCallNode node) {
        OperationParameterEdge operationParameterEdge;
        Parameter referredParameter;
        Parameter loopSourceParameter = this.qvtruntimeLibraryHelper.getLoopSourceParameter();
        Parameter loopBodyParameter = this.qvtruntimeLibraryHelper.getLoopBodyParameter();
        Parameter loopIteratorsParameter = this.qvtruntimeLibraryHelper.getLoopIteratorsParameter();
        Iteration referredIteration = (Iteration)QVTscheduleUtil.getReferredOperation((OperationCallNode)node);
        OCLExpression sourceExp = null;
        OCLExpression bodyExp = null;
        @NonNull List iterators = QVTbaseUtil.Internal.getOwnedIteratorsList((Iteration)referredIteration);
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            OperationParameterEdge operationParameterEdge2;
            Parameter referredParameter2;
            if (!(edge instanceof OperationParameterEdge) || (referredParameter2 = (operationParameterEdge2 = (OperationParameterEdge)edge).getReferredParameter()) != loopSourceParameter) continue;
            Node expNode = operationParameterEdge2.getEdgeSource();
            sourceExp = this.getExpression(expNode);
        }
        assert (sourceExp != null);
        Type sourceType = PivotUtil.getElementType((CollectionType)((CollectionType)PivotUtil.getType(sourceExp)));
        ArrayList<@NonNull IteratorVariable> variables = new ArrayList<IteratorVariable>(iterators.size());
        int i = 0;
        while (i < iterators.size()) {
            Parameter iterator = (Parameter)iterators.get(i);
            IteratorVariable variable = this.helper.createIteratorVariable(PivotUtil.getName((NamedElement)iterator), sourceType, sourceExp.isIsRequired());
            variables.add(variable);
            ++i;
        }
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!(edge instanceof OperationParameterEdge) || (referredParameter = (operationParameterEdge = (OperationParameterEdge)edge).getReferredParameter()) != loopIteratorsParameter) continue;
            int index = operationParameterEdge.getParameterIndex();
            Node expNode = operationParameterEdge.getEdgeSource();
            ((BasicPartition2Mapping)this.context).addVariable(expNode, (VariableDeclaration)variables.get(index));
        }
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!(edge instanceof OperationParameterEdge) || (referredParameter = (operationParameterEdge = (OperationParameterEdge)edge).getReferredParameter()) != loopBodyParameter) continue;
            Node expNode = operationParameterEdge.getEdgeSource();
            bodyExp = this.getExpression(expNode);
        }
        assert (bodyExp != null);
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!(edge instanceof OperationParameterEdge) || (referredParameter = (operationParameterEdge = (OperationParameterEdge)edge).getReferredParameter()) != loopIteratorsParameter) continue;
            Node expNode = operationParameterEdge.getEdgeSource();
            ((BasicPartition2Mapping)this.context).removeVariable(expNode);
        }
        return this.helper.createIteratorExp(sourceExp, referredIteration, variables, bodyExp);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable OperationCallExp doOperationCallNode(@NonNull OperationCallNode node) {
        Operation referredOperation = QVTscheduleUtil.getReferredOperation((OperationCallNode)node);
        VariableExp sourceExp = null;
        @NonNull List parameters = QVTbaseUtil.Internal.getOwnedParametersList((Operation)referredOperation);
        ArrayList<@Nullable OCLExpression> argExps = new ArrayList<OCLExpression>(parameters.size());
        int i = 0;
        while (i < parameters.size()) {
            argExps.add(null);
            ++i;
        }
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            QVTs2QVTiNodeVisitor expressionCreator;
            Node expNode;
            if (edge.isExpression() && edge instanceof OperationSelfEdge) {
                OperationSelfEdge operationSelfEdge = (OperationSelfEdge)edge;
                expNode = operationSelfEdge.getEdgeSource();
                expressionCreator = new QVTs2QVTiNodeVisitor((BasicPartition2Mapping)this.context);
                sourceExp = expressionCreator.getExpression(expNode);
                continue;
            }
            if (!(edge instanceof OperationParameterEdge)) continue;
            OperationParameterEdge operationParameterEdge = (OperationParameterEdge)edge;
            expNode = operationParameterEdge.getEdgeSource();
            expressionCreator = new QVTs2QVTiNodeVisitor((BasicPartition2Mapping)this.context);
            OCLExpression nestedExp = expressionCreator.getExpression(expNode);
            int index = parameters.indexOf(operationParameterEdge.getReferredParameter());
            if (index < 0) continue;
            OCLExpression oldExpression = argExps.set(index, nestedExp);
            assert (oldExpression == null);
        }
        for (OCLExpression exp : argExps) {
            if (exp != null) continue;
            return null;
        }
        if (sourceExp == null && referredOperation instanceof Function) {
            sourceExp = ((BasicPartition2Mapping)this.context).createContextVariableExp();
        }
        return this.helper.createOperationCallExp(sourceExp, referredOperation, ClassUtil.nullFree(argExps));
    }

    protected @Nullable TypedElement doPatternNode(@NonNull Node node) {
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            VariableDeclaration referredVariable;
            if (!edge.isExpression() || !this.resultEdges.add(edge)) continue;
            Node expNode = edge.getEdgeSource();
            OCLExpression clonedElement = this.getExpression(expNode);
            if (clonedElement instanceof VariableExp && (referredVariable = ((VariableExp)clonedElement).getReferredVariable()) instanceof Variable) {
                ((BasicPartition2Mapping)this.context).addVariable(node, referredVariable);
            }
            return clonedElement;
        }
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            NavigationEdge navigationEdge;
            NavigationEdge oppositeEdge;
            assert (!edge.isCast());
            if (!edge.isNavigation() || !this.resultEdges.add(edge) || (oppositeEdge = (navigationEdge = (NavigationEdge)edge).getOppositeEdge()) != null && !this.resultEdges.add((Edge)oppositeEdge)) continue;
            Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
            if (edgeRole == Role.LOADED) {
                OCLExpression source = this.getExpression(edge.getEdgeSource());
                return this.helper.createNavigationCallExp(source, QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge));
            }
            if (edgeRole != Role.PREDICATED) continue;
            OCLExpression source = this.getExpression(edge.getEdgeSource());
            return this.helper.createNavigationCallExp(source, QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge));
        }
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!edge.isExpression()) continue;
            OCLExpression source = this.getExpression(edge.getEdgeSource());
            return source;
        }
        return null;
    }

    public @NonNull OCLExpression getExpression(@NonNull Node node) {
        return (OCLExpression)ClassUtil.nonNullState((Object)((OCLExpression)this.basicGetTypedElement(node)));
    }

    public @NonNull OCLExpression visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    public @NonNull BooleanLiteralExp visitBooleanLiteralNode(@NonNull BooleanLiteralNode node) {
        return this.helper.createBooleanLiteralExp(node.isBooleanValue());
    }

    public @NonNull CollectionLiteralExp visitCollectionLiteralNode(@NonNull CollectionLiteralNode node) {
        CollectionType asType = (CollectionType)node.getClassDatum().getPrimaryClass();
        final HashMap<@NonNull CollectionLiteralPart, @NonNull Integer> part2index = new HashMap<CollectionLiteralPart, Integer>();
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!(edge instanceof CollectionPartEdge)) continue;
            CollectionPartEdge collectionPartEdge = (CollectionPartEdge)edge;
            CollectionLiteralPart oldCollectionLiteralPart = collectionPartEdge.getReferredPart();
            CollectionLiteralExp oldCollectionLiteralExp = (CollectionLiteralExp)oldCollectionLiteralPart.eContainer();
            int index = oldCollectionLiteralExp.getOwnedParts().indexOf(oldCollectionLiteralPart);
            Node expNode = collectionPartEdge.getEdgeSource();
            TypedElement typedElement = (TypedElement)ClassUtil.nonNullState((Object)this.basicGetTypedElement(expNode));
            Object collectionLiteralPart = null;
            collectionLiteralPart = typedElement instanceof CollectionLiteralPart ? (CollectionLiteralPart)typedElement : this.helper.createCollectionItem((OCLExpression)typedElement);
            part2index.put((CollectionLiteralPart)collectionLiteralPart, index);
        }
        ArrayList<@NonNull K> asParts = new ArrayList(part2index.keySet());
        Collections.sort(asParts, new Comparator<CollectionLiteralPart>(){

            @Override
            public int compare(@NonNull CollectionLiteralPart o1, @NonNull CollectionLiteralPart o2) {
                Integer i1 = (Integer)part2index.get(o1);
                Integer i2 = (Integer)part2index.get(o2);
                if (!($assertionsDisabled || i1 != null && i2 != null)) {
                    throw new AssertionError();
                }
                return i1 - i2;
            }
        });
        return this.helper.createCollectionLiteralExp(asType, asParts);
    }

    public @NonNull CollectionRange visitCollectionRangeNode(@NonNull CollectionRangeNode node) {
        Parameter rangeFirstParameter = this.qvtruntimeLibraryHelper.getRangeFirstParameter();
        Parameter rangeLastParameter = this.qvtruntimeLibraryHelper.getRangeLastParameter();
        OCLExpression asFirst = null;
        OCLExpression asLast = null;
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            Node expNode;
            if (!(edge instanceof OperationParameterEdge)) continue;
            OperationParameterEdge operationParameterEdge = (OperationParameterEdge)edge;
            Parameter referredParameter = operationParameterEdge.getReferredParameter();
            if (referredParameter == rangeFirstParameter) {
                expNode = operationParameterEdge.getEdgeSource();
                asFirst = this.getExpression(expNode);
                continue;
            }
            if (referredParameter != rangeLastParameter) continue;
            expNode = operationParameterEdge.getEdgeSource();
            asLast = this.getExpression(expNode);
        }
        assert (asFirst != null && asLast != null);
        return this.helper.createCollectionRange(asFirst, asLast);
    }

    public @Nullable OCLExpression visitEnumLiteralNode(@NonNull EnumLiteralNode node) {
        return this.helper.createEnumLiteralExp(QVTscheduleUtil.getEnumValue((EnumLiteralNode)node));
    }

    public @Nullable IfExp visitIfNode(@NonNull IfNode node) {
        OCLExpression conditionExp = null;
        OCLExpression thenExp = null;
        OCLExpression elseExp = null;
        Parameter conditionParameter = this.qvtruntimeLibraryHelper.getIfConditionParameter();
        Parameter thenParameter = this.qvtruntimeLibraryHelper.getIfThenParameter();
        Parameter elseParameter = this.qvtruntimeLibraryHelper.getIfElseParameter();
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!edge.isExpression() || !(edge instanceof OperationParameterEdge)) continue;
            OperationParameterEdge operationParameterEdge = (OperationParameterEdge)edge;
            Node expNode = operationParameterEdge.getEdgeSource();
            OCLExpression nestedExp = this.getExpression(expNode);
            Parameter parameter = operationParameterEdge.getReferredParameter();
            if (parameter == conditionParameter) {
                conditionExp = nestedExp;
                continue;
            }
            if (parameter == thenParameter) {
                thenExp = nestedExp;
                continue;
            }
            if (parameter != elseParameter) continue;
            elseExp = nestedExp;
        }
        if (conditionExp != null && thenExp != null && elseExp != null) {
            return this.helper.createIfExp(conditionExp, thenExp, elseExp);
        }
        return null;
    }

    public @Nullable TypedElement visitIteratorNode(@NonNull IteratorNode node) {
        Parameter loopIteratorsParameter = this.qvtruntimeLibraryHelper.getLoopIteratorsParameter();
        for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
            OperationParameterEdge operationParameterEdge;
            Parameter referredParameter;
            if (!(edge instanceof OperationParameterEdge) || (referredParameter = (operationParameterEdge = (OperationParameterEdge)edge).getReferredParameter()) != loopIteratorsParameter) continue;
            Node expNode = operationParameterEdge.getEdgeTarget();
            this.getExpression(expNode);
        }
        VariableDeclaration variable = ((BasicPartition2Mapping)this.context).getVariable((Node)node);
        return PivotUtil.createVariableExp((VariableDeclaration)variable);
    }

    public @NonNull NullLiteralExp visitNullLiteralNode(@NonNull NullLiteralNode node) {
        return this.helper.createNullLiteralExp();
    }

    public @NonNull NumericLiteralExp visitNumericLiteralNode(@NonNull NumericLiteralNode node) {
        Number numericValue = (Number)ClassUtil.nonNullState((Object)node.getNumericValue());
        if (numericValue instanceof Byte || numericValue instanceof Integer || numericValue instanceof Long || numericValue instanceof Short) {
            return this.helper.createIntegerLiteralExp(numericValue);
        }
        return this.helper.createRealLiteralExp(numericValue);
    }

    public @Nullable CallExp visitOperationCallNode(@NonNull OperationCallNode node) {
        Operation iOperation;
        Operation asOperation = node.getReferredOperation();
        if (asOperation instanceof Iteration) {
            return this.doIterationCallNode(node);
        }
        OperationCallExp asOperationCallExp = this.doOperationCallNode(node);
        if (asOperation instanceof Function && asOperationCallExp != null && (iOperation = ((BasicPartition2Mapping)this.context).createOperation(asOperation)) != asOperation) {
            asOperationCallExp.setReferredOperation(iOperation);
        }
        return asOperationCallExp;
    }

    public @Nullable TypedElement visitPatternTypedNode(@NonNull PatternTypedNode node) {
        return this.doPatternNode((Node)node);
    }

    public @Nullable TypedElement visitPatternVariableNode(@NonNull PatternVariableNode node) {
        return this.doPatternNode((Node)node);
    }

    public @Nullable TypedElement visitShadowNode(@NonNull ShadowNode node) {
        ArrayList<@NonNull ShadowPart> asParts = new ArrayList<ShadowPart>();
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!(edge instanceof ShadowPartEdge)) continue;
            ShadowPartEdge shadowPartEdge = (ShadowPartEdge)edge;
            ShadowPart referredPart = QVTscheduleUtil.getReferredPart((ShadowPartEdge)shadowPartEdge);
            Property referredProperty = PivotUtil.getReferredProperty((ShadowPart)referredPart);
            Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)shadowPartEdge);
            asParts.add(this.helper.createShadowPart(referredProperty, this.getExpression(sourceNode)));
        }
        @NonNull Class asClass = node.getClassDatum().getPrimaryClass();
        return this.helper.createShadowExp(asClass, asParts);
    }

    public @NonNull OCLExpression visitStringLiteralNode(@NonNull StringLiteralNode node) {
        return this.helper.createStringLiteralExp((String)ClassUtil.nonNullState((Object)node.getStringValue()));
    }

    public @Nullable TypedElement visitSuccessNode(@NonNull SuccessNode node) {
        return this.doPatternNode((Node)node);
    }

    public @NonNull OCLExpression visitTypeLiteralNode(@NonNull TypeLiteralNode node) {
        return this.helper.createTypeExp((Type)ClassUtil.nonNullState((Object)node.getTypeValue()));
    }
}

