/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.imp.builder.BuilderBase;
import org.eclipse.imp.builder.BuilderUtils;
import org.eclipse.imp.builder.DependencyInfo;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.qvt.declarative.ecore.utils.TracingOption;
import org.eclipse.qvt.declarative.editor.ui.ICreationFactory;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonBuilder
extends BuilderBase {
    public static TracingOption builderDependencies = new TracingOption(QVTEditorPlugin.PLUGIN_ID, "builder/dependencies");
    private static Map<String, Map<IFile, List<BuilderListener>>> builderListenerMap = null;
    protected final ICreationFactory creationFactory;

    public static void addBuilderListener(String builderId, IFile file, BuilderListener listener) {
        List<BuilderListener> builderListeners;
        Map<IFile, List<BuilderListener>> map;
        if (builderListenerMap == null) {
            builderListenerMap = new HashMap<String, Map<IFile, List<BuilderListener>>>();
        }
        if ((map = builderListenerMap.get(builderId)) == null) {
            map = new HashMap<IFile, List<BuilderListener>>();
            builderListenerMap.put(builderId, map);
        }
        if ((builderListeners = map.get(file)) == null) {
            builderListeners = new ArrayList<BuilderListener>();
            map.put(file, builderListeners);
        }
        builderListeners.add(listener);
    }

    public static void removeBuilderListener(String builderId, IFile file, BuilderListener listener) {
        List<BuilderListener> builderListeners;
        Map<IFile, List<BuilderListener>> map;
        if (builderListenerMap != null && (map = builderListenerMap.get(builderId)) != null && (builderListeners = map.get(file)) != null) {
            builderListeners.remove(listener);
        }
    }

    public static void reset() {
        builderListenerMap = null;
    }

    protected CommonBuilder(ICreationFactory creationFactory) {
        this.creationFactory = creationFactory;
    }

    protected void collectDependencies(IFile file) {
    }

    /*
     * Unable to fully structure code
     */
    protected void compile(IFile inputFile, IProgressMonitor monitor) {
        block13: {
            block12: {
                block14: {
                    builderListeners = null;
                    if (CommonBuilder.builderListenerMap != null && (map = CommonBuilder.builderListenerMap.get(this.creationFactory.getBuilderId())) != null) {
                        builderListeners = map.get(inputFile);
                    }
                    if (builderListeners != null) {
                        for (BuilderListener builderListener : builderListeners) {
                            builderListener.beginBuild(inputFile);
                        }
                    }
                    projectRelativeInputPath = inputFile.getProjectRelativePath();
                    workspaceRelativeOutputPath = this.getWorkspaceRelativeOutputFilePath(inputFile);
                    outputFile = this.getProject().getFile(workspaceRelativeOutputPath.removeFirstSegments(1));
                    this.getPlugin().writeInfoMsg("Building " + this.creationFactory.getLanguageID() + " input file: '" + inputFile.getName() + "', output file: '" + outputFile.getName() + "'");
                    problemHandler = this.creationFactory.createProblemHandler(inputFile);
                    try {
                        try {
                            parseController = this.createParseController();
                            sourceProject = ModelFactory.open((IProject)inputFile.getProject());
                            parseController.initialize(projectRelativeInputPath, sourceProject, (IMessageHandler)problemHandler);
                            contents = BuilderUtils.getFileContents((IFile)inputFile);
                            parsedResult = parseController.parseWithoutCaching(contents, monitor);
                            uri = URI.createURI((String)outputFile.getLocationURI().toString());
                            resource = parsedResult.getAST();
                            if (resource != null) {
                                resource.setURI(uri);
                                resource.save(null);
                            }
                            this.doRefresh((IResource)outputFile.getParent());
                            break block12;
                        }
                        catch (Exception e) {
                            this.getPlugin().logException("Failed to compile '" + inputFile.toString() + "'", (Throwable)e);
                            problemHandler.flush(BasicMonitor.toMonitor((IProgressMonitor)monitor));
                            if (builderListeners == null) break block13;
                            ** for (builderListener : builderListeners)
                        }
                    }
                    catch (Throwable var14_21) {
                        problemHandler.flush(BasicMonitor.toMonitor((IProgressMonitor)monitor));
                        if (builderListeners == null) break block14;
                        ** for (builderListener : builderListeners)
                    }
lbl-1000:
                    // 1 sources

                    {
                        builderListener.endBuild(inputFile);
                        continue;
lbl34:
                        // 1 sources

                        break block13;
                    }
lbl-1000:
                    // 1 sources

                    {
                        builderListener.endBuild(inputFile);
                        continue;
                    }
                }
                throw var14_21;
            }
            problemHandler.flush(BasicMonitor.toMonitor((IProgressMonitor)monitor));
            if (builderListeners != null) {
                for (BuilderListener builderListener : builderListeners) {
                    builderListener.endBuild(inputFile);
                }
            }
        }
    }

    protected DependencyInfo createDependencyInfo(IProject project) {
        return new DependencyInfo(project){

            public void dump() {
                if (builderDependencies.isActive()) {
                    super.dump();
                }
            }
        };
    }

    protected ICommonParseController createParseController() {
        return this.creationFactory.createParseController();
    }

    protected IClasspathEntry[] getClasspathEntries(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return null;
        }
        try {
            return javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    protected IClasspathEntry getClasspathEntry(IFile file, IClasspathEntry[] resolvedClasspath) {
        IPath workspaceRelativeInputPath = file.getFullPath();
        IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
        int n = resolvedClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IPath sourcePath;
            IClasspathEntry resolvedClasspathEntry = iClasspathEntryArray[n2];
            if (resolvedClasspathEntry.getEntryKind() == 3 && (sourcePath = resolvedClasspathEntry.getPath()).isPrefixOf(workspaceRelativeInputPath)) {
                return resolvedClasspathEntry;
            }
            ++n2;
        }
        return null;
    }

    public ICreationFactory getCreationFactory() {
        return this.creationFactory;
    }

    public String getErrorMarkerID() {
        return this.creationFactory.getErrorMarkerId();
    }

    public String getInfoMarkerID() {
        return this.creationFactory.getInfoMarkerId();
    }

    public Language getLanguage() {
        return this.creationFactory.getLanguage();
    }

    public String getLanguageID() {
        return this.creationFactory.getLanguageID();
    }

    @Deprecated
    public String getLanguageName() {
        return this.getLanguageID();
    }

    protected List<File> getSourceFolders(IPath projectRelativeInputPath) {
        IClasspathEntry[] resolvedClasspath;
        IProject inputContainer;
        ArrayList<File> srcFolders = new ArrayList<File>();
        IPath inputPathParent = projectRelativeInputPath.removeLastSegments(1);
        Object object = inputContainer = inputPathParent.segmentCount() > 0 ? this.getProject().getFile(inputPathParent) : this.getProject();
        if (inputContainer != null) {
            srcFolders.add(inputContainer.getLocation().toFile());
        }
        if ((resolvedClasspath = this.getClasspathEntries(this.getProject())) != null) {
            IWorkspaceRoot workspaceRoot = this.getProject().getWorkspace().getRoot();
            IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
            int n = resolvedClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IFile sourceContainer;
                IClasspathEntry resolvedClasspathEntry = iClasspathEntryArray[n2];
                if (resolvedClasspathEntry.getEntryKind() == 3 && (sourceContainer = workspaceRoot.getFile(resolvedClasspathEntry.getPath())) != null) {
                    srcFolders.add(sourceContainer.getLocation().toFile());
                }
                ++n2;
            }
        }
        return srcFolders;
    }

    public String getWarningMarkerID() {
        return this.creationFactory.getWarningMarkerId();
    }

    protected IPath getWorkspaceRelativeOutputFilePath(IFile inputFile) {
        IClasspathEntry classpathEntry;
        IPath workspaceRelativeInputPath;
        IPath workspaceRelativeOutputPath = workspaceRelativeInputPath = inputFile.getFullPath();
        IClasspathEntry[] resolvedClasspath = this.getClasspathEntries(inputFile.getProject());
        IClasspathEntry iClasspathEntry = classpathEntry = resolvedClasspath != null ? this.getClasspathEntry(inputFile, resolvedClasspath) : null;
        if (classpathEntry != null) {
            IPath sourcePath = classpathEntry.getPath();
            IPath outputPath = classpathEntry.getOutputLocation();
            IPath iPath = workspaceRelativeOutputPath = outputPath != null ? outputPath.append(workspaceRelativeInputPath.removeFirstSegments(sourcePath.segmentCount())) : workspaceRelativeInputPath;
        }
        if (this.hasTextExtension(inputFile)) {
            workspaceRelativeOutputPath = workspaceRelativeOutputPath.removeFileExtension();
        }
        return workspaceRelativeOutputPath.addFileExtension(this.creationFactory.getXMLExtension());
    }

    protected boolean hasTextExtension(IFile file) {
        IPath workspaceRelativeInputPath = file.getFullPath();
        String fileExtension = workspaceRelativeInputPath.getFileExtension();
        String[] stringArray = this.creationFactory.getTextExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String textExtension = stringArray[n2];
            if (textExtension.equals(fileExtension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isNonRootSourceFile(IFile resource) {
        return false;
    }

    protected boolean isOutputFolder(IResource resource) {
        IClasspathEntry[] resolvedClasspath = this.getClasspathEntries(resource.getProject());
        if (resolvedClasspath == null) {
            return false;
        }
        IPath workspaceRelativePath = resource.getFullPath();
        IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
        int n = resolvedClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IPath outputPath;
            IClasspathEntry resolvedClasspathEntry = iClasspathEntryArray[n2];
            if (resolvedClasspathEntry.getEntryKind() == 3 && (outputPath = resolvedClasspathEntry.getOutputLocation()) != null && outputPath.isPrefixOf(workspaceRelativePath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isSourceFile(IFile file) {
        if (!this.hasTextExtension(file)) {
            return false;
        }
        IClasspathEntry[] resolvedClasspath = this.getClasspathEntries(file.getProject());
        if (resolvedClasspath == null) {
            return true;
        }
        return this.getClasspathEntry(file, resolvedClasspath) != null;
    }

    public static interface BuilderListener {
        public void beginBuild(IFile var1);

        public void endBuild(IFile var1);
    }
}

