/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.ResourceBundle;
import org.eclipse.imp.actions.FoldingMessages;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextOperationAction;

public class FoldingActionGroup
extends ActionGroup {
    private ProjectionViewer fViewer;
    private final TextOperationAction fExpand;
    private final TextOperationAction fCollapse;
    private final TextOperationAction fExpandAll;
    private final IProjectionListener fProjectionListener;
    private final PreferenceAction fRestoreDefaults;
    private final FoldingAction fCollapseMembers;
    private final FoldingAction fCollapseComments;
    private final TextOperationAction fCollapseAll;

    public FoldingActionGroup(final ITextEditor editor, ITextViewer viewer) {
        if (!(viewer instanceof ProjectionViewer)) {
            this.fExpand = null;
            this.fCollapse = null;
            this.fExpandAll = null;
            this.fCollapseAll = null;
            this.fRestoreDefaults = null;
            this.fCollapseMembers = null;
            this.fCollapseComments = null;
            this.fProjectionListener = null;
            return;
        }
        this.fViewer = (ProjectionViewer)viewer;
        this.fProjectionListener = new IProjectionListener(){

            public void projectionEnabled() {
                FoldingActionGroup.this.update();
            }

            public void projectionDisabled() {
                FoldingActionGroup.this.update();
            }
        };
        this.fViewer.addProjectionListener(this.fProjectionListener);
        this.fExpandAll = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.ExpandAll.", editor, 20, true);
        this.fExpandAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand_all");
        editor.setAction("FoldingExpandAll", (IAction)this.fExpandAll);
        this.fCollapseAll = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.CollapseAll.", editor, 21, true);
        this.fCollapseAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse_all");
        editor.setAction("FoldingCollapseAll", (IAction)this.fCollapseAll);
        this.fExpand = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Expand.", editor, 17, true);
        this.fExpand.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand");
        editor.setAction("FoldingExpand", (IAction)this.fExpand);
        this.fCollapse = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Collapse.", editor, 18, true);
        this.fCollapse.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse");
        editor.setAction("FoldingCollapse", (IAction)this.fCollapse);
        this.fRestoreDefaults = new FoldingAction(FoldingMessages.getResourceBundle(), "Projection.Restore."){

            public void run() {
                if (editor instanceof UniversalEditor) {
                    UniversalEditor cfr_ignored_0 = (UniversalEditor)editor;
                }
            }
        };
        this.fRestoreDefaults.setActionDefinitionId("org.eclipse.ui.edit.text.folding.restore");
        editor.setAction("FoldingRestore", (IAction)this.fRestoreDefaults);
        this.fCollapseMembers = new FoldingAction(FoldingMessages.getResourceBundle(), "Projection.CollapseMembers."){

            public void run() {
                if (editor instanceof UniversalEditor) {
                    UniversalEditor cfr_ignored_0 = (UniversalEditor)editor;
                }
            }
        };
        this.fCollapseMembers.setActionDefinitionId("org.eclipse.imp.runtime.editor.folding.collapseMembers");
        editor.setAction("FoldingCollapseMembers", (IAction)this.fCollapseMembers);
        this.fCollapseComments = new FoldingAction(FoldingMessages.getResourceBundle(), "Projection.CollapseComments."){

            public void run() {
                if (editor instanceof UniversalEditor) {
                    UniversalEditor cfr_ignored_0 = (UniversalEditor)editor;
                }
            }
        };
        this.fCollapseComments.setActionDefinitionId("org.eclipse.imp.runtime.editor.folding.collapseComments");
        editor.setAction("FoldingCollapseComments", (IAction)this.fCollapseComments);
    }

    protected boolean isEnabled() {
        return this.fViewer != null;
    }

    public void dispose() {
        if (this.isEnabled()) {
            this.fViewer.removeProjectionListener(this.fProjectionListener);
            this.fViewer = null;
        }
        super.dispose();
    }

    protected void update() {
        if (this.isEnabled()) {
            this.fExpand.update();
            this.fExpandAll.update();
            this.fCollapse.update();
            this.fCollapseAll.update();
            this.fRestoreDefaults.update();
            this.fCollapseMembers.update();
            this.fCollapseComments.update();
        }
    }

    public void fillMenu(IMenuManager manager) {
        if (this.isEnabled()) {
            this.update();
            manager.add((IAction)this.fExpandAll);
            manager.add((IAction)this.fExpand);
            manager.add((IAction)this.fCollapse);
            manager.add((IAction)this.fCollapseAll);
            manager.add((IAction)this.fRestoreDefaults);
            manager.add((IAction)this.fCollapseMembers);
            manager.add((IAction)this.fCollapseComments);
        }
    }

    public void updateActionBars() {
        this.update();
    }

    private class FoldingAction
    extends PreferenceAction {
        FoldingAction(ResourceBundle bundle, String prefix) {
            super(bundle, prefix, 1);
        }

        public void update() {
            this.setEnabled(FoldingActionGroup.this.isEnabled() && FoldingActionGroup.this.fViewer.isProjectionMode());
        }
    }

    private static abstract class PreferenceAction
    extends ResourceAction
    implements IUpdate {
        PreferenceAction(ResourceBundle bundle, String prefix, int style) {
            super(bundle, prefix, style);
        }
    }
}

