/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.indexing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.indexing.IndexContributorBase;
import org.eclipse.imp.indexing.IndexEntry;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.language.LanguageValidator;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.utils.StreamUtils;

public class Indexer {
    private final Language fLanguage;
    private IndexContributorBase fIndexer;
    private IParseController fParser;
    private Set fProjectEntries = new HashSet();

    public Indexer(String languageName) {
        this.fLanguage = LanguageRegistry.findLanguage(languageName);
        this.fIndexer = ServiceFactory.getInstance().getIndexContributor(this.fLanguage);
        this.fParser = ServiceFactory.getInstance().getParseController(this.fLanguage);
    }

    public void loadAll() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            this.load(projects[i]);
            ++i;
        }
    }

    public void load(IProject project) {
        try {
            File file = this.getPersistentIndexFile(project);
            this.readEntries(new BufferedReader(new FileReader(file)));
        }
        catch (IOException iOException) {
            ErrorHandler.reportError("Cannot open persistent index for " + this.fLanguage);
        }
    }

    private void readEntries(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            IndexEntry entry = this.fIndexer.parseEntry(line);
            this.addEntry(entry);
        }
    }

    public void clearEntries() {
        this.fProjectEntries.clear();
    }

    public void addEntry(IndexEntry entry) {
        this.fProjectEntries.add(entry);
    }

    public void createAllIndexes() {
        if (this.fParser == null) {
            RuntimePlugin.getInstance().writeErrorMsg("No parser for language " + this.fLanguage + "; indexing disabled.");
            return;
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            this.clearEntries();
            this.createProjectIndex(projects[i]);
            this.save(projects[i]);
            ++i;
        }
    }

    public void createProjectIndex(IProject project) {
        final LanguageValidator validator = this.fLanguage.getValidator();
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            project.accept(new IResourceProxyVisitor((IProgressMonitor)monitor){
                private final /* synthetic */ IProgressMonitor val$monitor;
                {
                    this.val$monitor = iProgressMonitor;
                }

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getType() == 1) {
                        String name = proxy.getName();
                        if (Indexer.this.fLanguage.hasExtension(name.substring(name.lastIndexOf(46) + 1))) {
                            IFile file = (IFile)proxy.requestResource();
                            if (validator == null || validator.validate(file)) {
                                String contents = StreamUtils.readStreamContents(file.getContents(), file.getCharset());
                                Object ast = Indexer.this.fParser.parse(contents, this.val$monitor);
                                if (ast != null) {
                                    Indexer.this.fIndexer.contributeEntries(ast, Indexer.this);
                                } else {
                                    RuntimePlugin.getInstance().writeErrorMsg("Unable to parse file " + file.getFullPath() + "; indexing suppressed.");
                                }
                            }
                        }
                    }
                    return false;
                }
            }, 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void save(IProject project) {
        try {
            File file = this.getPersistentIndexFile(project);
            FileWriter writer = new FileWriter(file);
            for (IndexEntry entry : this.fProjectEntries) {
                entry.saveToStream(writer);
            }
        }
        catch (IOException e) {
            ErrorHandler.reportError("Cannot open persistent index for " + this.fLanguage + " and project " + project.getName(), e);
        }
    }

    private File getPersistentIndexFile(IProject project) {
        try {
            IPath path = RuntimePlugin.getInstance().getStateLocation().append(project.getName());
            File file = new File(path.toFile(), this.fLanguage + ".index");
            if (!file.exists()) {
                file.createNewFile();
            }
            return file;
        }
        catch (IOException e) {
            ErrorHandler.reportError("Cannot locate index file for " + this.fLanguage + " and project " + project.getName(), e);
            return null;
        }
    }
}

