/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.services.base;

import java.util.Stack;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.editor.ModelTreeNode;
import org.eclipse.imp.language.ILanguageService;

public abstract class TreeModelBuilderBase
implements ILanguageService {
    protected ModelTreeNode fModelRoot;
    private Stack<ModelTreeNode> fItemStack = new Stack();

    public final ModelTreeNode buildTree(Object rootASTNode) {
        this.fModelRoot = this.createTopItem(new ModelTreeNode(rootASTNode));
        this.fItemStack.push(this.fModelRoot);
        try {
            this.visitTree(rootASTNode);
        }
        catch (Exception e) {
            ErrorHandler.reportError("Exception caught from invocation of language-specific tree model builder implementation", e);
        }
        this.fItemStack.pop();
        return this.fModelRoot;
    }

    protected abstract void visitTree(Object var1);

    protected ModelTreeNode createTopItem(Object n) {
        return this.createTopItem(n, 0);
    }

    protected ModelTreeNode createTopItem(Object n, int category) {
        ModelTreeNode treeNode = new ModelTreeNode(n, category);
        return treeNode;
    }

    protected ModelTreeNode createSubItem(Object n) {
        return this.createSubItem(n, 0);
    }

    protected ModelTreeNode createSubItem(Object n, int category) {
        ModelTreeNode parent = this.fItemStack.peek();
        ModelTreeNode treeNode = new ModelTreeNode(n, parent, category);
        parent.addChild(treeNode);
        return treeNode;
    }

    protected ModelTreeNode pushSubItem(Object n) {
        return this.pushSubItem(n, 0);
    }

    protected ModelTreeNode pushSubItem(Object n, int category) {
        return this.fItemStack.push(this.createSubItem(n, category));
    }

    protected void popSubItem() {
        this.fItemStack.pop();
    }
}

