/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.utils;

import org.eclipse.core.runtime.Platform;
import org.eclipse.qvt.declarative.ecore.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TracingOption {
    public static final TracingOption DEBUG = new TracingOption("debug");
    private final String option;
    private boolean resolved = false;
    private boolean state = false;

    public TracingOption(String option) {
        this(Activator.PLUGIN_ID, option);
    }

    public TracingOption(String pluginId, String option) {
        this.option = String.valueOf(pluginId) + "/" + option;
    }

    public boolean isActive() {
        if (!this.resolved) {
            this.state = this.resolveState();
            this.resolved = true;
        }
        return this.state;
    }

    public void println(String string) {
        if (!this.resolved) {
            this.state = this.resolveState();
            this.resolved = true;
        }
        if (this.state) {
            System.out.println(String.valueOf(this.option) + " : " + string);
        }
    }

    public void println(Class<?> clazz, String string) {
        if (!this.resolved) {
            this.state = this.resolveState();
            this.resolved = true;
        }
        if (this.state) {
            System.out.println(String.valueOf(this.option) + " : " + clazz.getSimpleName() + " : " + string);
        }
    }

    public boolean resolveState() {
        String debugOption = Platform.getDebugOption((String)this.option);
        return Boolean.TRUE.toString().equalsIgnoreCase(debugOption);
    }

    public void setState(boolean state) {
        this.state = state;
        this.resolved = true;
    }
}

