/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.text;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.part.FileEditorInput;

public final class LazyFileEditorInput
extends FileEditorInput {
    private boolean hasContents = false;

    public LazyFileEditorInput(IFile file) {
        super(file);
    }

    public LazyFileEditorInput(IFolder tmpdir, String name, String fileExtension) {
        this(tmpdir.getFile(String.valueOf(name) + "$" + fileExtension));
    }

    public boolean hasContents() {
        return this.hasContents;
    }

    public void setContents(InputStream inputStream, IProgressMonitor monitor) throws CoreException {
        IFile file = this.getFile();
        if (!file.exists()) {
            file.create(inputStream, true, monitor);
        } else {
            file.refreshLocal(2, monitor);
            file.setContents(inputStream, true, false, monitor);
        }
        this.hasContents = true;
    }
}

