/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.AbstractStage;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SimpleGroup;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SplitterAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SplitterUtil;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

abstract class HeadedStage
extends AbstractStage {
    protected final @Nullable HeadedStage sourceStage;
    protected final @Nullable Edge edge;
    protected final @NonNull SimpleGroup targetSimpleGroup;
    protected final @NonNull Iterable<@NonNull Node> headNodes;
    protected final @NonNull List<@NonNull Node> navigableNodes;
    protected final @NonNull List<@NonNull Node> computableNodes;
    protected final @NonNull Iterable<@NonNull Node> deadNodes;
    protected final @NonNull Set<@NonNull AbstractStage> successors = new HashSet<AbstractStage>();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected HeadedStage(@NonNull SplitterAnalysis splitter, @Nullable HeadedStage sourceStage, @Nullable Edge edge, @NonNull SimpleGroup targetSimpleGroup) {
        super(splitter);
        this.sourceStage = sourceStage;
        this.edge = edge;
        this.targetSimpleGroup = targetSimpleGroup;
        this.headNodes = targetSimpleGroup.getHeadNodes();
        Iterable<@NonNull Node> allNavigableNodes = targetSimpleGroup.getReachableNodes();
        Set<@NonNull Node> allComputableNodes = SplitterUtil.computeComputableTargetNodes(allNavigableNodes);
        @NonNull HashSet allNodes = Sets.newHashSet(allNavigableNodes);
        allNodes.addAll(allComputableNodes);
        this.deadNodes = this.computeDeadNodes(allNodes);
        this.navigableNodes = Lists.newArrayList(allNavigableNodes);
        this.computableNodes = Lists.newArrayList(allComputableNodes);
        int oldSize = this.computableNodes.size();
        this.computableNodes.removeAll(this.navigableNodes);
        int newSize = this.computableNodes.size();
        assert (oldSize - newSize == this.navigableNodes.size());
        CompilerUtil.removeAll(this.navigableNodes, this.headNodes);
        CompilerUtil.removeAll(this.navigableNodes, this.deadNodes);
        CompilerUtil.removeAll(this.computableNodes, this.deadNodes);
        Collections.sort(this.navigableNodes, NameUtil.NAMEABLE_COMPARATOR);
        Collections.sort(this.computableNodes, NameUtil.NAMEABLE_COMPARATOR);
    }

    public void addSuccessor(@NonNull HeadedStage successorStage) {
        if (this.successors.add(successorStage) && this.sourceStage != null) {
            this.sourceStage.addSuccessor(successorStage);
        }
    }

    @Override
    protected @NonNull String buildContents(@NonNull StringBuilder s) {
        this.build(s, "head nodes", this.headNodes);
        this.build(s, "navigable nodes", this.navigableNodes);
        this.build(s, "computable nodes", this.computableNodes);
        this.build(s, "dead nodes", this.deadNodes);
        return this.targetSimpleGroup.getName();
    }

    @Override
    public void check() {
        HashSet<@NonNull Node> accumulator = new HashSet<Node>();
        this.checkAccumulate(accumulator, this.headNodes);
        this.checkAccumulate(accumulator, this.navigableNodes);
        this.checkAccumulate(accumulator, this.computableNodes);
        this.checkAccumulate(accumulator, this.deadNodes);
        Set<@NonNull Node> navigableNodes = SplitterUtil.computeNavigableNodes(this.headNodes);
        Set<@NonNull Node> computableNodes = SplitterUtil.computeComputableTargetNodes(navigableNodes);
        assert (computableNodes.containsAll(navigableNodes));
        HashSet<@NonNull Node> allNodes = new HashSet<Node>(navigableNodes);
        allNodes.addAll(computableNodes);
        this.checkAccumulated(accumulator, allNodes);
    }

    @Override
    public @NonNull Iterable<@NonNull Node> getHeadNodes() {
        return this.headNodes;
    }

    @Override
    protected boolean isLive(@NonNull Node node, @NonNull Set<@NonNull Node> deadNodes) {
        if (node.isHead()) {
            return true;
        }
        if (node.isRealized()) {
            return false;
        }
        int bidirectionals = 0;
        for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
            if (edge.isRealized() || deadNodes.contains(edge.getEdgeTarget())) continue;
            if (!SplitterUtil.isBidirectional(edge)) {
                return true;
            }
            ++bidirectionals;
        }
        return bidirectionals > 1;
    }

    @Override
    public void toString(@NonNull StringBuilder s, int depth) {
        Edge edge2 = this.edge;
        if (edge2 != null) {
            CompilerUtil.indent(s, depth);
            s.append(edge2.isComputation() ? "forward-edge : " : "reverse-edge : ");
            s.append(edge2.getName());
            s.append(" : ");
            s.append(edge2);
            s.append("\n");
        }
        CompilerUtil.indent(s, depth);
        s.append("simple-group : ");
        s.append(this.targetSimpleGroup.getName());
        s.append(" : ");
        s.append(this.targetSimpleGroup.getHeadNode());
    }
}

