/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import com.ibm.icu.lang.UCharacter;
import java.io.Reader;
import lpg.lpgjavaruntime.BadParseException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTParsingOptions;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ExternalUnitElementsProvider;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalValidationVisitor;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalVisitorCS;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerMessages;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.cst.CSTFactory;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.AbstractQVTParser;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtOpLPGParser;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtOpLexer;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.osgi.util.NLS;

public class QvtOperationalParser {
    private RunnableQVTParser myParser;

    public static QvtOpLexer createLexer(Reader is, String name, QvtOperationalEnv env) throws ParserException {
        QvtOpLexer lexer = new QvtOpLexer((Environment)env);
        lexer.initialize(QvtOperationalParser.correctLineBreaks(new OCLInput(is)), name);
        return lexer;
    }

    public UnitCS parse(Reader is, String name, QvtOperationalEnv env) {
        MappingModuleCS result = null;
        UnitCS unitCS = CSTFactory.eINSTANCE.createUnitCS();
        try {
            QvtOpLexer lexer = QvtOperationalParser.createLexer(is, name, env);
            unitCS.setStartOffset(0);
            unitCS.setEndOffset(lexer.getStreamLength());
            this.myParser = new RunnableQVTParser(lexer);
            this.myParser.enableCSTTokens(Boolean.TRUE.equals(env.getValue(QVTParsingOptions.ENABLE_CSTMODEL_TOKENS)));
            lexer.lexToTokens((AbstractParser)this.myParser);
            result = (MappingModuleCS)this.myParser.runParser(100);
        }
        catch (ParserException ex) {
            env.reportError(ex.getLocalizedMessage(), 0, 0);
        }
        if (result == null && !env.hasErrors()) {
            env.reportError(NLS.bind((String)CompilerMessages.moduleTransformationExpected, (Object[])new Object[]{name}), 0, 0);
        }
        if (result != null) {
            unitCS.getTopLevelElements().add(result);
        }
        return unitCS;
    }

    public Module analyze(AbstractQVTParser parser, MappingModuleCS moduleCS, ExternalUnitElementsProvider importResolver, ResourceSet resSet, QvtOperationalFileEnv env, QvtCompilerOptions options) {
        Module module = null;
        env.setQvtCompilerOptions(options);
        try {
            QvtOperationalVisitorCS visitor = new QvtOperationalVisitorCS(parser, options);
            module = visitor.visitMappingModule(moduleCS, importResolver.getImporter(), env, importResolver, resSet);
        }
        catch (SemanticException e) {
            env.reportError(e.getLocalizedMessage(), 0, 0);
        }
        if (module != null && options.isReportErrors()) {
            env.setCheckForDuplicateErrors(true);
            QvtOperationalValidationVisitor validation = new QvtOperationalValidationVisitor(env);
            validation.visitModule(module);
            env.setCheckForDuplicateErrors(false);
        }
        return module;
    }

    public AbstractQVTParser getParser() {
        return this.myParser;
    }

    private static char[] correctLineBreaks(OCLInput input) throws ParserException {
        char[] contents = input.getContentAsString().toCharArray();
        int i = 0;
        while (i < contents.length) {
            int nextPos;
            char c = contents[i];
            if (c == '\r' && ((nextPos = i + 1) == contents.length || contents[nextPos] != '\n')) {
                contents[i] = 10;
            }
            ++i;
        }
        return contents;
    }

    private class RunnableQVTParser
    extends QvtOpLPGParser {
        public RunnableQVTParser(QvtOpLexer lexStream) {
            super(lexStream);
        }

        public EObject runParser(int max_error_count) throws ParserException {
            return this.parseTokensToCST(null, max_error_count);
        }

        protected void OnParseError(BadParseException e) {
            super.OnParseError(e);
        }

        public void reportError(int errorCode, String locationInfo, int leftToken, int rightToken, String tokenText) {
            if (tokenText.contains(this.getTokenKindName(4))) {
                return;
            }
            super.reportError(errorCode, locationInfo, leftToken, rightToken, tokenText);
        }

        public void reportError(int errorCode, String locationInfo, String tokenText) {
            super.reportError(errorCode, locationInfo, tokenText);
        }

        public void reportError(int i, int j) {
            super.reportError(i, j);
        }

        public void reportError(int i, String code) {
            super.reportError(i, code);
        }

        public String computeInputString(int left, int right) {
            char[] chars = this.getInputChars();
            if (right < left) {
                right = left;
            }
            if (right >= chars.length) {
                right = chars.length - 1;
            }
            StringBuffer result = new StringBuffer(right - left + 1);
            if (chars.length > 0) {
                int i = left;
                while (i <= right) {
                    if (chars[i] == '\t') {
                        result.append(' ');
                    } else if (chars[i] == '\n' || chars[i] == '\r' || chars[i] == '\f') {
                        if (i > 0 && !UCharacter.isWhitespace((int)chars[i - 1])) {
                            result.append(' ');
                        }
                    } else {
                        result.append(chars[i]);
                    }
                    ++i;
                }
            }
            return result.toString();
        }
    }
}

