/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolutionContextImpl
implements ResolutionContext {
    private URI fURI;

    public ResolutionContextImpl(URI contextURI) {
        if (contextURI == null) {
            throw new IllegalArgumentException();
        }
        this.fURI = contextURI;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return Eclipse.getAdapter(this.fURI, adapterType);
        }
        return null;
    }

    public String toString() {
        return "Resolution context (" + this.fURI.toString() + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Eclipse {
        private Eclipse() {
        }

        static <T> T getAdapter(URI contextURI, Class<T> adapterType) {
            if (adapterType == IProject.class) {
                if (contextURI.isPlatformResource()) {
                    String wsFullPath = contextURI.toPlatformString(true);
                    IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(wsFullPath);
                    if (resource != null) {
                        return adapterType.cast(resource.getProject());
                    }
                }
            } else if (adapterType == Bundle.class && contextURI.isPlatformPlugin() && contextURI.segmentCount() > 1) {
                String bundleID = contextURI.segment(1);
                Bundle bundle = Platform.getBundle((String)bundleID);
                return bundle != null ? (T)adapterType.cast(bundle) : null;
            }
            return null;
        }
    }
}

