/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant.CompositeTransformationContentPage;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant.CompositeTransformationModel;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant.TaskModel;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewCompositeTransformationWizard
extends Wizard
implements INewWizard {
    private WizardNewFileCreationPage myNewFilePage;
    private CompositeTransformationContentPage myContentsPage;
    private IStructuredSelection mySelection;
    private CompositeTransformationModel myModel = new CompositeTransformationModel();

    public NewCompositeTransformationWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mySelection = selection;
        this.setWindowTitle(Messages.TransformWizard_windowTitle);
    }

    public void addPages() {
        this.myNewFilePage = new WizardNewFileCreationPage("newTransformFilePage", this.mySelection);
        this.myNewFilePage.setTitle(Messages.TransformFilePage_title);
        String defaultFileName = "composite.xml";
        if (this.mySelection.getFirstElement() instanceof IFile) {
            IFile file = (IFile)this.mySelection.getFirstElement();
            defaultFileName = !"xml".equals(file.getFileExtension()) ? file.getProjectRelativePath().removeFileExtension().addFileExtension("xml").lastSegment() : file.getProjectRelativePath().lastSegment();
        }
        this.myNewFilePage.setFileName(defaultFileName);
        this.addPage((IWizardPage)this.myNewFilePage);
        this.myContentsPage = new CompositeTransformationContentPage(this.myModel);
        this.addPage((IWizardPage)this.myContentsPage);
    }

    public boolean performFinish() {
        final String containerName = this.myNewFilePage.getContainerFullPath().toPortableString();
        final String fileName = this.myNewFilePage.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewCompositeTransformationWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            NewCompositeTransformationWizard.throwCoreException("Container \"" + containerName + "\" does not exist.", null);
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException e) {
            NewCompositeTransformationWizard.throwCoreException("Error creating file [" + fileName + "]", e);
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() throws UnsupportedEncodingException, CoreException {
        String encoding = this.getCharset();
        String result = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n" + "<project name=\"" + this.myModel.getProjectName() + "\" " + "default=\"" + this.myModel.getTargetName() + "\" xmlns:qvto=\"http://www.eclipse.org/qvt/1.0.0/Operational\">\n";
        result = String.valueOf(result) + "    <target name=\"" + this.myModel.getTargetName() + "\">\n";
        List<TaskModel> value = this.myModel.getTaskModels();
        for (TaskModel model : value) {
            result = String.valueOf(result) + TaskModel.indentString(model.toString(), "        ", "\n") + "\n";
        }
        result = String.valueOf(result) + "    </target>\n";
        result = String.valueOf(result) + "</project>";
        return new ByteArrayInputStream(result.getBytes(encoding));
    }

    private String getCharset() throws CoreException {
        return "UTF-8";
    }

    private static void throwCoreException(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.eclipse.m2m.qvt.oml.internal.runtime.ui", 0, message, exception);
        throw new CoreException((IStatus)status);
    }
}

