/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtElement;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtModelException;

public abstract class QvtBaseElement
implements IQvtElement {
    private String fName;
    private IPath fPath;

    public QvtBaseElement(IPath path, String name) {
        if (name == null || path == null) {
            throw new IllegalArgumentException();
        }
        this.fName = name;
        this.fPath = path.append(name);
    }

    public QvtBaseElement(QvtBaseElement parent, String name) {
        this(parent.fPath, name);
    }

    public abstract IResource getUnderlyingResource() throws QvtModelException;

    public String getName() {
        return this.fName;
    }

    public IPath getFullPath() {
        return this.fPath;
    }

    protected void propagateAsQvtModelException(String message, CoreException coreException) throws QvtModelException {
        throw new QvtModelException(message, coreException);
    }

    protected void propagateAsQvtModelException(CoreException coreException) throws QvtModelException {
        throw new QvtModelException(coreException);
    }

    public String toString() {
        return this.getFullPath().toString();
    }
}

