/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.launch;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;

public class DeleteBuilderMarkersListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 8) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        final ArrayList projects = new ArrayList();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getResource() instanceof IWorkspaceRoot) {
                        return true;
                    }
                    if (delta.getResource() instanceof IProject) {
                        projects.add((IProject)delta.getResource());
                        return false;
                    }
                    return false;
                }
            });
        }
        catch (CoreException coreException) {
            Logger.getLogger().log(Logger.SEVERE, "Failed to traverse " + delta);
        }
        for (IProject project : projects) {
            if (!project.isOpen()) continue;
            this.deleteMarkers(project, "org.eclipse.m2m.qvt.oml.runtime.qvtBuilderMarker");
        }
    }

    private void deleteMarkers(IProject project, String type) {
        try {
            project.deleteMarkers(type, false, 1);
        }
        catch (CoreException e) {
            Logger.getLogger().log(Logger.SEVERE, "Failed to delete markers on " + project, e);
        }
    }
}

