/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.DOMHandler;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.resource.QvtCompilationErrorException;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.Messages;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalResourceImpl
extends XMIResourceImpl {
    public QvtOperationalResourceImpl(URI uri) {
        super(uri);
    }

    public void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded()) {
            Notification notification = null;
            this.isLoading = true;
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            try {
                try {
                    URI normalizedUri = this.getURIConverter().normalize(this.getURI());
                    QvtModule qvtModule = TransformationUtil.getQvtModule(normalizedUri);
                    QvtCompilerOptions qvtOptions = new QvtCompilerOptions();
                    qvtOptions.setModuleWithErrorAllowed(true);
                    qvtModule.setQvtCompilerOptions(qvtOptions);
                    CompiledUnit unit = qvtModule.getUnit();
                    this.fillCompilationDiagnostic(unit, normalizedUri);
                    if (unit.getModules().isEmpty()) {
                        throw new IOException(NLS.bind((String)Messages.QvtResource_moduleCompilationErrors, (Object)normalizedUri, (Object)unit.getProblems()));
                    }
                    notification = this.setLoaded(true);
                    this.getContents().addAll((Collection)unit.getModules());
                }
                catch (MdaException e) {
                    throw new Resource.IOWrappedException((Exception)((Object)e));
                }
            }
            catch (Throwable throwable) {
                this.isLoading = false;
                if (notification != null) {
                    this.eNotify(notification);
                }
                this.setModified(false);
                throw throwable;
            }
            this.isLoading = false;
            if (notification != null) {
                this.eNotify(notification);
            }
            this.setModified(false);
        }
    }

    private void fillCompilationDiagnostic(CompiledUnit unit, URI uri) {
        this.warnings = this.getWarnings();
        for (QvtMessage msg : unit.getWarnings()) {
            this.warnings.add((Object)new Diagnostic(msg.getMessage(), uri.toString(), msg.getLineNum()));
        }
        for (QvtMessage msg : unit.getErrors()) {
            this.warnings.add((Object)new QvtCompilationErrorException(msg, uri.toString(), msg.getLineNum()));
        }
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void doLoad(InputSource inputSource, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void doLoad(Node node, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Document save(Document doc, Map<?, ?> options, DOMHandler handler) {
        throw new UnsupportedOperationException();
    }

    public void save(Map<?, ?> options) throws IOException {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isTrackingModification() {
        return false;
    }

    private static class Diagnostic
    implements Resource.Diagnostic {
        private final String myMessage;
        private final String myLocation;
        private final int myLine;

        Diagnostic(String message, String location, int line) {
            this.myMessage = message;
            this.myLocation = location;
            this.myLine = line;
        }

        public String getMessage() {
            return this.myMessage;
        }

        public String getLocation() {
            return this.myLocation;
        }

        public int getColumn() {
            return 0;
        }

        public int getLine() {
            return this.myLine;
        }
    }
}

