/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.factory.primitive.ShortBags;
import org.eclipse.collections.api.factory.primitive.ShortLists;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.set.primitive.ShortSet;
import org.eclipse.collections.api.tuple.primitive.ShortShortPair;
import org.eclipse.collections.impl.factory.primitive.ShortSets;
import org.eclipse.collections.impl.iterator.SingletonShortIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;

final class ImmutableShortSingletonSet
implements ImmutableShortSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private final short element;

    ImmutableShortSingletonSet(short element) {
        this.element = element;
    }

    public ImmutableShortSet newWith(short element) {
        return ShortSets.immutable.with(new short[]{this.element, element});
    }

    public ImmutableShortSet newWithout(short element) {
        return this.element == element ? ShortSets.immutable.with() : this;
    }

    public ImmutableShortSet newWithAll(ShortIterable elements) {
        return ShortHashSet.newSet(elements).with(this.element).toImmutable();
    }

    public ImmutableShortSet newWithoutAll(ShortIterable elements) {
        return elements.contains(this.element) ? ShortSets.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean contains(short value) {
        return this.element == value;
    }

    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.element == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.element == value) continue;
            return false;
        }
        return true;
    }

    public void each(ShortProcedure procedure) {
        procedure.value(this.element);
    }

    public ImmutableShortSet select(ShortPredicate predicate) {
        return predicate.accept(this.element) ? ShortHashSet.newSetWith(this.element).toImmutable() : new ShortHashSet().toImmutable();
    }

    public ImmutableShortSet reject(ShortPredicate predicate) {
        return predicate.accept(this.element) ? new ShortHashSet().toImmutable() : ShortHashSet.newSetWith(this.element).toImmutable();
    }

    public <V> ImmutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
        return Sets.immutable.with(function.valueOf(this.element));
    }

    public MutableShortList toList() {
        return ShortLists.mutable.with(new short[]{this.element});
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(short item) {
        return this.element == item ? 1 : 0;
    }

    public void forEachWithOccurrences(ShortIntProcedure shortIntProcedure) {
        shortIntProcedure.value(this.element, 1);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return predicate.accept(this.element) ? this.element : ifNone;
    }

    public int count(ShortPredicate predicate) {
        return predicate.accept(this.element) ? 1 : 0;
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return predicate.accept(this.element);
    }

    public long sum() {
        return this.element;
    }

    public short min() {
        return this.element;
    }

    public short max() {
        return this.element;
    }

    public short maxIfEmpty(short defaultValue) {
        return this.element;
    }

    public short minIfEmpty(short defaultValue) {
        return this.element;
    }

    public double average() {
        return this.element;
    }

    public double median() {
        return this.element;
    }

    public LazyIterable<ShortShortPair> cartesianProduct(ShortSet set) {
        return ShortSets.cartesianProduct((ShortSet)this, set);
    }

    public short[] toSortedArray() {
        return new short[]{this.element};
    }

    public MutableShortList toSortedList() {
        return ShortLists.mutable.with(new short[]{this.element});
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return !predicate.accept(this.element);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return predicate.accept(this.element);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element);
    }

    public RichIterable<ShortIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with((Object)this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortSet)) {
            return false;
        }
        ShortSet set = (ShortSet)obj;
        if (set.size() != 1) {
            return false;
        }
        return set.contains(this.element);
    }

    public int hashCode() {
        return this.element;
    }

    public MutableShortSet toSet() {
        return ShortSets.mutable.with(new short[]{this.element});
    }

    public MutableShortBag toBag() {
        return ShortBags.mutable.with(new short[]{this.element});
    }

    public ShortSet freeze() {
        return this;
    }

    public ImmutableShortSet toImmutable() {
        return this;
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public short[] toArray() {
        return new short[]{this.element};
    }

    public short[] toArray(short[] target) {
        if (target.length < 1) {
            target = new short[]{this.element};
        } else {
            target[0] = this.element;
        }
        return target;
    }

    public String toString() {
        return "[" + this.makeString() + "]";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ShortIterator shortIterator() {
        return new SingletonShortIterator(this.element);
    }
}

