/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.maven;

import java.util.Comparator;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.oomph.maven.DOMElement;

public interface Coordinate
extends DOMElement {
    public static final String GROUP_ID = "groupId";
    public static final String ARTIFACT_ID = "artifactId";
    public static final String VERSION = "version";
    public static final Comparator<Coordinate> COMPARATOR = new Comparator<Coordinate>(){
        private final Comparator<String> stringComparator = CommonPlugin.INSTANCE.getComparator();

        @Override
        public int compare(Coordinate o1, Coordinate o2) {
            int result = this.stringComparator.compare(o1.getExpandedGroupId(), o2.getExpandedGroupId());
            if (result == 0 && (result = this.stringComparator.compare(o1.getArtifactId(), o2.getArtifactId())) == 0) {
                result = this.stringComparator.compare(o1.getExpandedVersion(), o2.getExpandedVersion());
            }
            return result;
        }
    };
    public static final Comparator<Coordinate> COMPARATOR_IGNORE_VERSION = new Comparator<Coordinate>(){
        private final Comparator<String> stringComparator = CommonPlugin.INSTANCE.getComparator();

        @Override
        public int compare(Coordinate o1, Coordinate o2) {
            int result = this.stringComparator.compare(o1.getExpandedGroupId(), o2.getExpandedGroupId());
            if (result == 0) {
                result = this.stringComparator.compare(o1.getArtifactId(), o2.getArtifactId());
            }
            return result;
        }
    };

    public String getGroupId();

    public String getArtifactId();

    public String getVersion();

    public String getExpandedGroupId();

    public String getExpandedVersion();
}

