/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.net.URL;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

final class DeferredImageDescriptor
extends ImageDescriptor
implements IAdaptable {
    private final Supplier<URL> supplier;
    private final boolean useMissingImage;
    private URL url;

    DeferredImageDescriptor(boolean useMissingImage, Supplier<URL> supplier) {
        super(false);
        this.supplier = Objects.requireNonNull(supplier);
        this.useMissingImage = useMissingImage;
    }

    @Override
    public ImageData getImageData(int zoom) {
        URL url = this.getURL();
        if (url == null) {
            return this.useMissingImage ? ImageDescriptor.getMissingImageDescriptor().getImageData(zoom) : null;
        }
        return ImageDescriptor.createFromURL(url).getImageData(zoom);
    }

    @Override
    public Image createImage(boolean returnMissingImageOnError, Device device) {
        URL url = this.getURL();
        if (url == null) {
            return returnMissingImageOnError ? ImageDescriptor.getMissingImageDescriptor().createImage() : null;
        }
        return ImageDescriptor.createFromURL(url).createImage(returnMissingImageOnError, device);
    }

    private final URL getURL() {
        if (this.url == null) {
            this.url = this.supplier.get();
        }
        return this.url;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == URL.class) {
            return adapter.cast(this.getURL());
        }
        return null;
    }
}

