/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;

public class Button
extends Control {
    long boxHandle;
    long labelHandle;
    long imageHandle;
    long arrowHandle;
    long groupHandle;
    boolean selected;
    boolean grayed;
    boolean toggleButtonTheming;
    Image image;
    String text;
    GdkRGBA background;
    Image defaultDisableImage;
    boolean enabled = true;
    static final int INNER_BORDER = 1;
    static final int DEFAULT_BORDER = 1;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    static int checkStyle(int style) {
        if (((style = Button.checkBits(style, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x30) != 0) {
            return Button.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Button.checkBits(style |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    GtkBorder getBorder(byte[] border, long handle, int defaultBorder) {
        GtkBorder gtkBorder = new GtkBorder();
        long[] borderPtr = new long[1];
        if (GTK.GTK4) {
            long context = GTK.gtk_widget_get_style_context(handle);
            int stateFlag = GTK.gtk_widget_get_state_flags(handle);
            this.gtk_style_context_get_border(context, stateFlag, gtkBorder);
            return gtkBorder;
        }
        GTK3.gtk_widget_style_get(handle, border, borderPtr, 0L);
        if (borderPtr[0] != 0L) {
            OS.memmove(gtkBorder, borderPtr[0], (long)GtkBorder.sizeof);
            GTK.gtk_border_free(borderPtr[0]);
            return gtkBorder;
        }
        gtkBorder.left = defaultBorder;
        gtkBorder.top = defaultBorder;
        gtkBorder.right = defaultBorder;
        gtkBorder.bottom = defaultBorder;
        return gtkBorder;
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        if (this.background != null && (this.state & 0x2000) != 0) {
            return this.background;
        }
        return this.defaultBackground();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener(listener, 13, 14);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        Point size;
        boolean wrap;
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        this.forceResize();
        int[] reqWidth = null;
        int[] reqHeight = null;
        if ((this.style & 0x30) != 0) {
            reqWidth = new int[1];
            reqHeight = new int[1];
            GTK.gtk_widget_get_size_request(this.boxHandle, reqWidth, reqHeight);
            GTK.gtk_widget_set_size_request(this.boxHandle, -1, -1);
        }
        boolean bl = wrap = this.labelHandle != 0L && (this.style & 0x40) != 0 && GTK.gtk_widget_get_visible(this.labelHandle);
        if (wrap) {
            int trimWidth;
            int borderWidth = this.gtk_container_get_border_width_or_margin(this.handle);
            if (!GTK.GTK4) {
                int[] focusWidth = new int[1];
                GTK3.gtk_widget_style_get(this.handle, OS.focus_line_width, focusWidth, 0L);
                int[] focusPadding = new int[1];
                GTK3.gtk_widget_style_get(this.handle, OS.focus_padding, focusPadding, 0L);
                trimWidth = 2 * (borderWidth + focusWidth[0] + focusPadding[0]);
            } else {
                trimWidth = 2 * borderWidth;
            }
            int trimHeight = trimWidth;
            int indicatorHeight = 0;
            if ((this.style & 0x30) != 0) {
                if (GTK.GTK4) {
                    long icon = GTK4.gtk_widget_get_first_child(this.handle);
                    GtkRequisition minimum = new GtkRequisition();
                    GTK.gtk_widget_get_preferred_size(icon, minimum, null);
                    long context = GTK.gtk_widget_get_style_context(icon);
                    GtkBorder margin = new GtkBorder();
                    GTK4.gtk_style_context_get_margin(context, margin);
                    trimWidth += minimum.width + margin.right;
                } else {
                    int[] indicatorSize = new int[1];
                    int[] indicatorSpacing = new int[1];
                    GTK3.gtk_widget_style_get(this.handle, OS.indicator_size, indicatorSize, 0L);
                    GTK3.gtk_widget_style_get(this.handle, OS.indicator_spacing, indicatorSpacing, 0L);
                    indicatorHeight = indicatorSize[0] + 2 * indicatorSpacing[0];
                    trimWidth += indicatorHeight + indicatorSpacing[0];
                }
            } else {
                boolean canDefault;
                Point thickness = this.getThickness(this.handle);
                trimWidth += thickness.x * 2;
                trimHeight += thickness.y * 2;
                GtkBorder innerBorder = this.getBorder(OS.inner_border, this.handle, 1);
                trimWidth += innerBorder.left + innerBorder.right;
                trimHeight += innerBorder.top + innerBorder.bottom;
                boolean bl2 = canDefault = GTK.GTK4 ? GTK4.gtk_widget_get_receives_default(this.handle) : GTK3.gtk_widget_get_can_default(this.handle);
                if (canDefault) {
                    GtkBorder defaultBorder = this.getBorder(OS.default_border, this.handle, 1);
                    trimWidth += defaultBorder.left + defaultBorder.right;
                    trimHeight += defaultBorder.top + defaultBorder.bottom;
                }
            }
            int imageWidth = 0;
            int imageHeight = 0;
            if (GTK.gtk_widget_get_visible(this.imageHandle)) {
                GtkRequisition requisition = new GtkRequisition();
                this.gtk_widget_get_preferred_size(this.imageHandle, requisition);
                imageWidth = requisition.width;
                imageHeight = requisition.height;
                int[] spacing = new int[1];
                OS.g_object_get(this.boxHandle, OS.spacing, spacing, 0L);
                imageWidth += spacing[0];
            }
            long labelLayout = GTK.gtk_label_get_layout(this.labelHandle);
            int pangoWidth = OS.pango_layout_get_width(labelLayout);
            if (wHint != -1) {
                OS.pango_layout_set_width(labelLayout, Math.max(1, wHint - imageWidth - trimWidth) * 1024);
            } else {
                OS.pango_layout_set_width(labelLayout, -1);
            }
            int[] w = new int[1];
            int[] h = new int[1];
            OS.pango_layout_get_pixel_size(labelLayout, w, h);
            OS.pango_layout_set_width(labelLayout, pangoWidth);
            size = new Point(0, 0);
            size.x = size.x + (wHint == -1 ? w[0] + imageWidth + trimWidth : wHint);
            size.y = size.y + (hHint == -1 ? Math.max(Math.max(imageHeight, indicatorHeight), h[0]) + trimHeight : hHint);
        } else {
            size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        }
        if ((this.style & 0x30) != 0) {
            GTK.gtk_widget_set_size_request(this.boxHandle, reqWidth[0], reqHeight[0]);
        }
        if (wHint != -1 || hHint != -1) {
            boolean canDefault;
            boolean bl3 = canDefault = GTK.GTK4 ? GTK4.gtk_widget_get_receives_default(this.handle) : GTK3.gtk_widget_get_can_default(this.handle);
            if (canDefault) {
                GtkBorder border = this.getBorder(OS.default_border, this.handle, 1);
                if (wHint != -1) {
                    size.x += border.left + border.right;
                }
                if (hHint != -1) {
                    size.y += border.top + border.bottom;
                }
            }
        }
        return size;
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        if ((this.style & 0xA) == 0) {
            this.state |= 0x10000;
        }
        int bits = 62;
        switch (this.style & bits) {
            case 4: {
                byte[] arrowType = GTK.GTK_NAMED_ICON_GO_UP;
                if ((this.style & 0x80) != 0) {
                    arrowType = GTK.GTK_NAMED_ICON_GO_UP;
                }
                if ((this.style & 0x400) != 0) {
                    arrowType = GTK.GTK_NAMED_ICON_GO_DOWN;
                }
                if ((this.style & 0x4000) != 0) {
                    arrowType = GTK.GTK_NAMED_ICON_GO_PREVIOUS;
                }
                if ((this.style & 0x20000) != 0) {
                    arrowType = GTK.GTK_NAMED_ICON_GO_NEXT;
                }
                if (GTK.GTK4) {
                    this.handle = GTK4.gtk_button_new_from_icon_name(arrowType);
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.arrowHandle = GTK4.gtk_widget_get_first_child(this.handle);
                    if (this.arrowHandle != 0L) break;
                    this.error(2);
                    break;
                }
                this.arrowHandle = GTK3.gtk_image_new_from_icon_name(arrowType, 1);
                if (this.arrowHandle == 0L) {
                    this.error(2);
                }
                this.handle = GTK.gtk_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                GTK3.gtk_button_set_image(this.handle, this.arrowHandle);
                break;
            }
            case 2: {
                this.handle = GTK.gtk_toggle_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                if (Display.themeName == null) break;
                this.toggleButtonTheming = GTK.GTK_VERSION >= OS.VERSION(3, 24, 11) && Display.themeName.contains("Adwaita") || Display.themeName.contains("Yaru");
                break;
            }
            case 32: {
                this.handle = GTK.gtk_check_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                if (Display.themeName == null) break;
                this.toggleButtonTheming = GTK.GTK_VERSION >= OS.VERSION(3, 24, 11) && Display.themeName.contains("Adwaita") || Display.themeName.contains("Yaru");
                break;
            }
            case 16: {
                if (GTK.GTK4) {
                    this.groupHandle = GTK.gtk_check_button_new();
                    if (this.groupHandle == 0L) {
                        this.error(2);
                    }
                    OS.g_object_ref_sink(this.groupHandle);
                    this.handle = GTK.gtk_check_button_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    GTK4.gtk_check_button_set_group(this.handle, this.groupHandle);
                } else {
                    this.groupHandle = GTK3.gtk_radio_button_new(0L);
                    if (this.groupHandle == 0L) {
                        this.error(2);
                    }
                    OS.g_object_ref_sink(this.groupHandle);
                    this.handle = GTK3.gtk_radio_button_new(GTK3.gtk_radio_button_get_group(this.groupHandle));
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                }
                if (Display.themeName == null) break;
                this.toggleButtonTheming = GTK.GTK_VERSION >= OS.VERSION(3, 24, 11) && Display.themeName.contains("Adwaita") || Display.themeName.contains("Yaru");
                break;
            }
            default: {
                this.handle = GTK.gtk_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                if (GTK.GTK4) break;
                GTK3.gtk_widget_set_can_default(this.handle, true);
            }
        }
        if ((this.style & 4) == 0) {
            this.boxHandle = this.gtk_box_new(0, false, 4);
            if (this.boxHandle == 0L) {
                this.error(2);
            }
            this.labelHandle = GTK.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0L) {
                this.error(2);
            }
            this.imageHandle = GTK.gtk_image_new();
            if (this.imageHandle == 0L) {
                this.error(2);
            }
            if (GTK.GTK4) {
                GTK.gtk_widget_set_parent(this.boxHandle, this.handle);
                GTK4.gtk_box_append(this.boxHandle, this.imageHandle);
                GTK4.gtk_box_append(this.boxHandle, this.labelHandle);
            } else {
                GTK3.gtk_container_add(this.handle, this.boxHandle);
                GTK3.gtk_container_add(this.boxHandle, this.imageHandle);
                GTK3.gtk_container_add(this.boxHandle, this.labelHandle);
            }
            if ((this.style & 0x40) != 0) {
                if (GTK.GTK4) {
                    GTK4.gtk_label_set_wrap(this.labelHandle, true);
                    GTK4.gtk_label_set_wrap_mode(this.labelHandle, 2);
                } else {
                    GTK3.gtk_label_set_line_wrap(this.labelHandle, true);
                    GTK3.gtk_label_set_line_wrap_mode(this.labelHandle, 2);
                }
            }
        }
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.setFontDescription(this.defaultFont().handle);
        this._setAlignment(this.style & 0x1024000);
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.text = "";
    }

    @Override
    void checkBackground() {
        if (this.toggleButtonTheming && (this.style & 0x30) != 0) {
            this.state &= 0xFFFF7FFF;
        } else {
            super.checkBackground();
        }
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.boxHandle != 0L) {
            this.display.removeWidget(this.boxHandle);
        }
        if (this.labelHandle != 0L) {
            this.display.removeWidget(this.labelHandle);
        }
        if (this.imageHandle != 0L) {
            this.display.removeWidget(this.imageHandle);
        }
        if (this.arrowHandle != 0L) {
            this.display.removeWidget(this.arrowHandle);
        }
    }

    @Override
    long fontHandle() {
        if (this.labelHandle != 0L) {
            return this.labelHandle;
        }
        return super.fontHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        if (GTK.GTK4 && (this.style & 0x30) != 0) {
            return GTK4.gtk_check_button_get_active(this.handle);
        }
        return GTK.gtk_toggle_button_get_active(this.handle);
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        long result = super.gtk_button_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return result;
    }

    @Override
    long gtk_clicked(long widget) {
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.selected);
            } else {
                this.selectRadio();
            }
        } else if ((this.style & 0x20) != 0) {
            if (GTK.GTK4) {
                boolean inconsistent = this.grayed && GTK4.gtk_check_button_get_active(this.handle);
                GTK4.gtk_check_button_set_inconsistent(this.handle, inconsistent);
            } else {
                boolean inconsistent = this.grayed && GTK.gtk_toggle_button_get_active(this.handle);
                GTK3.gtk_toggle_button_set_inconsistent(this.handle, inconsistent);
            }
        }
        this.sendSelectionEvent(13);
        return 0L;
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        if ((this.state & 0x200) != 0 && (this.state & 0x400) != 0) {
            if (GTK.gtk_widget_get_visible(widget)) {
                GTK.gtk_widget_set_visible(widget, false);
            }
            if (this.isDisposed() || this.display == null || this.display.isDisposed()) {
                this.error(45);
            }
        }
        return super.gtk_draw(widget, cairo);
    }

    @Override
    boolean mustBeVisibleOnInitBounds() {
        return true;
    }

    @Override
    long gtk_focus_in_event(long widget, long event) {
        long result = super.gtk_focus_in_event(widget, event);
        if (this.handle == 0L) {
            return 0L;
        }
        if ((this.style & 8) != 0 && GTK.gtk_widget_has_default(this.handle)) {
            Decorations menuShell = this.menuShell();
            menuShell.defaultButton = this;
        }
        return result;
    }

    @Override
    long gtk_focus_out_event(long widget, long event) {
        long result = super.gtk_focus_out_event(widget, event);
        if (this.handle == 0L) {
            return 0L;
        }
        if ((this.style & 8) != 0) {
            Decorations menuShell = this.menuShell();
            if (menuShell.defaultButton == this) {
                menuShell.defaultButton = null;
            }
        }
        return result;
    }

    @Override
    boolean gtk4_key_press_event(long controller, int keyval, int keycode, int state, long event) {
        boolean handled = super.gtk4_key_press_event(controller, keyval, keycode, state, event);
        if (!handled && (this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return handled;
    }

    @Override
    long gtk3_key_press_event(long widget, long event) {
        long result = super.gtk3_key_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return result;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (GTK.GTK4 && (this.style & 0x30) != 0) {
            OS.g_signal_connect_closure(this.handle, OS.toggled, this.display.getClosure(8), false);
        } else {
            OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
        }
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    @Override
    boolean isDescribedByLabel() {
        return false;
    }

    @Override
    boolean mnemonicHit(char key) {
        if (this.labelHandle == 0L) {
            return false;
        }
        boolean result = super.mnemonicHit(this.labelHandle, key);
        if (result) {
            this.setFocus();
        }
        return result;
    }

    @Override
    boolean mnemonicMatch(char key) {
        if (this.labelHandle == 0L) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, key);
    }

    @Override
    void register() {
        super.register();
        if (this.boxHandle != 0L) {
            this.display.addWidget(this.boxHandle, this);
        }
        if (this.labelHandle != 0L) {
            this.display.addWidget(this.labelHandle, this);
        }
        if (this.imageHandle != 0L) {
            this.display.addWidget(this.imageHandle, this);
        }
        if (this.arrowHandle != 0L) {
            this.display.addWidget(this.arrowHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.arrowHandle = 0L;
        this.labelHandle = 0L;
        this.imageHandle = 0L;
        this.boxHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (GTK.GTK4 && this.boxHandle != 0L) {
            GTK.gtk_widget_unparent(this.boxHandle);
        }
        if (this.groupHandle != 0L) {
            OS.g_object_unref(this.groupHandle);
        }
        this.groupHandle = 0L;
        this.image = null;
        this.text = null;
        this.disposeDefaultDisabledImage();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    @Override
    void resizeHandle(int width, int height) {
        if ((this.style & 0x30) != 0 && (this.style & 0x40) == 0) {
            OS.swt_fixed_resize(GTK.gtk_widget_get_parent(this.topHandle()), this.topHandle(), width, height);
        } else {
            super.resizeHandle(width, height);
        }
    }

    void selectRadio() {
        Control[] children = this.parent._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (this != child) {
                child.setRadioSelection(false);
            }
            ++i;
        }
        this.setSelection(true);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        this._setAlignment(alignment);
    }

    void _setAlignment(int alignment) {
        boolean bothVisible;
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= alignment & 0x24480;
            boolean isRTL = (this.style & 0x4000000) != 0;
            byte[] arrowType = GTK.GTK_NAMED_ICON_GO_UP;
            switch (alignment) {
                case 128: {
                    arrowType = GTK.GTK_NAMED_ICON_GO_UP;
                    break;
                }
                case 1024: {
                    arrowType = GTK.GTK_NAMED_ICON_GO_DOWN;
                    break;
                }
                case 16384: {
                    arrowType = isRTL ? GTK.GTK_NAMED_ICON_GO_NEXT : GTK.GTK_NAMED_ICON_GO_PREVIOUS;
                    break;
                }
                case 131072: {
                    byte[] byArray = arrowType = isRTL ? GTK.GTK_NAMED_ICON_GO_PREVIOUS : GTK.GTK_NAMED_ICON_GO_NEXT;
                }
            }
            if (GTK.GTK4) {
                GTK4.gtk_image_set_from_icon_name(this.arrowHandle, arrowType);
            } else {
                GTK3.gtk_image_set_from_icon_name(this.arrowHandle, arrowType, 1);
            }
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        boolean bl = bothVisible = GTK.gtk_widget_get_visible(this.labelHandle) && GTK.gtk_widget_get_visible(this.imageHandle);
        if (bothVisible) {
            if ((this.style & 0x30) != 0) {
                alignment = 16384;
            }
            if ((this.style & 0xA) != 0) {
                alignment = 0x1000000;
            }
        }
        if ((alignment & 0x4000) != 0) {
            if (bothVisible) {
                this.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 0, 0);
                this.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 0);
            } else {
                this.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                this.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
            }
            this.gtk_label_set_align(this.labelHandle, 0.0f, 0.5f);
            this.gtk_widget_set_align(this.imageHandle, 1, 3);
            GTK.gtk_label_set_justify(this.labelHandle, 0);
            return;
        }
        if ((alignment & 0x1000000) != 0) {
            if (bothVisible) {
                this.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                this.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
                this.gtk_label_set_align(this.labelHandle, 0.0f, 0.5f);
                this.gtk_widget_set_align(this.imageHandle, 2, 3);
            } else {
                this.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                this.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
                this.gtk_label_set_align(this.labelHandle, 0.5f, 0.5f);
                this.gtk_widget_set_align(this.imageHandle, 3, 3);
                GTK.gtk_label_set_justify(this.labelHandle, 2);
            }
            return;
        }
        if ((alignment & 0x20000) != 0) {
            if (bothVisible) {
                this.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 0, 1);
                this.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 1);
            } else {
                this.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                this.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
            }
            this.gtk_label_set_align(this.labelHandle, 1.0f, 0.5f);
            this.gtk_widget_set_align(this.imageHandle, 2, 3);
            GTK.gtk_label_set_justify(this.labelHandle, 1);
            return;
        }
    }

    @Override
    void setBackgroundGdkRGBA(long context, long handle, GdkRGBA rgba) {
        this.background = rgba;
        Object css = "* {background : ";
        String color = this.display.gtk_rgba_to_css_string(rgba);
        css = (String)css + color + ";}";
        if (rgba == null && this.toggleButtonTheming) {
            super.setBackgroundGdkRGBA(context, handle, rgba);
            return;
        }
        this.cssBackground = css;
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean wrap;
        boolean bl = wrap = this.labelHandle != 0L && (this.style & 0x40) != 0 && GTK.gtk_widget_get_visible(this.labelHandle);
        if (wrap) {
            GTK.gtk_widget_set_size_request(this.boxHandle, -1, -1);
        }
        int result = super.setBounds(x, y, width, height, move, resize);
        if (wrap) {
            GtkRequisition requisition;
            GtkAllocation allocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.boxHandle, allocation);
            int boxWidth = allocation.width;
            int boxHeight = allocation.height;
            long labelLayout = GTK.gtk_label_get_layout(this.labelHandle);
            int pangoWidth = OS.pango_layout_get_width(labelLayout);
            OS.pango_layout_set_width(labelLayout, -1);
            int[] w = new int[1];
            int[] h = new int[1];
            OS.pango_layout_get_pixel_size(labelLayout, w, h);
            OS.pango_layout_set_width(labelLayout, pangoWidth);
            int imageWidth = 0;
            if (GTK.gtk_widget_get_visible(this.imageHandle)) {
                requisition = new GtkRequisition();
                this.gtk_widget_get_preferred_size(this.imageHandle, requisition);
                imageWidth = requisition.width;
                int[] spacing = new int[1];
                OS.g_object_get(this.boxHandle, OS.spacing, spacing, 0L);
                imageWidth += spacing[0];
            }
            GTK.gtk_widget_set_size_request(this.labelHandle, Math.min(w[0], boxWidth - imageWidth), -1);
            requisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(this.boxHandle, requisition);
            allocation.width = boxWidth;
            allocation.height = boxHeight;
            Point sizes = this.resizeCalculationsGTK3(this.boxHandle, boxWidth, boxHeight);
            allocation.width = sizes.x;
            allocation.height = sizes.y;
            this.gtk_widget_size_allocate(this.boxHandle, allocation, -1);
        }
        return result;
    }

    @Override
    void setFontDescription(long fontDesc) {
        if (this.text != null && this.text.isEmpty() || this.text == null) {
            return;
        }
        super.setFontDescription(fontDesc);
        if (GTK.GTK4) {
            if (this.labelHandle != 0L) {
                this.setFontDescription(this.labelHandle, fontDesc);
            }
        } else {
            boolean selected = this.getSelection();
            if (selected) {
                this.setSelection(!selected);
            }
            if (this.labelHandle != 0L) {
                this.setFontDescription(this.labelHandle, fontDesc);
            }
            this.setSelection(selected);
        }
    }

    @Override
    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        super.setForegroundGdkRGBA(rgba);
        this.setForegroundGdkRGBA(this.fixedHandle, rgba);
        if (this.labelHandle != 0L) {
            this.setForegroundGdkRGBA(this.labelHandle, rgba);
        }
        if (this.imageHandle != 0L) {
            this.setForegroundGdkRGBA(this.imageHandle, rgba);
        }
    }

    @Override
    void setForegroundGdkRGBA(long handle, GdkRGBA rgba) {
        String css;
        long context = GTK.gtk_widget_get_style_context(handle);
        GdkRGBA toSet = rgba == null ? this.display.COLOR_WIDGET_FOREGROUND_RGBA : rgba;
        String color = this.display.gtk_rgba_to_css_string(toSet);
        int bits = 48;
        switch (this.style & bits) {
            case 32: {
                String checkColor;
                css = "checkbutton {color: " + color + ";}";
                if (this.toggleButtonTheming) {
                    GdkRGBA checkRGBA = rgba == null ? this.display.COLOR_TOGGLE_BUTTON_FOREGROUND_RGBA : rgba;
                    checkColor = this.display.gtk_rgba_to_css_string(checkRGBA);
                } else {
                    checkColor = this.display.gtk_rgba_to_css_string(toSet);
                }
                css = css + " check {color: " + checkColor + ";}";
                break;
            }
            case 16: {
                String radioColor;
                css = "radiobutton {color: " + color + ";}";
                if (this.toggleButtonTheming) {
                    GdkRGBA radioRGBA = rgba == null ? this.display.COLOR_TOGGLE_BUTTON_FOREGROUND_RGBA : rgba;
                    radioColor = this.display.gtk_rgba_to_css_string(radioRGBA);
                } else {
                    radioColor = this.display.gtk_rgba_to_css_string(toSet);
                }
                css = css + " radio {color: " + radioColor + ";}";
                break;
            }
            default: {
                css = "button {color: " + color + ";}";
            }
        }
        this.cssForeground = css;
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 16);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        this.grayed = grayed;
        if (GTK.GTK4) {
            boolean inconsistent = grayed && GTK4.gtk_check_button_get_active(this.handle);
            GTK4.gtk_check_button_set_inconsistent(this.handle, inconsistent);
        } else {
            boolean inconsistent = grayed && GTK.gtk_toggle_button_get_active(this.handle);
            GTK3.gtk_toggle_button_set_inconsistent(this.handle, inconsistent);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.disposeDefaultDisabledImage();
        if (!this.enabled && this.defaultDisableImage != image && this.defaultDisableImage != null) {
            return;
        }
        this.image = image;
        this._setImage(image);
    }

    private void _setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            if (GTK.GTK4) {
                long pixbuf = ImageList.createPixbuf(image);
                long texture = GDK.gdk_texture_new_for_pixbuf(pixbuf);
                OS.g_object_unref(pixbuf);
                GTK4.gtk_image_set_from_paintable(this.imageHandle, texture);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, image.surface);
            }
        } else if (GTK.GTK4) {
            GTK4.gtk_image_set_from_paintable(this.imageHandle, 0L);
        } else {
            GTK3.gtk_image_set_from_surface(this.imageHandle, 0L);
        }
        this.updateWidgetsVisibility();
        this._setAlignment(this.style);
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.boxHandle != 0L) {
                GTK.gtk_widget_set_direction(this.boxHandle, dir);
            }
            if (this.labelHandle != 0L) {
                GTK.gtk_widget_set_direction(this.labelHandle, dir);
            }
            if (this.imageHandle != 0L) {
                GTK.gtk_widget_set_direction(this.imageHandle, dir);
            }
            if (this.arrowHandle != 0L && (this.style & 0x24000) != 0) {
                byte[] arrowType;
                byte[] byArray = arrowType = (this.style & 0x4000000) != 0 ? GTK.GTK_NAMED_ICON_GO_NEXT : GTK.GTK_NAMED_ICON_GO_PREVIOUS;
                if (GTK.GTK4) {
                    GTK4.gtk_image_set_from_icon_name(this.arrowHandle, arrowType);
                } else {
                    GTK3.gtk_image_set_from_icon_name(this.arrowHandle, arrowType, 1);
                }
            }
        }
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
        if (GTK.GTK4 && (this.style & 0x30) != 0) {
            GTK4.gtk_check_button_set_active(this.handle, selected);
        } else {
            GTK.gtk_toggle_button_set_active(this.handle, selected);
        }
        if ((this.style & 0x20) != 0) {
            boolean inconsistent;
            boolean bl = inconsistent = selected && this.grayed;
            if (GTK.GTK4) {
                GTK4.gtk_check_button_set_inconsistent(this.handle, inconsistent);
            } else {
                GTK3.gtk_toggle_button_set_inconsistent(this.handle, inconsistent);
            }
        }
        if ((this.style & 0x10) != 0) {
            if (GTK.GTK4) {
                GTK4.gtk_check_button_set_active(this.groupHandle, !selected);
            } else {
                GTK.gtk_toggle_button_set_active(this.groupHandle, !selected);
            }
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(chars, true);
        GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        this.updateWidgetsVisibility();
        this._setAlignment(this.style);
        this.setFontDescription(this.font == null ? this.defaultFont().handle : this.font.handle);
    }

    private void updateWidgetsVisibility() {
        if (this.text.length() == 0 && this.image == null) {
            this.gtk_widget_hide(this.boxHandle);
            this.gtk_widget_hide(this.labelHandle);
            this.gtk_widget_hide(this.imageHandle);
        } else {
            this.gtk_widget_show(this.boxHandle);
            if (this.text.length() == 0) {
                this.gtk_widget_hide(this.labelHandle);
            } else {
                this.gtk_widget_show(this.labelHandle);
            }
            if (this.image == null) {
                this.gtk_widget_hide(this.imageHandle);
            } else {
                this.gtk_widget_show(this.imageHandle);
            }
        }
    }

    @Override
    void showWidget() {
        super.showWidget();
        if (this.boxHandle != 0L && (this.text != null && this.text.length() != 0 || this.image != null)) {
            this.gtk_widget_show(this.boxHandle);
        }
        if (this.labelHandle != 0L && this.text != null && this.text.length() != 0) {
            this.gtk_widget_show(this.labelHandle);
        }
        if (this.arrowHandle != 0L) {
            this.gtk_widget_show(this.arrowHandle);
        }
    }

    @Override
    int traversalCode(int key, long event) {
        int code = super.traversalCode(key, event);
        if ((this.style & 4) != 0) {
            code &= 0xFFFFFFE7;
        }
        if ((this.style & 0x10) != 0) {
            code |= 0x60;
        }
        return code;
    }

    @Override
    long windowProc(long handle, long arg0, long user_data) {
        switch ((int)user_data) {
            case 18: {
                if (this.paintHandle() != handle) break;
                return this.gtk_draw(handle, arg0);
            }
        }
        return super.windowProc(handle, arg0, user_data);
    }

    @Override
    long dpiChanged(long object, long arg0) {
        super.dpiChanged(object, arg0);
        if (this.image != null) {
            this.image.internal_gtk_refreshImageForZoom();
            this.setImage(this.image);
        }
        return 0L;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        super.setEnabled(enabled);
        if (!enabled) {
            if (this.defaultDisableImage == null && this.image != null) {
                this.defaultDisableImage = new Image((Device)this.getDisplay(), this.image, 1);
            }
            this._setImage(this.defaultDisableImage);
        }
        if (enabled && this.image != null) {
            this._setImage(this.image);
        }
    }

    private void disposeDefaultDisabledImage() {
        if (this.defaultDisableImage != null) {
            this.defaultDisableImage.dispose();
            this.defaultDisableImage = null;
        }
    }
}

