/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.eclipse.ecf.core.util.ProxyAddress;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2481483596779542834L;
    ProxyAddress address;
    Type type;
    String username;
    String password;
    public static final Proxy NO_PROXY = new Proxy();

    private Proxy() {
        this.type = Type.DIRECT;
        this.address = null;
    }

    public Proxy(Type type, ProxyAddress address, String username, String password) {
        this.type = type;
        this.address = address;
        this.username = username;
        this.password = password;
    }

    public Proxy(Type type, ProxyAddress address) {
        this(type, address, null, null);
    }

    public Type getType() {
        return this.type;
    }

    public ProxyAddress getAddress() {
        return this.address;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean hasCredentials() {
        return this.username != null && !this.username.equals("");
    }

    public String toString() {
        if (this.getType() == Type.DIRECT) {
            return "DIRECT";
        }
        return String.valueOf(this.getType()) + " @ " + String.valueOf(this.getAddress());
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Proxy)) {
            return false;
        }
        Proxy p = (Proxy)obj;
        if (p.getType() == this.getType()) {
            if (this.getAddress() == null) {
                return p.getAddress() == null;
            }
            return this.getAddress().equals(p.getAddress());
        }
        return false;
    }

    public final int hashCode() {
        if (this.getAddress() == null) {
            return this.getType().hashCode();
        }
        return this.getType().hashCode() + this.getAddress().hashCode();
    }

    public static class Type
    implements Serializable {
        private static final long serialVersionUID = 361071073081975271L;
        private static final String DIRECT_NAME = "direct";
        private static final String HTTP_NAME = "http";
        private static final String SOCKS_NAME = "socks";
        private final transient String name;
        public static final Type DIRECT = new Type("direct");
        public static final Type HTTP = new Type("http");
        public static final Type SOCKS = new Type("socks");
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;
        private static final Type[] VALUES = new Type[]{DIRECT, HTTP, SOCKS};

        protected Type(String name) {
            this.name = name;
        }

        public static Type fromString(String type) {
            if (type == null) {
                return null;
            }
            if (type.equals(DIRECT_NAME)) {
                return DIRECT;
            }
            if (type.equals(HTTP_NAME)) {
                return HTTP;
            }
            if (type.equals(SOCKS_NAME)) {
                return SOCKS;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        Object readResolve() throws ObjectStreamException {
            return VALUES[this.ordinal];
        }
    }
}

