/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.generatedfile;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;

public class CompilationUnitHelper {
    public void commitNewContents(ICompilationUnit wc, String contents, IProgressMonitor monitor) throws JavaModelException {
        IBuffer b = wc.getBuffer();
        b.setContents(contents);
        wc.commitWorkingCopy(true, monitor);
    }

    public ICompilationUnit getWorkingCopy(String typeName, IPackageFragmentRoot root) {
        IPackageFragment pkgFragment;
        String[] names = this.parseTypeName(typeName);
        String pkgName = names[0];
        String fname = names[1];
        ICompilationUnit workingCopy = null;
        try {
            pkgFragment = root.getPackageFragment(pkgName);
            workingCopy = pkgFragment.getCompilationUnit(fname);
            workingCopy.becomeWorkingCopy(null);
        }
        catch (JavaModelException e) {
            AptPlugin.log(e, "Unable to become working copy: " + typeName);
            return null;
        }
        if (AptPlugin.DEBUG_GFM) {
            AptPlugin.trace("Created working copy: root = " + String.valueOf(root) + ",\n\tfragment = " + String.valueOf(pkgFragment) + ",\n\twc = " + String.valueOf(workingCopy));
        }
        return workingCopy;
    }

    public void discardWorkingCopy(ICompilationUnit wc) {
        if (wc == null) {
            return;
        }
        if (AptPlugin.DEBUG_GFM) {
            AptPlugin.trace("discarding working copy: " + wc.getElementName());
        }
        try {
            wc.discardWorkingCopy();
        }
        catch (JavaModelException e) {
            AptPlugin.log(e, "Unable to discard working copy: " + wc.getElementName());
        }
    }

    public boolean updateWorkingCopyContents(String contents, ICompilationUnit wc, WorkingCopyOwner wcOwner, boolean reconcile) {
        boolean modified = true;
        IBuffer b = null;
        try {
            b = wc.getBuffer();
        }
        catch (JavaModelException e) {
            AptPlugin.log(e, "Unable to get buffer for working copy: " + wc.getElementName());
            return false;
        }
        modified = !contents.equals(b.getContents());
        b.setContents(contents);
        if (AptPlugin.DEBUG_GFM_MAPS) {
            AptPlugin.trace("updated contents of working copy: " + wc.getElementName() + " modified = " + modified);
        }
        if (reconcile && modified) {
            try {
                wc.reconcile(0, true, wcOwner, null);
            }
            catch (JavaModelException e) {
                AptPlugin.log(e, "Unable to reconcile generated type: " + wc.getElementName());
            }
        }
        return modified;
    }

    public IPackageFragment createPackageFragment(String pkgName, IPackageFragmentRoot root, IProgressMonitor progressMonitor) {
        IPackageFragment pkgFrag = null;
        try {
            pkgFrag = root.createPackageFragment(pkgName, true, progressMonitor);
        }
        catch (JavaModelException e) {
            AptPlugin.log(e, "Unable to create package fragment for package " + pkgName);
        }
        return pkgFrag;
    }

    private String[] parseTypeName(String qualifiedName) {
        String fname;
        String pkgName;
        String[] names = new String[2];
        int idx = qualifiedName.lastIndexOf(46);
        if (idx > 0) {
            pkgName = qualifiedName.substring(0, idx);
            fname = qualifiedName.substring(idx + 1, qualifiedName.length()) + ".java";
        } else {
            pkgName = "";
            fname = qualifiedName + ".java";
        }
        names[0] = pkgName;
        names[1] = fname;
        return names;
    }
}

