/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceLoader;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.ValueExpr;

public class Var
extends AbstractQueryModelNode
implements ValueExpr {
    public static final String PROVIDER_PROPERTY = "org.eclipse.rdf4j.query.algebra.Var.provider";
    private final String name;
    private final Value value;
    private final boolean anonymous;
    private boolean constant = false;
    private int cachedHashCode = 0;

    public static Var of(String name) {
        return Holder.PROVIDER.newVar(name, null, false, false);
    }

    public static Var of(String name, boolean anonymous) {
        return Holder.PROVIDER.newVar(name, null, anonymous, false);
    }

    public static Var of(String name, Value value) {
        return Holder.PROVIDER.newVar(name, value, false, false);
    }

    public static Var of(String name, Value value, boolean anonymous) {
        return Holder.PROVIDER.newVar(name, value, anonymous, false);
    }

    public static Var of(String name, Value value, boolean anonymous, boolean constant) {
        return Holder.PROVIDER.newVar(name, value, anonymous, constant);
    }

    @Deprecated(since="5.1.5", forRemoval=true)
    public Var(String name, Value value, boolean anonymous, boolean constant) {
        this.name = name;
        this.value = value;
        this.anonymous = anonymous;
        this.constant = constant;
    }

    @Deprecated(since="5.1.5", forRemoval=true)
    public Var(String name) {
        this(name, null, false, false);
    }

    @Deprecated(since="5.1.5", forRemoval=true)
    public Var(String name, boolean anonymous) {
        this(name, null, anonymous, false);
    }

    @Deprecated(since="5.1.5", forRemoval=true)
    public Var(String name, Value value) {
        this(name, value, false, false);
    }

    @Deprecated(since="5.1.5", forRemoval=true)
    public Var(String name, Value value, boolean anonymous) {
        this(name, value, anonymous, false);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public Value getValue() {
        return this.value;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
    }

    @Override
    public void setParentNode(QueryModelNode parent) {
        assert (this.getParentNode() == null);
        super.setParentNode(parent);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName());
        sb.append(" (name=").append(this.name);
        if (this.value != null) {
            sb.append(", value=").append(this.value);
        }
        if (this.anonymous) {
            sb.append(", anonymous");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Var)) {
            return false;
        }
        Var var = (Var)o;
        if (this.cachedHashCode != 0 && var.cachedHashCode != 0 && this.cachedHashCode != var.cachedHashCode) {
            return false;
        }
        return this.spiEquals(var) && var.spiEquals(this);
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.spiHashCode();
        }
        return this.cachedHashCode;
    }

    @Override
    public Var clone() {
        Var var = Holder.PROVIDER.cloneVar(this);
        var.setVariableScopeChange(this.isVariableScopeChange());
        return var;
    }

    protected boolean spiEquals(Var other) {
        return !(this.anonymous != other.anonymous || this.name == null && other.name != null || this.value == null && other.value != null || !Objects.equals(this.name, other.name) || !Objects.equals(this.value, other.value));
    }

    protected int spiHashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + Boolean.hashCode(this.anonymous);
        return result;
    }

    public boolean isConstant() {
        return this.constant;
    }

    private static final class Holder {
        private static final Provider DEFAULT = Var::new;
        static final Provider PROVIDER = Holder.initProvider();

        private Holder() {
        }

        private static Provider initProvider() {
            String fqcn = null;
            try {
                fqcn = System.getProperty(Var.PROVIDER_PROPERTY);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (fqcn != null && !fqcn.isEmpty()) {
                try {
                    Class<?> cls = Class.forName(fqcn, true, Var.class.getClassLoader());
                    if (Provider.class.isAssignableFrom(cls)) {
                        Class<?> pcls = cls;
                        return (Provider)pcls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                catch (Throwable cls) {
                    // empty catch block
                }
            }
            try {
                ServiceLoader<Provider> loader = ServiceLoader.load(Provider.class);
                Iterator<Provider> iterator = loader.iterator();
                if (iterator.hasNext()) {
                    Provider p = iterator.next();
                    return p;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return DEFAULT;
        }
    }

    @FunctionalInterface
    public static interface Provider {
        public Var newVar(String var1, Value var2, boolean var3, boolean var4);

        default public Var cloneVar(Var original) {
            return this.newVar(original.getName(), original.getValue(), original.isAnonymous(), original.isConstant());
        }
    }
}

