/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir;

import java.util.Collections;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSelect;

public class IrSubSelect
extends IrNode {
    private final IrSelect select;

    public IrSubSelect(IrSelect select, boolean newScope) {
        super(newScope);
        this.select = select;
    }

    public IrSelect getSelect() {
        return this.select;
    }

    @Override
    public void print(IrPrinter p) {
        boolean wrap;
        boolean hasTrailing = this.select != null && (!this.select.getGroupBy().isEmpty() || !this.select.getHaving().isEmpty() || !this.select.getOrderBy().isEmpty() || this.select.getLimit() >= 0L || this.select.getOffset() >= 0L);
        boolean bl = wrap = this.isNewScope() || hasTrailing;
        if (wrap) {
            p.openBlock();
            if (this.select != null) {
                this.select.print(p);
            }
            p.closeBlock();
        } else if (this.select != null) {
            this.select.print(p);
        }
    }

    @Override
    public IrNode transformChildren(UnaryOperator<IrNode> op) {
        IrSelect newSelect = this.select;
        if (newSelect != null) {
            IrNode t = (IrNode)op.apply(newSelect);
            if ((t = t.transformChildren(op)) instanceof IrSelect) {
                newSelect = (IrSelect)t;
            }
        }
        return new IrSubSelect(newSelect, this.isNewScope());
    }

    @Override
    public Set<Var> getVars() {
        if (this.select != null && this.select.getWhere() != null) {
            return this.select.getWhere().getVars();
        }
        return Collections.emptySet();
    }
}

