/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOAllRevisionsProvider;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.CommitInfoTable;
import org.eclipse.emf.cdo.server.internal.db.DBStoreAccessor;
import org.eclipse.emf.cdo.server.internal.db.DBStoreTables;
import org.eclipse.emf.cdo.server.internal.db.DurableLockingManager;
import org.eclipse.emf.cdo.server.internal.db.LongIDHandler;
import org.eclipse.emf.cdo.server.internal.db.MetaDataManager;
import org.eclipse.emf.cdo.server.internal.db.UUIDHandler;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.MappingNames;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.UnitMappingTable;
import org.eclipse.emf.cdo.server.internal.db.messages.Messages;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.LongIDStoreAccessor;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessorPool;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.internal.db.ddl.DBField;
import org.eclipse.net4j.internal.db.ddl.DBTable;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Entity;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.monitor.ProgressDistributor;

public class DBStore
extends Store
implements IDBStore,
CDOAllRevisionsProvider,
InternalRepository.PostActivateable {
    public static final String TYPE = "db";
    public static final int SCHEMA_VERSION = 4;
    private static final String ENTITY_NAME_PROPERTIES = "properties";
    private static final int FIRST_START = -1;
    private static final String PROP_SCHEMA_VERSION = "org.eclipse.emf.cdo.server.db.schemaVersion";
    private static final String PROP_REPOSITORY_CREATED = "org.eclipse.emf.cdo.server.db.repositoryCreated";
    private static final String PROP_REPOSITORY_STOPPED = "org.eclipse.emf.cdo.server.db.repositoryStopped";
    private static final String PROP_NEXT_LOCAL_CDOID = "org.eclipse.emf.cdo.server.db.nextLocalCDOID";
    private static final String PROP_LAST_CDOID = "org.eclipse.emf.cdo.server.db.lastCDOID";
    private static final String PROP_LAST_BRANCHID = "org.eclipse.emf.cdo.server.db.lastBranchID";
    private static final String PROP_LAST_LOCAL_BRANCHID = "org.eclipse.emf.cdo.server.db.lastLocalBranchID";
    private static final String PROP_LAST_COMMITTIME = "org.eclipse.emf.cdo.server.db.lastCommitTime";
    private static final String PROP_LAST_NONLOCAL_COMMITTIME = "org.eclipse.emf.cdo.server.db.lastNonLocalCommitTime";
    private static final String PROP_GRACEFULLY_SHUT_DOWN = "org.eclipse.emf.cdo.server.db.gracefullyShutDown";
    private static final int DEFAULT_CONNECTION_RETRY_COUNT = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.server.db.DEFAULT_CONNECTION_RETRY_COUNT", 0);
    private static final int DEFAULT_CONNECTION_RETRY_SECONDS = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.server.db.DEFAULT_CONNECTION_RETRY_SECONDS", 30);
    private static final boolean DEFAULT_PREPEND_SCHEMA_NAME = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.server.db.DEFAULT_PREPEND_SCHEMA_NAME");
    private static final boolean DEFAULT_CREATE_SCHEMA_IF_NEEDED = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.server.db.DEFAULT_CREATE_SCHEMA_IF_NEEDED");
    private static final boolean SHOW_SCHEMA_CREATION_EXCEPTION = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.server.db.SHOW_SCHEMA_CREATION_EXCEPTION");
    private static final boolean DISABLE_LOG_OTHER_SCHEMA_INFO = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.server.db.DISABLE_LOG_OTHER_SCHEMA_INFO");
    private long creationTime;
    private boolean firstTime;
    private Map<String, String> properties;
    private int idColumnLength = -1;
    private int jdbcFetchSize = 100000;
    private IIDHandler idHandler;
    private IMetaDataManager metaDataManager = this.createMetaDataManager();
    private DurableLockingManager durableLockingManager = this.createDurableLockingManager();
    private DBStoreTables tables;
    private CommitInfoTable commitInfoTable;
    private UnitMappingTable unitMappingTable;
    private IMappingStrategy mappingStrategy;
    private IDBDatabase database;
    private IDBAdapter dbAdapter;
    private IDBConnectionProvider dbConnectionProvider;
    @ReflectUtil.ExcludeFromDump
    private transient ProgressDistributor accessorWriteDistributor = this.createProgressDistributor();
    @ReflectUtil.ExcludeFromDump
    private transient StoreAccessorPool readerPool = this.createReaderPool();
    @ReflectUtil.ExcludeFromDump
    private transient StoreAccessorPool writerPool = this.createWriterPool();
    @ReflectUtil.ExcludeFromDump
    private transient Timer connectionKeepAliveTimer;
    private static final int FIRST_VERSION_WITH_NULLABLE_CHECKS = 4;
    private final SchemaMigrator NO_MIGRATION_NEEDED = null;
    private final SchemaMigrator NON_AUDIT_MIGRATION = new SchemaMigrator(this){

        @Override
        public void migrateSchema(Connection connection) throws Exception {
            InternalRepository repository = this.getRepository();
            if (!repository.isSupportingAudits()) {
                this.visitAllTables(connection, new IDBStore.TableVisitor(){

                    @Override
                    public void visitTable(Connection connection, String name) throws SQLException {
                        Statement statement = null;
                        try {
                            statement = connection.createStatement();
                            String from = " FROM " + name + " WHERE " + DBUtil.quoted((String)MappingNames.ATTRIBUTES_VERSION) + "<" + 1;
                            statement.executeUpdate("DELETE FROM " + DBUtil.quoted((String)MappingNames.CDO_OBJECTS) + " WHERE " + DBUtil.quoted((String)MappingNames.ATTRIBUTES_ID) + " IN (SELECT " + DBUtil.quoted((String)MappingNames.ATTRIBUTES_ID) + from + ")");
                            statement.executeUpdate("DELETE" + from);
                        }
                        finally {
                            DBUtil.close((Statement)statement);
                        }
                    }
                });
            }
        }
    };
    private final SchemaMigrator LOB_SIZE_MIGRATION = new SchemaMigrator(this){

        @Override
        public void migrateSchema(Connection connection) throws Exception {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                IDBSchema schema = null;
                String schemaName = this.getSchemaName(connection);
                if (schemaName != null) {
                    schema = DBUtil.createSchema((String)schemaName, (boolean)dbAdapter.isCaseSensitive(), (boolean)this.isPrependSchemaName());
                }
                DBTable table = new DBTable(schema, DBStoreTables.LobsTable.tableName());
                DBField field = new DBField((IDBTable)table, DBStoreTables.LobsTable.sizeName(), DBType.INTEGER, 0, 0, false, 0);
                String sql = dbAdapter.sqlRenameField((IDBField)field, DBUtil.quoted((String)"size"));
                statement.execute(sql);
            }
            finally {
                DBUtil.close((Statement)statement);
            }
        }
    };
    private final SchemaMigrator NULLABLE_COLUMNS_MIGRATION = null;
    private final SchemaMigrator[] SCHEMA_MIGRATORS = new SchemaMigrator[]{this.NO_MIGRATION_NEEDED, this.NON_AUDIT_MIGRATION, this.LOB_SIZE_MIGRATION, this.NULLABLE_COLUMNS_MIGRATION};

    public DBStore() {
        super(TYPE, null, DBStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.REVISION, IStore.ChangeFormat.DELTA}), DBStore.set((Object[])new IStore.RevisionTemporality[]{IStore.RevisionTemporality.AUDITING, IStore.RevisionTemporality.NONE}), DBStore.set((Object[])new IStore.RevisionParallelism[]{IStore.RevisionParallelism.NONE, IStore.RevisionParallelism.BRANCHING}));
        if (this.SCHEMA_MIGRATORS.length != 4) {
            throw new Error("There must be exactly 4 schema migrators provided");
        }
    }

    @Override
    public IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public void setMappingStrategy(IMappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
        mappingStrategy.setStore(this);
    }

    @Override
    public IDBAdapter getDBAdapter() {
        return this.dbAdapter;
    }

    public void setDBAdapter(IDBAdapter dbAdapter) {
        this.dbAdapter = dbAdapter;
    }

    public void setProperties(Map<String, String> properties) {
        this.checkInactive();
        this.properties = properties;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    private int getProperty(String key, int defaultValue) {
        String value;
        if (this.properties != null && (value = this.properties.get(key)) != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    protected void computeEntityNames(Consumer<String> consumer) {
        super.computeEntityNames(consumer);
        consumer.accept(ENTITY_NAME_PROPERTIES);
    }

    protected Entity computeEntity(String name) {
        if (ENTITY_NAME_PROPERTIES.equals(name)) {
            Map<String, String> properties = this.getProperties();
            return this.entityBuilder().name(ENTITY_NAME_PROPERTIES).properties(properties).build();
        }
        return super.computeEntity(name);
    }

    @Override
    public int getJDBCFetchSize() {
        return this.jdbcFetchSize;
    }

    @Override
    public int getIDColumnLength() {
        return this.idColumnLength;
    }

    @Override
    public IIDHandler getIDHandler() {
        return this.idHandler;
    }

    @Override
    public IDBDatabase getDatabase() {
        return this.database;
    }

    public Connection getConnection() {
        Connection connection = this.dbConnectionProvider.getConnection();
        if (connection == null) {
            throw new DBException("No connection from connection provider: " + this.dbConnectionProvider);
        }
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex, "SET AUTO COMMIT = false");
        }
        return connection;
    }

    public Connection getConnectionOrRetry() {
        RuntimeException exception = null;
        int attempts = 1 + this.getProperty("connectionRetryCount", DEFAULT_CONNECTION_RETRY_COUNT);
        int seconds = this.getProperty("connectionRetrySeconds", DEFAULT_CONNECTION_RETRY_SECONDS);
        if (seconds < 1) {
            attempts = 1;
        }
        int i = 0;
        while (i < attempts) {
            block7: {
                if (i != 0) {
                    OM.LOG.info("Database connection could not be established. Next attempt is scheduled in " + seconds + " seconds...");
                    ConcurrencyUtil.sleep((long)(1000L * (long)seconds));
                }
                try {
                    Connection connection = this.getConnection();
                    if (connection != null) {
                        return connection;
                    }
                }
                catch (RuntimeException ex) {
                    if (exception != null) break block7;
                    exception = ex;
                }
            }
            ++i;
        }
        String message = "Database connection could not be established after " + attempts + " attempts";
        if (exception != null) {
            throw new DBException(message, (Throwable)exception);
        }
        throw new DBException(message);
    }

    public void setDBConnectionProvider(IDBConnectionProvider dbConnectionProvider) {
        this.dbConnectionProvider = dbConnectionProvider;
    }

    @Override
    public IMetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public DurableLockingManager getDurableLockingManager() {
        return this.durableLockingManager;
    }

    public CommitInfoTable getCommitInfoTable() {
        return this.commitInfoTable;
    }

    public UnitMappingTable getUnitMappingTable() {
        return this.unitMappingTable;
    }

    public Timer getConnectionKeepAliveTimer() {
        return this.connectionKeepAliveTimer;
    }

    public Set<IStore.ChangeFormat> getSupportedChangeFormats() {
        if (this.mappingStrategy.hasDeltaSupport()) {
            return DBStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.DELTA});
        }
        return DBStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.REVISION});
    }

    public ProgressDistributor getAccessorWriteDistributor() {
        return this.accessorWriteDistributor;
    }

    @Override
    public IDBSchema getDBSchema() {
        return this.database.getSchema();
    }

    public DBStoreTables tables() {
        return this.tables;
    }

    @Override
    public void visitAllTables(Connection connection, IDBStore.TableVisitor visitor) {
        IDBSchema schema = this.getDBSchema();
        String schemaName = schema.getName();
        boolean qualifiedTableNames = schema.isQualifiedTableNames();
        boolean caseSensitive = this.dbAdapter.isCaseSensitive();
        for (String name : DBUtil.getAllTableNames((Connection)connection, (String)schemaName, (boolean)caseSensitive)) {
            name = DBUtil.quoted((String)name);
            if (schemaName != null && qualifiedTableNames) {
                name = String.valueOf(DBUtil.quoted((String)schemaName)) + '.' + name;
            }
            try {
                visitor.visitTable(connection, name);
                connection.commit();
            }
            catch (SQLException ex) {
                try {
                    connection.rollback();
                }
                catch (SQLException ex1) {
                    throw new DBException((Throwable)ex1);
                }
                if (this.dbAdapter.isColumnNotFoundException(ex)) continue;
                throw new DBException((Throwable)ex);
            }
        }
    }

    public Map<String, String> getPersistentProperties(Set<String> names) {
        return this.tables.properties().getPersistentProperties(names);
    }

    public void setPersistentProperties(Map<String, String> properties) {
        this.tables.properties().setPersistentProperties(properties);
    }

    public void putPersistentProperty(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        this.setPersistentProperties(map);
    }

    public void removePersistentProperties(Set<String> names) {
        this.tables.properties().removePersistentProperties(names);
    }

    @Override
    public DBStoreAccessor getReader(ISession session) {
        return (DBStoreAccessor)super.getReader(session);
    }

    @Override
    public DBStoreAccessor getWriter(ITransaction transaction) {
        return (DBStoreAccessor)super.getWriter(transaction);
    }

    protected StoreAccessorPool getReaderPool(ISession session, boolean forReleasing) {
        return this.readerPool;
    }

    protected StoreAccessorPool getWriterPool(IView view, boolean forReleasing) {
        return this.writerPool;
    }

    protected DBStoreAccessor createReader(ISession session) throws DBException {
        return new DBStoreAccessor(this, session);
    }

    protected DBStoreAccessor createWriter(ITransaction transaction) throws DBException {
        return new DBStoreAccessor(this, transaction);
    }

    public Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        final HashMap<CDOBranch, List<CDORevision>> result = new HashMap<CDOBranch, List<CDORevision>>();
        InternalSession session = null;
        if (!StoreThreadLocal.hasSession()) {
            session = this.getRepository().getSessionManager().openSession(null);
            StoreThreadLocal.setSession((InternalSession)session);
        }
        try {
            StoreThreadLocal.getAccessor().handleRevisions(null, null, 0L, true, (CDORevisionHandler)new CDORevisionHandler.Filtered.Undetached(new CDORevisionHandler(){

                public boolean handleRevision(CDORevision revision) {
                    CDOBranch branch = revision.getBranch();
                    ArrayList<CDORevision> list = (ArrayList<CDORevision>)result.get(branch);
                    if (list == null) {
                        list = new ArrayList<CDORevision>();
                        result.put(branch, list);
                    }
                    list.add(revision);
                    return true;
                }
            }));
        }
        finally {
            if (session != null) {
                StoreThreadLocal.release();
                session.close();
            }
        }
        return result;
    }

    public CDOID createObjectID(String val) {
        return this.idHandler.createCDOID(val);
    }

    @Deprecated
    public boolean isLocal(CDOID id) {
        throw new UnsupportedOperationException();
    }

    public CDOID getNextCDOID(LongIDStoreAccessor accessor, CDORevision revision) {
        return this.idHandler.getNextCDOID(revision);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROP_REPOSITORY_CREATED, Long.toString(creationTime));
        this.setPersistentProperties(map);
    }

    public boolean isFirstStart() {
        return this.firstTime;
    }

    public void doPostActivate(InternalSession session) {
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkNull(this.mappingStrategy, Messages.getString("DBStore.2"));
        this.checkNull(this.dbAdapter, Messages.getString("DBStore.1"));
        this.checkNull(this.dbConnectionProvider, Messages.getString("DBStore.0"));
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
    }

    protected void doActivate() throws Exception {
        int schemaVersion;
        super.doActivate();
        InternalRepository repository = this.getRepository();
        CDOCommonRepository.IDGenerationLocation idGenerationLocation = repository.getIDGenerationLocation();
        this.idHandler = idGenerationLocation == CDOCommonRepository.IDGenerationLocation.CLIENT ? new UUIDHandler(this) : new LongIDHandler(this);
        this.setObjectIDTypes(this.idHandler.getObjectIDTypes());
        this.connectionKeepAliveTimer = new Timer("Connection-Keep-Alive-" + this);
        if (this.properties != null) {
            String prop;
            if (idGenerationLocation == CDOCommonRepository.IDGenerationLocation.CLIENT && (prop = this.properties.get("idColumnLength")) != null) {
                this.idColumnLength = Integer.parseInt(prop);
            }
            this.configureAccessorPool(this.readerPool, "readerPoolCapacity");
            this.configureAccessorPool(this.writerPool, "writerPoolCapacity");
            prop = this.properties.get("dropAllDataOnActivate");
            if (prop != null) {
                this.setDropAllDataOnActivate(Boolean.parseBoolean(prop));
            }
            if ((prop = this.properties.get("jdbcFetchSize")) != null) {
                this.jdbcFetchSize = Integer.parseInt(prop);
            }
        }
        Connection connection = this.getConnectionOrRetry();
        String schemaName = this.getSchemaName(connection);
        boolean prependSchemaName = this.isPrependSchemaName();
        try {
            block16: {
                if (this.isDropAllDataOnActivate()) {
                    OM.LOG.info("Dropping all tables from repository " + repository.getName() + "...");
                    DBUtil.dropAllTables((Connection)connection, (String)schemaName);
                    connection.commit();
                }
                if (this.isCreateSchemaIfNeeded()) {
                    try {
                        this.dbAdapter.createSchema(connection, schemaName);
                    }
                    catch (DBException ex) {
                        if (!SHOW_SCHEMA_CREATION_EXCEPTION) break block16;
                        OM.LOG.error((Throwable)ex);
                    }
                }
            }
            if ((schemaVersion = this.selectSchemaVersion(connection, prependSchemaName ? schemaName : null)) >= 0 && schemaVersion < 4) {
                this.migrateSchema(schemaVersion);
            }
            connection.commit();
        }
        finally {
            DBUtil.close((Connection)connection);
        }
        boolean fixNullableIndexColumns = schemaVersion != -1 && schemaVersion < 4;
        this.database = this.openDatabase(this.dbAdapter, this.dbConnectionProvider, schemaName, prependSchemaName, fixNullableIndexColumns);
        this.tables = new DBStoreTables(this);
        this.tables.activate();
        LifecycleUtil.activate((Object)this.idHandler);
        LifecycleUtil.activate((Object)this.metaDataManager);
        LifecycleUtil.activate((Object)this.durableLockingManager);
        LifecycleUtil.activate((Object)this.mappingStrategy);
        if (repository.getCommitInfoStorage() != CDOCommonRepository.CommitInfoStorage.NO) {
            this.commitInfoTable = new CommitInfoTable(this);
            this.commitInfoTable.activate();
        }
        if (repository.isSupportingUnits()) {
            this.unitMappingTable = new UnitMappingTable(this);
            this.unitMappingTable.activate();
        }
        this.setRevisionTemporality(this.mappingStrategy.hasAuditSupport() ? IStore.RevisionTemporality.AUDITING : IStore.RevisionTemporality.NONE);
        this.setRevisionParallelism(this.mappingStrategy.hasBranchingSupport() ? IStore.RevisionParallelism.BRANCHING : IStore.RevisionParallelism.NONE);
        if (schemaVersion == -1) {
            this.firstStart();
        } else {
            this.reStart();
        }
        this.putPersistentProperty(PROP_SCHEMA_VERSION, Integer.toString(4));
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)((Object)this.unitMappingTable));
        LifecycleUtil.deactivate((Object)this.commitInfoTable);
        LifecycleUtil.deactivate((Object)this.mappingStrategy);
        LifecycleUtil.deactivate((Object)this.durableLockingManager);
        LifecycleUtil.deactivate((Object)this.metaDataManager);
        LifecycleUtil.deactivate((Object)this.idHandler);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROP_GRACEFULLY_SHUT_DOWN, StringUtil.TRUE);
        map.put(PROP_REPOSITORY_STOPPED, Long.toString(this.getRepository().getTimeStamp()));
        if (this.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            map.put(PROP_NEXT_LOCAL_CDOID, Store.idToString((CDOID)this.idHandler.getNextLocalObjectID()));
            map.put(PROP_LAST_CDOID, Store.idToString((CDOID)this.idHandler.getLastObjectID()));
        }
        map.put(PROP_LAST_BRANCHID, Integer.toString(this.getLastBranchID()));
        map.put(PROP_LAST_LOCAL_BRANCHID, Integer.toString(this.getLastLocalBranchID()));
        map.put(PROP_LAST_COMMITTIME, Long.toString(this.getLastCommitTime()));
        map.put(PROP_LAST_NONLOCAL_COMMITTIME, Long.toString(this.getLastNonLocalCommitTime()));
        this.setPersistentProperties(map);
        if (this.readerPool != null) {
            this.readerPool.dispose();
        }
        if (this.writerPool != null) {
            this.writerPool.dispose();
        }
        this.connectionKeepAliveTimer.cancel();
        this.connectionKeepAliveTimer = null;
        super.doDeactivate();
    }

    protected boolean isFirstStart(Set<IDBTable> createdTables) {
        if (createdTables.contains((Object)this.tables.properties())) {
            return true;
        }
        HashSet<String> names = new HashSet<String>();
        names.add(PROP_REPOSITORY_CREATED);
        Map<String, String> map = this.getPersistentProperties(names);
        return map.get(PROP_REPOSITORY_CREATED) == null;
    }

    protected void firstStart() {
        InternalRepository repository = this.getRepository();
        this.setCreationTime(repository.getTimeStamp());
        this.firstTime = true;
    }

    protected void reStart() throws Exception {
        HashSet<String> names = new HashSet<String>();
        names.add(PROP_REPOSITORY_CREATED);
        names.add(PROP_GRACEFULLY_SHUT_DOWN);
        Map<String, String> map = this.getPersistentProperties(names);
        this.creationTime = Long.valueOf(map.get(PROP_REPOSITORY_CREATED));
        if (map.containsKey(PROP_GRACEFULLY_SHUT_DOWN)) {
            boolean generatingIDs;
            names.clear();
            InternalRepository repository = this.getRepository();
            boolean bl = generatingIDs = repository.getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE;
            if (generatingIDs) {
                names.add(PROP_NEXT_LOCAL_CDOID);
                names.add(PROP_LAST_CDOID);
            }
            names.add(PROP_LAST_BRANCHID);
            names.add(PROP_LAST_LOCAL_BRANCHID);
            names.add(PROP_LAST_COMMITTIME);
            names.add(PROP_LAST_NONLOCAL_COMMITTIME);
            map = this.getPersistentProperties(names);
            if (generatingIDs) {
                this.idHandler.setNextLocalObjectID(Store.stringToID((String)map.get(PROP_NEXT_LOCAL_CDOID)));
                this.idHandler.setLastObjectID(Store.stringToID((String)map.get(PROP_LAST_CDOID)));
            }
            this.setLastBranchID(Integer.valueOf(map.get(PROP_LAST_BRANCHID)));
            this.setLastLocalBranchID(Integer.valueOf(map.get(PROP_LAST_LOCAL_BRANCHID)));
            this.setLastCommitTime(Long.valueOf(map.get(PROP_LAST_COMMITTIME)));
            this.setLastNonLocalCommitTime(Long.valueOf(map.get(PROP_LAST_NONLOCAL_COMMITTIME)));
        } else {
            this.repairAfterCrash();
        }
        this.removePersistentProperties(Collections.singleton(PROP_GRACEFULLY_SHUT_DOWN));
    }

    protected void repairAfterCrash() {
        InternalRepository repository = this.getRepository();
        OM.LOG.warn(MessageFormat.format(Messages.getString("DBStore.9"), repository.getName()));
        Connection connection = this.getConnection();
        try {
            try {
                connection.setAutoCommit(false);
                connection.setReadOnly(true);
                this.mappingStrategy.repairAfterCrash(this.dbAdapter, connection);
                boolean storeIDs = repository.getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE;
                CDOID lastObjectID = storeIDs ? this.idHandler.getLastObjectID() : CDOID.NULL;
                CDOID nextLocalObjectID = storeIDs ? this.idHandler.getNextLocalObjectID() : CDOID.NULL;
                int branchID = DBUtil.selectMaximumInt((Connection)connection, (IDBField)this.tables.branches().id(), (String[])new String[0]);
                this.setLastBranchID(branchID > 0 ? branchID : 0);
                int localBranchID = DBUtil.selectMinimumInt((Connection)connection, (IDBField)this.tables.branches().id(), (String[])new String[0]);
                this.setLastLocalBranchID(localBranchID < 0 ? localBranchID : 0);
                if (this.commitInfoTable != null) {
                    this.commitInfoTable.repairAfterCrash(connection);
                } else {
                    boolean branching = repository.isSupportingBranches();
                    boolean caseSensitive = this.dbAdapter.isCaseSensitive();
                    String schemaName = this.database.getSchema().getName();
                    long lastCommitTime = 0L;
                    long lastNonLocalCommitTime = 0L;
                    for (String tableName : DBUtil.getAllTableNames((Connection)connection, (String)schemaName, (boolean)caseSensitive)) {
                        try {
                            IDBTable table;
                            IDBField createdField;
                            if (DBUtil.equalNames((String)MappingNames.CDO_OBJECTS, (String)tableName, (boolean)caseSensitive) || (createdField = (table = this.database.getSchema().getTable(tableName)).getField(MappingNames.ATTRIBUTES_CREATED)) == null) continue;
                            if (branching) {
                                IDBField branchField = table.getField(MappingNames.ATTRIBUTES_BRANCH);
                                if (branchField == null) continue;
                                lastNonLocalCommitTime = Math.max(lastNonLocalCommitTime, DBUtil.selectMaximumLong((Connection)connection, (IDBField)branchField, (String[])new String[]{"0<=" + MappingNames.ATTRIBUTES_BRANCH}));
                            }
                            lastCommitTime = Math.max(lastCommitTime, DBUtil.selectMaximumLong((Connection)connection, (IDBField)createdField, (String[])new String[0]));
                        }
                        catch (Exception ex) {
                            OM.LOG.warn(ex.getMessage());
                        }
                    }
                    if (lastNonLocalCommitTime == 0L) {
                        lastNonLocalCommitTime = lastCommitTime;
                    }
                    this.setLastCommitTime(lastCommitTime);
                    this.setLastNonLocalCommitTime(lastNonLocalCommitTime);
                }
                if (storeIDs) {
                    OM.LOG.info(MessageFormat.format(Messages.getString("DBStore.10"), repository.getName(), lastObjectID, nextLocalObjectID, this.getLastBranchID(), this.getLastCommitTime(), this.getLastNonLocalCommitTime()));
                } else {
                    OM.LOG.info(MessageFormat.format(Messages.getString("DBStore.10b"), repository.getName(), this.getLastBranchID(), this.getLastCommitTime(), this.getLastNonLocalCommitTime()));
                }
            }
            catch (SQLException e) {
                OM.LOG.error(MessageFormat.format(Messages.getString("DBStore.11"), repository.getName()), (Throwable)e);
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    private String getSchemaName(Connection connection) {
        String schemaName;
        if (this.properties != null && (schemaName = this.properties.get("schemaName")) != null) {
            return schemaName.length() == 0 ? null : schemaName;
        }
        schemaName = this.dbAdapter.getDefaultSchemaName(connection);
        if (schemaName != null) {
            return schemaName;
        }
        return null;
    }

    private boolean isPrependSchemaName() {
        String prependSchemaName;
        if (this.properties != null && (prependSchemaName = this.properties.get("prependSchemaName")) != null) {
            return Boolean.parseBoolean(prependSchemaName);
        }
        return DEFAULT_PREPEND_SCHEMA_NAME;
    }

    private boolean isCreateSchemaIfNeeded() {
        String createSchemaIfNeeded;
        if (this.properties != null && (createSchemaIfNeeded = this.properties.get("createSchemaIfNeeded")) != null) {
            return Boolean.parseBoolean(createSchemaIfNeeded);
        }
        return DEFAULT_CREATE_SCHEMA_IF_NEEDED;
    }

    protected IDBDatabase openDatabase(IDBAdapter adapter, IDBConnectionProvider connectionProvider, String schemaName, boolean prependSchemaName, boolean fixNullableIndexColumns) {
        return DBUtil.openDatabase((IDBAdapter)this.dbAdapter, (IDBConnectionProvider)this.dbConnectionProvider, (String)schemaName, (boolean)fixNullableIndexColumns, (boolean)prependSchemaName);
    }

    protected IMetaDataManager createMetaDataManager() {
        return new MetaDataManager(this);
    }

    protected DurableLockingManager createDurableLockingManager() {
        return new DurableLockingManager(this);
    }

    protected ProgressDistributor.Geometric createProgressDistributor() {
        return new ProgressDistributor.Geometric(){

            public String toString() {
                String result = "accessorWriteDistributor";
                if (DBStore.this.getRepository() != null) {
                    result = String.valueOf(result) + ": " + DBStore.this.getRepository().getName();
                }
                return result;
            }
        };
    }

    protected StoreAccessorPool createReaderPool() {
        return this.createWriterPool();
    }

    protected StoreAccessorPool createWriterPool() {
        return new StoreAccessorPool((IStore)this, null);
    }

    protected void configureAccessorPool(StoreAccessorPool pool, String property) {
        String value;
        if (pool != null && (value = this.properties.get(property)) != null) {
            int capacity = Integer.parseInt(value);
            pool.setCapacity(capacity);
        }
    }

    protected int selectSchemaVersion(Connection connection, String schemaName) throws SQLException {
        ResultSet resultSet;
        Statement statement;
        block5: {
            int n;
            statement = null;
            resultSet = null;
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(DBStoreTables.PropertiesTable.sqlSelectProperty(PROP_SCHEMA_VERSION, schemaName));
                if (!resultSet.next()) break block5;
                String value = resultSet.getString(1);
                n = Integer.parseInt(value);
            }
            catch (SQLException ex) {
                block6: {
                    block7: {
                        try {
                            connection.rollback();
                            if (!this.dbAdapter.isTableNotFoundException(ex)) break block6;
                            if (DISABLE_LOG_OTHER_SCHEMA_INFO) break block7;
                            this.logOtherSchemaInfo(connection, schemaName);
                        }
                        catch (Throwable throwable) {
                            DBUtil.close(resultSet);
                            DBUtil.close((Statement)statement);
                            throw throwable;
                        }
                    }
                    DBUtil.close((ResultSet)resultSet);
                    DBUtil.close((Statement)statement);
                    return -1;
                }
                throw ex;
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)statement);
            return n;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)statement);
        return 0;
    }

    private void logOtherSchemaInfo(Connection connection, String schemaName) {
        ResultSet tables = null;
        try {
            try {
                HashSet<String> schemaNames = new HashSet<String>();
                tables = connection.getMetaData().getTables(connection.getCatalog(), null, null, DBUtil.ALL_TABLE_NAME_TYPES);
                while (tables.next()) {
                    String tableName = tables.getString(3);
                    if (!DBUtil.equalNames((String)tableName, (String)DBStoreTables.PropertiesTable.tableName(), (boolean)false)) continue;
                    schemaNames.add(tables.getString(2));
                }
                if (!schemaNames.isEmpty()) {
                    String message = "The CDO system tables are not found";
                    if (!StringUtil.isEmpty((String)schemaName)) {
                        message = String.valueOf(message) + " in schema " + DBUtil.quoted((String)schemaName);
                    }
                    message = String.valueOf(message) + "! Other schemas may contain a CDO repository: ";
                    boolean first = true;
                    for (String name : schemaNames) {
                        if (first) {
                            first = false;
                        } else {
                            message = String.valueOf(message) + ", ";
                        }
                        message = String.valueOf(message) + name;
                    }
                    OM.LOG.info(message.trim());
                    OM.LOG.info("This can indicate an attempt to open an existing database with a newer CDO server.\nIt may help to specify 'schemaName=...' and 'prependSchemaName=true' in cdo-server.xml,\nand/or the system property '-Dorg.eclipse.net4j.db.DISABLE_QUOTED_NAMES=true'\n");
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(tables);
            throw throwable;
        }
        DBUtil.close((ResultSet)tables);
    }

    protected void migrateSchema(int fromVersion) throws Exception {
        Connection connection = null;
        try {
            connection = this.getConnection();
            int version = fromVersion;
            while (version < 4) {
                if (this.SCHEMA_MIGRATORS[version] != null) {
                    OM.LOG.info("Migrating schema from version " + version + " to version " + (version + 1) + "...");
                    this.SCHEMA_MIGRATORS[version].migrateSchema(connection);
                }
                ++version;
            }
            connection.commit();
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    private abstract class SchemaMigrator {
        private SchemaMigrator() {
        }

        public abstract void migrateSchema(Connection var1) throws Exception;
    }
}

