/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FeatureTag implements Enumerator
{
    FIELD(0, "Field", "Field"),
    STATIC_FIELD(1, "StaticField", "StaticField"),
    OPERATION(2, "Operation", "Operation"),
    STATIC_OPERATION(3, "StaticOperation", "StaticOperation"),
    QUERY_OPERATION(4, "QueryOperation", "QueryOperation"),
    STATIC_QUERY_OPERATION(5, "StaticQueryOperation", "StaticQueryOperation");

    public static final int FIELD_VALUE = 0;
    public static final int STATIC_FIELD_VALUE = 1;
    public static final int OPERATION_VALUE = 2;
    public static final int STATIC_OPERATION_VALUE = 3;
    public static final int QUERY_OPERATION_VALUE = 4;
    public static final int STATIC_QUERY_OPERATION_VALUE = 5;
    private static final FeatureTag[] VALUES_ARRAY;
    public static final List<FeatureTag> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FeatureTag[]{FIELD, STATIC_FIELD, OPERATION, STATIC_OPERATION, QUERY_OPERATION, STATIC_QUERY_OPERATION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FeatureTag get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FeatureTag result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FeatureTag getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FeatureTag result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FeatureTag get(int value) {
        switch (value) {
            case 0: {
                return FIELD;
            }
            case 1: {
                return STATIC_FIELD;
            }
            case 2: {
                return OPERATION;
            }
            case 3: {
                return STATIC_OPERATION;
            }
            case 4: {
                return QUERY_OPERATION;
            }
            case 5: {
                return STATIC_QUERY_OPERATION;
            }
        }
        return null;
    }

    private FeatureTag(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

