/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.CSTHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers.IElementInfoProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.PathNameHyperlinkDetector;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.ecore.EcoreEnvironment;

public class PathNameInfoProvider
implements IElementInfoProvider {
    @Override
    public String getElementInfo(Object element, ITextViewer textViewer, IRegion region) {
        if (element instanceof CSTNode) {
            CSTNode syntaxElement = (CSTNode)element;
            EModelElement referencedElement = PathNameHyperlinkDetector.findReferencedElementDefinition(syntaxElement, region);
            if (referencedElement instanceof ModelType) {
                StringBuilder buf = new StringBuilder();
                int counter = 0;
                ModelType modelType = (ModelType)referencedElement;
                for (EPackage nextPackage : modelType.getMetamodel()) {
                    if (counter > 0) {
                        buf.append('\n');
                    }
                    if (nextPackage.getName() != null) {
                        buf.append(nextPackage.getName());
                    }
                    if (nextPackage.getNsURI() != null) {
                        buf.append(" - ").append(nextPackage.getNsURI());
                    }
                    ++counter;
                }
                return buf.toString();
            }
            EcoreEnvironment env = CSTHelper.getEnvironment(syntaxElement);
            if (env != null) {
                return env.getUMLReflection().getQualifiedName((Object)referencedElement);
            }
        }
        return null;
    }
}

