/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.actions;

import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.editor.actions.AntEditorActionMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class TogglePresentationAction
extends TextEditorAction
implements IPropertyChangeListener {
    private IPreferenceStore fStore;

    public TogglePresentationAction() {
        super(AntEditorActionMessages.getResourceBundle(), "TogglePresentation.", null, 2);
        this.setImageDescriptor(AntUIImages.getImageDescriptor("org.eclipse.ant.ui.segmentEdit"));
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        IRegion remembered = editor.getHighlightRange();
        editor.resetHighlightRange();
        boolean showAll = !editor.showsHighlightRangeOnly();
        this.setChecked(showAll);
        editor.showHighlightRangeOnly(showAll);
        if (remembered != null) {
            editor.setHighlightRange(remembered.getOffset(), remembered.getLength(), true);
        }
        this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fStore.setValue("editor_show_segments", showAll);
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        boolean checked = editor != null && editor.showsHighlightRangeOnly();
        this.setChecked(checked);
        this.setEnabled(editor != null);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        if (editor != null) {
            if (this.fStore == null) {
                this.fStore = AntUIPlugin.getDefault().getPreferenceStore();
                this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            this.synchronizeWithPreference(editor);
        } else if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        this.update();
    }

    private void synchronizeWithPreference(ITextEditor editor) {
        if (editor == null) {
            return;
        }
        boolean showSegments = this.fStore.getBoolean("editor_show_segments");
        this.setChecked(showSegments);
        if (editor.showsHighlightRangeOnly() != showSegments) {
            IRegion remembered = editor.getHighlightRange();
            editor.resetHighlightRange();
            editor.showHighlightRangeOnly(showSegments);
            if (remembered != null) {
                editor.setHighlightRange(remembered.getOffset(), remembered.getLength(), true);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("editor_show_segments")) {
            this.synchronizeWithPreference(this.getTextEditor());
        }
    }
}

