/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.ui.refactoring.MethodContext;
import org.eclipse.cdt.internal.ui.refactoring.NameInformation;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;

public class ExtractFunctionInformation {
    private VisibilityEnum visibility = VisibilityEnum.v_private;
    private String methodName;
    private boolean replaceDuplicates;
    private List<NameInformation> parameters;
    private NameInformation mandatoryReturnVariable;
    private ICPPASTFunctionDeclarator declarator;
    private MethodContext context;
    private boolean isExtractExpression;
    private boolean virtual;

    public ICPPASTFunctionDeclarator getDeclarator() {
        return this.declarator;
    }

    public void setDeclarator(ICPPASTFunctionDeclarator declarator) {
        this.declarator = declarator;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public boolean isReplaceDuplicates() {
        return this.replaceDuplicates;
    }

    public void setReplaceDuplicates(boolean replaceDuplicates) {
        this.replaceDuplicates = replaceDuplicates;
    }

    public NameInformation getReturnVariable() {
        if (this.mandatoryReturnVariable != null) {
            return this.mandatoryReturnVariable;
        }
        for (NameInformation param : this.parameters) {
            if (!param.isReturnValue()) continue;
            return param;
        }
        return null;
    }

    public NameInformation getMandatoryReturnVariable() {
        return this.mandatoryReturnVariable;
    }

    public void setMandatoryReturnVariable(NameInformation variable) {
        this.mandatoryReturnVariable = variable;
    }

    public List<NameInformation> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<NameInformation> parameters) {
        this.parameters = new ArrayList<NameInformation>(parameters);
    }

    public VisibilityEnum getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityEnum visibility) {
        this.visibility = visibility;
    }

    public MethodContext getMethodContext() {
        return this.context;
    }

    public void setMethodContext(MethodContext context) {
        this.context = context;
    }

    public boolean isExtractExpression() {
        return this.isExtractExpression;
    }

    public void setExtractExpression(boolean isExtractExpression) {
        this.isExtractExpression = isExtractExpression;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean isVirtual) {
        this.virtual = isVirtual;
    }

    public void sortParameters(final boolean outFirst) {
        Collections.sort(this.parameters, new Comparator<NameInformation>(){

            @Override
            public int compare(NameInformation p1, NameInformation p2) {
                boolean out2;
                boolean out1 = p1.isOutputParameter() || ExtractFunctionInformation.hasNonConstPointerOrReference(p1);
                boolean bl = out2 = p2.isOutputParameter() || ExtractFunctionInformation.hasNonConstPointerOrReference(p2);
                return out1 == out2 ? 0 : (out1 == outFirst ? -1 : 1);
            }
        });
    }

    public static boolean hasNonConstPointerOrReference(NameInformation param) {
        IASTDeclarator declarator = param.getDeclarator();
        IASTPointerOperator[] operators = declarator.getPointerOperators();
        if (operators.length != 0) {
            IASTDeclSpecifier declSpecifier = param.getDeclSpecifier();
            return declSpecifier == null || !declSpecifier.isConst();
        }
        return false;
    }
}

