/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.annotate.mapping;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.jpa.annotate.mapping.AnnotationAttribute;

public class AnnotationAttrConverter {
    public static final String FETCH = "fetch";
    public static final String LOB_TYPE = "lob-type";
    public static final String DISCRIMINATOR_TYPE = "discriminator-type";
    public static final String TEMPORAL = "temporal";
    public static final String INHERITANCE_STRAGETY = "inheritance-strategy";
    public static final String GENERATION_STRATEGY = "generation-stragegy";
    private static Map<String, String> tagEnumClassMap = new HashMap<String, String>(8);
    private static Map<String, String[]> tagEnumValuesMap;

    static {
        tagEnumClassMap.put(FETCH, "javax.persistence.FetchType");
        tagEnumClassMap.put(LOB_TYPE, "java.lang.annotation.ElementType");
        tagEnumClassMap.put(DISCRIMINATOR_TYPE, "javax.persistence.DiscriminatorType");
        tagEnumClassMap.put(TEMPORAL, "javax.persistence.TemporalType");
        tagEnumClassMap.put(INHERITANCE_STRAGETY, "javax.persistence.InheritanceType");
        tagEnumClassMap.put(GENERATION_STRATEGY, "javax.persistence.GenerationType");
        tagEnumValuesMap = new HashMap<String, String[]>(8);
        tagEnumValuesMap.put(FETCH, new String[]{"LAZY", "EAGER"});
        tagEnumValuesMap.put(LOB_TYPE, new String[]{"METHOD", "FIELD"});
        tagEnumValuesMap.put(DISCRIMINATOR_TYPE, new String[]{"CHAR", "INTEGER", "STRING"});
        tagEnumValuesMap.put(TEMPORAL, new String[]{"DATE", "TIME", "TIMESTAMP"});
        tagEnumValuesMap.put(INHERITANCE_STRAGETY, new String[]{"JOINED", "SINGLE_TABLE", "TABLE_PER_CLASS"});
        tagEnumValuesMap.put(GENERATION_STRATEGY, new String[]{"AUTO", "IDENTITY", "SEQUENCE", "TABLE"});
    }

    public static String[] getTagEnumStringValues(String tagName) {
        return tagEnumValuesMap.get(tagName);
    }

    public static String getTagEnumClass(String tagName) {
        return tagEnumClassMap.get(tagName);
    }

    public static String adjustAnnotationValue(AnnotationAttribute attr) {
        String attrVal = attr.attrValue;
        String enumClass = AnnotationAttrConverter.getTagEnumClass(attr.tagName);
        if (enumClass == null) {
            return attrVal;
        }
        if (enumClass.equals("javax.persistence.DiscriminatorType") && "CHARACTER".equals(attrVal)) {
            attrVal = "CHAR";
        }
        return enumClass + "." + attrVal;
    }
}

