/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.persistence;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jpt.common.ui.internal.jface.ResourceManagerLabelProvider;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.persistence.JarFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.persistence.ArchiveFileSelectionDialog;
import org.eclipse.jpt.jpa.ui.persistence.JptJpaUiPersistenceMessages;
import org.eclipse.swt.widgets.Composite;

public abstract class PersistenceUnitJarFilesComposite
extends Pane<PersistenceUnit> {
    private static final Transformer<JarFileRef, ImageDescriptor> JAR_FILE_REF_LABEL_IMAGE_DESCRIPTOR_TRANSFORMER = TransformerTools.staticOutputTransformer((Object)JptJpaUiImages.JAR_FILE_REF);
    private static final Transformer<JarFileRef, String> JAR_FILE_REF_LABEL_TEXT_TRANSFORMER = new JarFileRefLabelTextTransformer();

    public PersistenceUnitJarFilesComposite(Pane<? extends PersistenceUnit> parent, Composite parentComposite) {
        super(parent, parentComposite);
    }

    protected void initializeLayout(Composite container) {
        this.addJarFilesList(container);
    }

    protected void addJarFilesList(Composite container) {
        new AddRemoveListPane((Pane)this, container, this.buildAdapter(), this.buildItemListHolder(), this.buildSelectedJarFileRefsModel(), this.buildJarFileRefLabelProvider(), JpaHelpContextIds.PERSISTENCE_XML_GENERAL);
    }

    private AddRemovePane.Adapter<JarFileRef> buildAdapter() {
        return new AddRemovePane.AbstractAdapter<JarFileRef>(){

            public JarFileRef addNewItem() {
                return PersistenceUnitJarFilesComposite.this.addJarFileRef();
            }

            public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<JarFileRef> selectedItemsModel) {
                return this.buildSingleSelectedItemEnabledModel(selectedItemsModel);
            }

            public void removeSelectedItems(CollectionValueModel<JarFileRef> selectedItemsModel) {
                JarFileRef jarFileRef = (JarFileRef)selectedItemsModel.iterator().next();
                ((PersistenceUnit)PersistenceUnitJarFilesComposite.this.getSubject()).removeJarFileRef(jarFileRef);
            }
        };
    }

    private ListValueModel<JarFileRef> buildItemListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildListHolder(), new String[]{"fileName"});
    }

    private ListValueModel<JarFileRef> buildListHolder() {
        return new ListAspectAdapter<PersistenceUnit, JarFileRef>(this.getSubjectHolder(), new String[]{"jarFileRefs"}){

            protected ListIterable<JarFileRef> getListIterable() {
                return ((PersistenceUnit)this.subject).getJarFileRefs();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).getJarFileRefsSize();
            }
        };
    }

    protected ModifiableCollectionValueModel<JarFileRef> buildSelectedJarFileRefsModel() {
        return new SimpleCollectionValueModel();
    }

    private ILabelProvider buildJarFileRefLabelProvider() {
        return new ResourceManagerLabelProvider(JAR_FILE_REF_LABEL_IMAGE_DESCRIPTOR_TRANSFORMER, JAR_FILE_REF_LABEL_TEXT_TRANSFORMER, this.getResourceManager());
    }

    JarFileRef addJarFileRef() {
        IProject project = ((PersistenceUnit)this.getSubject()).getJpaProject().getProject();
        ArchiveFileSelectionDialog dialog = new ArchiveFileSelectionDialog(this.getShell(), this.buildJarFileDeploymentPathCalculator());
        dialog.setHelpAvailable(false);
        dialog.setTitle(JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_MAPPING_FILES_COMPOSITE_JAR_FILE_DIALOG_TITLE);
        dialog.setMessage(JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_MAPPING_FILES_COMPOSITE_JAR_FILE_DIALOG_MESSAGE);
        dialog.setInput(project);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                String filePath = (String)result;
                if (!this.jarFileRefExists(filePath)) {
                    return ((PersistenceUnit)this.getSubject()).addJarFileRef(filePath);
                }
                ++n2;
            }
        }
        return null;
    }

    protected ArchiveFileSelectionDialog.DeploymentPathCalculator buildJarFileDeploymentPathCalculator() {
        return new ArchiveFileSelectionDialog.ModuleDeploymentPathCalculator();
    }

    private boolean jarFileRefExists(String fileName) {
        for (JarFileRef each : ((PersistenceUnit)this.getSubject()).getJarFileRefs()) {
            if (!each.getFileName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    static class JarFileRefLabelTextTransformer
    extends AbstractTransformer<JarFileRef, String> {
        JarFileRefLabelTextTransformer() {
        }

        protected String transform_(JarFileRef jarFileRef) {
            String name = jarFileRef.getFileName();
            return name != null ? name : JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_JAR_FILES_COMPOSITE_NO_FILE_NAME;
        }
    }
}

