/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.preferences.PersistentMergeContext;
import org.eclipse.wst.ws.internal.wsrt.IMerger;
import org.eclipse.wst.ws.internal.wsrt.Merger;
import org.osgi.framework.Bundle;

public class JavaMerger
extends Merger
implements IMerger {
    private static final String WST_WS = "org.eclipse.wst.ws";
    private static final String MERGE_XML = "merge.xml";
    private static final String JMERGER = "jmerger";
    private int size = 0;
    private IFile[] workspaceFiles;
    private JMerger[] mergeModels;
    private JControlModel jMergeControlModel = null;
    private IStatus loadStatus;

    public IStatus load(IFile[] files) {
        this.loadStatus = Status.OK_STATUS;
        if (files != null) {
            this.workspaceFiles = files;
            PersistentMergeContext mergeContext = WSPlugin.getInstance().getMergeContext();
            if (mergeContext.isSkeletonMergeEnabled()) {
                this.initialize();
                if (this.jMergeControlModel != null) {
                    this.size = files.length;
                    this.mergeModels = new JMerger[this.size];
                    int i = 0;
                    while (i < this.size) {
                        JMerger jMerger;
                        block20: {
                            jMerger = null;
                            IFile file = null;
                            InputStream inStream = null;
                            file = files[i];
                            if (file != null && file.exists()) {
                                try {
                                    try {
                                        inStream = file.getContents();
                                        if (inStream != null) {
                                            jMerger = new JMerger(this.jMergeControlModel);
                                            jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(inStream));
                                        }
                                    }
                                    catch (CoreException e) {
                                        this.loadStatus = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_FILE_MERGE_LOAD, (Object)file), (Throwable)e);
                                        if (inStream != null) {
                                            try {
                                                inStream.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        break block20;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (inStream != null) {
                                        try {
                                            inStream.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    throw throwable;
                                }
                                if (inStream != null) {
                                    try {
                                        inStream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                        this.mergeModels[i] = jMerger;
                        ++i;
                    }
                }
            }
        }
        return this.loadStatus;
    }

    private void initialize() {
        if (this.jMergeControlModel == null) {
            FacadeHelper facadeHelper = CodeGenUtil.instantiateFacadeHelper((String)JMerger.DEFAULT_FACADE_HELPER_CLASS);
            this.jMergeControlModel = new JControlModel();
            Bundle wsBundle = Platform.getBundle((String)WST_WS);
            IPath mergePath = new Path(JMERGER).append(MERGE_XML);
            URL fileURL = FileLocator.find((Bundle)wsBundle, (IPath)mergePath, null);
            this.jMergeControlModel.initialize(facadeHelper, fileURL.toString());
        }
    }

    public IStatus merge(IProgressMonitor monitor, IStatusHandler statusHandler) {
        IStatus status = Status.OK_STATUS;
        if (this.loadStatus != null && this.loadStatus.getSeverity() == 4) {
            return this.loadStatus;
        }
        PersistentMergeContext mergeContext = WSPlugin.getInstance().getMergeContext();
        if (mergeContext.isSkeletonMergeEnabled()) {
            TransientResourceContext resourceContext = new TransientResourceContext();
            resourceContext.setCheckoutFilesEnabled(true);
            resourceContext.setCreateFoldersEnabled(true);
            resourceContext.setOverwriteFilesEnabled(true);
            int i = 0;
            while (i < this.size) {
                block21: {
                    String mergedContent = null;
                    JMerger jMerger = null;
                    IFile file = null;
                    InputStream inStream = null;
                    byte[] buf = null;
                    jMerger = this.mergeModels[i];
                    file = this.workspaceFiles[i];
                    if (file != null && jMerger != null && file.exists()) {
                        block20: {
                            try {
                                try {
                                    inStream = file.getContents();
                                    jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForInputStream(inStream));
                                    jMerger.merge();
                                    mergedContent = jMerger.getTargetCompilationUnitContents();
                                    if (mergedContent == null) break block20;
                                    try {
                                        buf = mergedContent.getBytes(file.getCharset());
                                    }
                                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                                        buf = mergedContent.getBytes();
                                    }
                                    inStream = new ByteArrayInputStream(buf);
                                    IPath targetPath = file.getLocation();
                                    if (targetPath != null) {
                                        FileResourceUtils.createFileAtLocation((ResourceContext)resourceContext, (IPath)targetPath.makeAbsolute(), (InputStream)inStream, (IProgressMonitor)monitor, (IStatusHandler)statusHandler);
                                    }
                                }
                                catch (CoreException e) {
                                    status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_FILE_MERGE, (Object)file), (Throwable)e);
                                    try {
                                        if (inStream != null) {
                                            inStream.close();
                                        }
                                        break block21;
                                    }
                                    catch (IOException iOException) {}
                                    break block21;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (inStream != null) {
                                        inStream.close();
                                    }
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                        }
                        try {
                            if (inStream != null) {
                                inStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                ++i;
            }
        }
        return status;
    }
}

