/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.internal.util.container.PluginContainer;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.container.ManagedContainer;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.properties.PropertiesContainerUtil;

public final class ContainerUtil {
    public static final String PROP_CONTAINER = "org.eclipse.net4j.util.container";
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final IContainer<Object> EMPTY = new IContainer<Object>(){

        @Override
        public Object[] getElements() {
            return NO_ELEMENTS;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void addListener(IListener listener) {
        }

        @Override
        public void removeListener(IListener listener) {
        }

        @Override
        public IListener[] getListeners() {
            return EventUtil.NO_LISTENERS;
        }

        @Override
        public boolean hasListeners() {
            return false;
        }

        public String toString() {
            return "EMPTY_CONTAINER";
        }
    };

    private ContainerUtil() {
    }

    public static void prepareContainer(IManagedContainer container) {
        OM.BUNDLE.prepareContainer(container);
    }

    public static IManagedContainer getContainer(Object object) {
        if (object instanceof IManagedContainerProvider) {
            return ((IManagedContainerProvider)object).getContainer();
        }
        return PropertiesContainerUtil.getProperty(object, PROP_CONTAINER, IManagedContainer.class);
    }

    public static IContainer<Object> emptyContainer() {
        return EMPTY;
    }

    public static IManagedContainer createContainer() {
        return new ManagedContainer();
    }

    public static boolean isEmpty(Object container) {
        if (container instanceof IContainer) {
            return ((IContainer)container).isEmpty();
        }
        return true;
    }

    public static Object[] getElements(Object container) {
        if (container instanceof IContainer) {
            return ((IContainer)container).getElements();
        }
        return NO_ELEMENTS;
    }

    public static IManagedContainer createPluginContainer() {
        return new PluginContainer();
    }
}

