/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.profiler.view;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sirius.common.ui.tools.api.profiler.view.TimeProfilerViewItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class TimeProfilerViewLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    public static final int CATEGORY_COL = 0;
    public static final int TASK_NAME_COL = 1;
    public static final int TIME_COL = 2;
    public static final int OCCURENCES_COL = 3;

    public Image getColumnImage(Object element, int columnIndex) {
        Image columnImage = null;
        if (element instanceof TimeProfilerViewItem) {
            TimeProfilerViewItem item = (TimeProfilerViewItem)element;
            switch (columnIndex) {
                case 0: {
                    columnImage = item.getCategoryImage();
                    break;
                }
                case 1: {
                    columnImage = item.getTaskImage();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        return columnImage;
    }

    public String getColumnText(Object element, int columnIndex) {
        String columnText = "";
        if (element instanceof TimeProfilerViewItem) {
            TimeProfilerViewItem item = (TimeProfilerViewItem)element;
            switch (columnIndex) {
                case 0: {
                    columnText = item.getTask().getCategory();
                    break;
                }
                case 1: {
                    columnText = item.getTask().getName();
                    break;
                }
                case 2: {
                    columnText = item.getTime().toString();
                    break;
                }
                case 3: {
                    columnText = item.getOccurences().toString();
                    break;
                }
                default: {
                    columnText = "";
                }
            }
        }
        return columnText;
    }

    public Color getBackground(Object element) {
        return TimeProfilerViewLabelProvider.getColor(25);
    }

    public Color getForeground(Object element) {
        return TimeProfilerViewLabelProvider.getColor(24);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Color getColor(final int which) {
        Display display = Display.getCurrent();
        if (display != null) {
            return display.getSystemColor(which);
        }
        display = Display.getDefault();
        final Color[] result = new Color[1];
        display.syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Color[] colorArray = result;
                synchronized (result) {
                    result[0] = Display.getCurrent().getSystemColor(which);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        Color[] colorArray = result;
        synchronized (result) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result[0];
        }
    }
}

