/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.commands;

import java.util.LinkedList;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.DefaultNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ui.tools.api.profiler.SiriusTasks;

public class RemoveInvalidViewsCommand
extends IdentityCommand {
    private Resource airdResource;

    public RemoveInvalidViewsCommand(Resource airdResource) {
        super(Messages.RemoveInvalidViewsCommand_label);
        this.airdResource = airdResource;
    }

    public void execute() {
        TreeIterator iterContents = this.airdResource.getAllContents();
        LinkedList<View> viewsToRemove = new LinkedList<View>();
        while (iterContents.hasNext()) {
            View currentView;
            EObject next = (EObject)iterContents.next();
            if (!(next instanceof View) || this.isValid(currentView = (View)next)) continue;
            viewsToRemove.add(currentView);
        }
        for (View view : viewsToRemove) {
            SiriusUtil.delete((EObject)view);
        }
        this.airdResource = null;
    }

    public boolean isValid(View view) {
        return this.isValid(view, false);
    }

    public boolean isValid(View view, boolean checkElement) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasks.IS_VIEW_VALID);
        boolean result = true;
        try {
            if (checkElement) {
                result = view.getElement() != null && view.getElement().eResource() != null;
            }
            result = result && !(EditPartService.getInstance().createGraphicEditPart(view) instanceof DefaultNodeEditPart);
        }
        catch (Exception exception) {}
        DslCommonPlugin.PROFILER.stopWork(SiriusTasks.IS_VIEW_VALID);
        return result;
    }

    public boolean canUndo() {
        return false;
    }
}

