/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.rules;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;

public abstract class StandardBeanPropertiesFlaggedRule
implements FailableBiConsumer<ComponentDescription, Object, Exception> {
    public final void accept(ComponentDescription componentDescription, Object properties) throws Exception {
        String[] names;
        String namesString = this.getNames(properties);
        String[] stringArray = names = StringUtils.split((String)namesString);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            for (GenericPropertyDescription propertyDescription : componentDescription.getProperties()) {
                String id = propertyDescription.getId();
                if (!StandardBeanPropertiesFlaggedRule.matchPropertyId(id, name)) continue;
                this.configure(propertyDescription);
            }
            ++n2;
        }
    }

    protected abstract void configure(GenericPropertyDescription var1);

    protected abstract String getNames(Object var1);

    public static boolean matchPropertyId(String id, String name) {
        if (name.startsWith("m:")) {
            String signaturePrefix = "set" + StringUtils.capitalize((String)name.substring(2)) + "(";
            return StandardBeanPropertiesFlaggedRule.matchAsSetter(id, signaturePrefix);
        }
        if (name.startsWith("f:")) {
            String fieldName = name.substring(2);
            return StandardBeanPropertiesFlaggedRule.matchAsField(id, fieldName);
        }
        if (name.indexOf(40) != -1) {
            return StandardBeanPropertiesFlaggedRule.matchAsSetter(id, name);
        }
        if (name.endsWith("*")) {
            String signaturePrefix = "set" + StringUtils.capitalize((String)name.substring(0, name.length() - 1));
            return StandardBeanPropertiesFlaggedRule.matchAsSetter(id, signaturePrefix);
        }
        String signaturePrefix = "set" + StringUtils.capitalize((String)name) + "(";
        if (StandardBeanPropertiesFlaggedRule.matchAsSetter(id, signaturePrefix)) {
            return true;
        }
        return StandardBeanPropertiesFlaggedRule.matchAsField(id, name);
    }

    private static boolean matchAsSetter(String id, String signaturePrefix) {
        return id.startsWith(signaturePrefix);
    }

    private static boolean matchAsField(String id, String fieldName) {
        return id.equals(fieldName);
    }
}

