/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import org.eclipse.wst.jsdt.chromium.internal.wip.WipTabImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.page.FrameNavigatedEventData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.page.FrameValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.page.GetResourceTreeData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.page.GetResourceTreeParams;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;

class WipFrameManager {
    private final WipTabImpl tabImpl;
    private boolean urlUnknown = true;

    WipFrameManager(WipTabImpl tabImpl) {
        this.tabImpl = tabImpl;
    }

    void readFrames() {
        GetResourceTreeParams requestParams = new GetResourceTreeParams();
        GenericCallback<GetResourceTreeData> callback = new GenericCallback<GetResourceTreeData>(){

            public void success(GetResourceTreeData value) {
                FrameValue frame = value.frameTree().frame();
                if (frame.parentId() != null) {
                    throw new RuntimeException("Unexpected parentId value");
                }
                String url = frame.url();
                boolean silentUpdate = WipFrameManager.this.urlUnknown;
                WipFrameManager.this.tabImpl.updateUrl(url, silentUpdate);
                WipFrameManager.this.urlUnknown = false;
            }

            public void failure(Exception exception) {
                throw new RuntimeException("Failed to read frame data", exception);
            }
        };
        this.tabImpl.getCommandProcessor().send(requestParams, callback, null);
    }

    void frameNavigated(FrameNavigatedEventData eventData) {
        FrameValue frame = eventData.frame();
        String parentId = frame.parentId();
        if (parentId == null) {
            String newUrl = frame.url();
            this.tabImpl.updateUrl(newUrl, false);
            this.urlUnknown = false;
        }
    }
}

