/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderFileEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class ActionHelper {
    public static IEditorInput createEditorInput(IResource resource, String editorID, ISQLEditorConnectionInfo connInfo) {
        FileEditorInput editorInput = null;
        if (editorID.equals("org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderEditor")) {
            if (resource instanceof IFile) {
                FileEditorInput fileEditorInput;
                IFile fileResource = (IFile)resource;
                editorInput = fileEditorInput = new FileEditorInput(fileResource);
            }
        } else if (editorID.equals("org.eclipse.datatools.sqltools.sqleditor") && resource instanceof IFile) {
            IFile fileResource = (IFile)resource;
            SQLBuilderFileEditorInput sqlEditorInput = new SQLBuilderFileEditorInput(fileResource);
            sqlEditorInput.setConnectionInfo(connInfo);
            editorInput = sqlEditorInput;
        }
        return editorInput;
    }

    public static String[] getTemplateDDLStatements() {
        String[] ddlStatements = new String[]{"CREATE TABLE table_name (col1 VARCHAR(10) NOT NULL, col2 INTEGER) ;", "CREATE VIEW view_name AS SELECT col1, col2 FROM table1 ;", "CREATE UNIQUE INDEX index_name ON table_name (col1, col2);", "CREATE SCHEMA schema_name;", "ALTER TABLE table_name ADD COLUMN column_name INTEGER NOT NULL;", "DROP TABLE table_name ;", "DROP VIEW view_name ;", "DROP INDEX index_name ;"};
        return ddlStatements;
    }

    public static String[] getTemplateDMLStatements() {
        String[] dmlStatements = new String[]{"SELECT col1, col2 FROM table1, table2 WHERE table1.col1 = table2.col2 ;", "INSERT INTO table_name (col1, col2) VALUES ('val1', 'val2') ;", "UPDATE table_name SET col1='val1' WHERE table_name.col2 = '123' ;", "DELETE FROM table_name WHERE table_name.col_name = '123' ;"};
        return dmlStatements;
    }

    public static String getTemplateSQLForStatementType(int statementType) {
        String sql = null;
        if (statementType < 6) {
            QueryStatement statement = StatementHelper.createQueryStatement((int)statementType, (String)"TempName");
            sql = statement.getSQL();
        } else if (statementType == 6) {
            StringBuffer sb = new StringBuffer();
            sb.append("\n\n-- " + Messages._UI_SAMPLE_DML_TEMPLATE_STATEMENTS + " -- \n\n");
            String[] stmtArray = ActionHelper.getTemplateDMLStatements();
            int i = 0;
            while (i < stmtArray.length) {
                sb.append(String.valueOf(stmtArray[i]) + "\n\n");
                ++i;
            }
            sb.append("\n\n-- " + Messages._UI_SAMPLE_DDL_TEMPLATE_STATEMENTS + " -- \n\n");
            stmtArray = ActionHelper.getTemplateDDLStatements();
            i = 0;
            while (i < stmtArray.length) {
                sb.append(String.valueOf(stmtArray[i]) + "\n\n");
                ++i;
            }
            sql = sb.toString();
        } else if (statementType == 7) {
            sql = "";
        }
        return sql;
    }
}

