/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.PredicateBasic;
import org.eclipse.datatools.modelbase.sql.query.PredicateBetween;
import org.eclipse.datatools.modelbase.sql.query.PredicateComparisonOperator;
import org.eclipse.datatools.modelbase.sql.query.PredicateExists;
import org.eclipse.datatools.modelbase.sql.query.PredicateIn;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueList;
import org.eclipse.datatools.modelbase.sql.query.PredicateIsNull;
import org.eclipse.datatools.modelbase.sql.query.PredicateLike;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelFactory;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombinedOperator;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionNested;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.query.impl.SQLQueryModelFactoryImpl;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLPredicateExists;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.emf.common.util.EList;

public class SearchConditionHelper {
    SQLDomainModel domainModel;
    ExpressionHelper eHelper = new ExpressionHelper();
    boolean havingClause = false;
    public static final String[] operators = new String[]{"=", "<", "<=", ">", ">=", "<>", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL", "LIKE", "NOT LIKE", "IN", "NOT IN", "EXISTS", "XMLEXISTS"};

    public SearchConditionHelper(SQLDomainModel domainModel) {
        this.domainModel = domainModel;
    }

    public Predicate buildNewPredicate(SQLQueryObject currStmt, QueryValueExpression left, String right, String comparisonKind) {
        Predicate pred = null;
        if (comparisonKind.trim().length() == 0) {
            pred = SearchConditionHelper.buildEmptyPredicate();
            ((PredicateBasic)pred).setLeftValueExpr(ExpressionHelper.createExpression(left));
            ((PredicateBasic)pred).setRightValueExpr(ExpressionHelper.createExpression(right));
        } else {
            String fromClause = TableHelper.createFromClauseForStatement((SQLQueryObject)currStmt);
            String leftStr = "";
            String rightStr = "";
            if (left != null) {
                leftStr = left.getSQL();
            }
            rightStr = right != null ? right : "";
            if (fromClause.length() > 0) {
                String stmtString = "Select 1 " + fromClause + " where " + leftStr + " " + comparisonKind + " " + rightStr;
                Predicate newPred = null;
                try {
                    QuerySelectStatement newStmt = (QuerySelectStatement)this.domainModel.parse(stmtString);
                    QueryExpressionRoot queryExprRoot = newStmt.getQueryExpr();
                    QueryExpressionBody queryExprBody = queryExprRoot.getQuery();
                    QuerySelect qSelect = (QuerySelect)queryExprBody;
                    List tableRefList = StatementHelper.getTablesForStatement((SQLQueryObject)currStmt);
                    this.eHelper.resolveColumnReferencesInTemporaryStatement(qSelect, tableRefList);
                    newPred = (Predicate)qSelect.getWhereClause();
                }
                catch (Exception exception) {
                    newPred = null;
                }
                if (newPred != null) {
                    pred = newPred;
                }
            }
        }
        return pred;
    }

    public static Predicate buildEmptyPredicate() {
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        PredicateBasic sqlPredicate = factory.createPredicateBasic();
        return sqlPredicate;
    }

    public static QuerySearchCondition buildSearchCondition(QuerySearchCondition currentSearchCon, QueryValueExpression leftExpr, QueryValueExpression rightExpr, String oper) {
        PredicateBasic newCondition = null;
        PredicateBasic pred = SearchConditionHelper.buildPredicateBasic(leftExpr, rightExpr, oper);
        if (currentSearchCon == null) {
            newCondition = pred;
        } else {
            SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
            SearchConditionCombined combined = factory.createSearchConditionCombined();
            combined.setLeftCondition(currentSearchCon);
            combined.setRightCondition((QuerySearchCondition)pred);
            combined.setCombinedOperator(SearchConditionCombinedOperator.get((String)"AND"));
            newCondition = combined;
        }
        return newCondition;
    }

    public static PredicateBasic buildPredicateBasic(QueryValueExpression leftExpr, QueryValueExpression rightExpr, String oper) {
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        PredicateBasic pred = factory.createPredicateBasic();
        pred.setLeftValueExpr(leftExpr);
        pred.setRightValueExpr(rightExpr);
        String operLiteral = SearchConditionHelper.getComparisonLiteralFromSymbol(oper);
        PredicateComparisonOperator operEnum = PredicateComparisonOperator.get((String)operLiteral);
        pred.setComparisonOperator(operEnum);
        return pred;
    }

    public QuerySearchCondition buildSearchCondition(SQLQueryObject currStmt, QuerySearchCondition currentSearchCon, QueryValueExpression left, String right, String comparisonKind) {
        Predicate newSearchCon = null;
        Predicate predicate = this.buildNewPredicate(currStmt, left, right, comparisonKind);
        if (currentSearchCon == null) {
            newSearchCon = predicate;
        } else {
            SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
            SearchConditionCombined sqlGroup = factory.createSearchConditionCombined();
            sqlGroup.setLeftCondition(currentSearchCon);
            sqlGroup.setRightCondition((QuerySearchCondition)predicate);
            sqlGroup.setCombinedOperator(SearchConditionCombinedOperator.get((String)"AND"));
            newSearchCon = sqlGroup;
        }
        return newSearchCon;
    }

    public static QuerySearchCondition removePredicateFromCondition(Predicate pred, QuerySearchCondition searchCon) {
        if (pred.getCombinedRight() == null && pred.getCombinedLeft() == null) {
            searchCon = null;
        } else if (pred.getCombinedRight() != null && pred.getCombinedRight().getCombinedLeft() == null) {
            searchCon = pred.getCombinedRight().getLeftCondition();
            if (searchCon != null) {
                searchCon.setCombinedLeft(null);
            }
        } else if (pred.getCombinedLeft() != null) {
            if (pred.getCombinedLeft().getCombinedLeft() != null) {
                pred.getCombinedLeft().getCombinedLeft().setLeftCondition(pred.getCombinedLeft().getRightCondition());
            } else {
                searchCon = pred.getCombinedLeft().getRightCondition();
            }
        } else if (pred.getCombinedRight() != null && pred.getCombinedRight().getCombinedLeft() != null) {
            SearchConditionCombined currentGroup = pred.getCombinedRight();
            pred.getCombinedRight().setRightCondition(pred.getCombinedRight().getCombinedLeft().getRightCondition());
            currentGroup.setCombinedLeft(currentGroup.getCombinedLeft().getCombinedLeft());
            if (currentGroup.getCombinedLeft() == null) {
                searchCon = currentGroup;
            }
        }
        return searchCon;
    }

    public void removePredicateFromCondition(Predicate pred, QuerySearchCondition searchCon, SQLQueryObject currStmt) {
        QuerySearchCondition newSearchCon = SearchConditionHelper.removePredicateFromCondition(pred, searchCon);
        this.replaceSearchCondition(currStmt, newSearchCon);
    }

    public QueryValueExpression getLeftFromPredicate(Predicate pred) {
        QueryValueExpression valExpr = null;
        if (pred instanceof PredicateBasic) {
            valExpr = ((PredicateBasic)pred).getLeftValueExpr();
        } else if (pred instanceof PredicateBetween) {
            valExpr = ((PredicateBetween)pred).getLeftValueExpr();
        } else if (pred instanceof PredicateIsNull) {
            valExpr = ((PredicateIsNull)pred).getValueExpr();
        } else if (pred instanceof PredicateLike) {
            valExpr = ((PredicateLike)pred).getMatchingValueExpr();
        } else if (pred instanceof PredicateIn) {
            if (pred instanceof PredicateInValueList) {
                valExpr = ((PredicateInValueList)pred).getValueExpr();
            }
        } else if (!(pred instanceof PredicateExists)) {
            boolean cfr_ignored_0 = pred instanceof XMLPredicateExists;
        }
        return valExpr;
    }

    public String getRightFromPredicate(Predicate pred) {
        String retVal = "";
        if (pred instanceof PredicateBasic) {
            QueryValueExpression valExpr = ((PredicateBasic)pred).getRightValueExpr();
            if (valExpr != null) {
                retVal = valExpr.getSQL();
            }
        } else if (pred instanceof PredicateBetween) {
            QueryValueExpression valExpr1 = ((PredicateBetween)pred).getRightValueExpr1();
            QueryValueExpression valExpr2 = ((PredicateBetween)pred).getRightValueExpr2();
            String rightVal1 = "";
            String rightVal2 = "";
            if (valExpr1 != null) {
                rightVal1 = valExpr1.getSQL();
            }
            if (valExpr2 != null) {
                rightVal2 = valExpr2.getSQL();
            }
            retVal = rightVal1.trim().length() > 0 ? (rightVal2.trim().length() > 0 ? rightVal1.trim().concat(" AND ").concat(rightVal2.trim()) : rightVal1.trim()) : rightVal2.trim();
        } else if (!(pred instanceof PredicateIsNull)) {
            if (pred instanceof PredicateLike) {
                QueryValueExpression escValueExpr;
                QueryValueExpression valueExpr = ((PredicateLike)pred).getPatternValueExpr();
                if (valueExpr != null) {
                    retVal = valueExpr.getSQL();
                }
                if ((escValueExpr = ((PredicateLike)pred).getEscapeValueExpr()) != null) {
                    retVal = " ESCAPE " + escValueExpr.getSQL();
                }
            } else if (pred instanceof PredicateIn) {
                if (pred instanceof PredicateInValueList) {
                    EList inValueList = ((PredicateInValueList)pred).getValueExprList();
                    String vals = "";
                    Iterator valItr = inValueList.iterator();
                    while (valItr.hasNext()) {
                        if (vals.trim().length() > 0) {
                            vals = vals.concat(",");
                        }
                        QueryValueExpression inValExpr = (QueryValueExpression)valItr.next();
                        String inValSQL = inValExpr.getSQL();
                        vals = vals.concat(inValSQL);
                    }
                    if (vals.trim().length() > 0) {
                        retVal = "(" + vals + ")";
                    }
                }
            } else if (pred instanceof PredicateExists) {
                retVal = ((PredicateExists)pred).getQueryExpr().getSQL();
                QueryExpressionBody exprBody = ((PredicateExists)pred).getQueryExpr();
                if (exprBody != null) {
                    retVal = exprBody.getSQL();
                }
                retVal = retVal.replaceAll("\n", "");
                retVal = "(" + retVal + ")";
            } else if (pred instanceof XMLPredicateExists) {
                retVal = ((XMLPredicateExists)pred).getXqueryExpr().getXqueryExprContent();
            }
        }
        return retVal;
    }

    public String getPredicateOperator(Predicate pred) {
        String retVal = "";
        if (pred instanceof PredicateBasic) {
            String tempOpr = ((PredicateBasic)pred).getComparisonOperator().getName();
            retVal = SearchConditionHelper.getComparisonSymbolFromLiteral(tempOpr);
        } else if (pred instanceof PredicateBetween) {
            retVal = ((PredicateBetween)pred).isNotBetween() ? "NOT BETWEEN" : "BETWEEN";
        } else if (pred instanceof PredicateIsNull) {
            retVal = ((PredicateIsNull)pred).isNotNull() ? "IS NOT NULL" : "IS NULL";
        } else if (pred instanceof PredicateLike) {
            retVal = ((PredicateLike)pred).isNotLike() ? "NOT LIKE" : "LIKE";
        } else if (pred instanceof PredicateIn) {
            retVal = ((PredicateIn)pred).isNotIn() ? "NOT IN" : "IN";
        } else if (pred instanceof PredicateExists) {
            retVal = "EXISTS";
        } else if (pred instanceof XMLPredicateExists) {
            retVal = "XMLEXISTS";
        }
        return retVal;
    }

    private static String getComparisonLiteralFromSymbol(String compKind) {
        String retVal = "";
        if (compKind.equalsIgnoreCase("=")) {
            retVal = "EQUAL";
        } else if (compKind.equalsIgnoreCase("<")) {
            retVal = "LESS_THAN";
        } else if (compKind.equalsIgnoreCase("<=")) {
            retVal = "LESS_THAN_OR_EQUAL";
        } else if (compKind.equalsIgnoreCase(">")) {
            retVal = "GREATER_THAN";
        } else if (compKind.equalsIgnoreCase(">=")) {
            retVal = "GREATER_THAN_OR_EQUAL";
        } else if (compKind.equalsIgnoreCase("<>")) {
            retVal = "NOT_EQUAL";
        }
        return retVal;
    }

    private static String getComparisonSymbolFromLiteral(String compLit) {
        String retVal = "";
        if (compLit.equalsIgnoreCase("EQUAL")) {
            retVal = "=";
        } else if (compLit.equalsIgnoreCase("LESS_THAN")) {
            retVal = "<";
        } else if (compLit.equalsIgnoreCase("LESS_THAN_OR_EQUAL")) {
            retVal = "<=";
        } else if (compLit.equalsIgnoreCase("GREATER_THAN")) {
            retVal = ">";
        } else if (compLit.equalsIgnoreCase("GREATER_THAN_OR_EQUAL")) {
            retVal = ">=";
        } else if (compLit.equalsIgnoreCase("NOT_EQUAL")) {
            retVal = "<>";
        }
        return retVal;
    }

    public static List getAllPredicates(QuerySearchCondition condition) {
        ArrayList<QuerySearchCondition> predicates = new ArrayList<QuerySearchCondition>();
        if (condition instanceof SearchConditionCombined) {
            SearchConditionCombined combinedCondition = (SearchConditionCombined)condition;
            QuerySearchCondition leftCondition = combinedCondition.getLeftCondition();
            predicates.addAll(SearchConditionHelper.getAllPredicates(leftCondition));
            QuerySearchCondition rightCondition = combinedCondition.getRightCondition();
            predicates.addAll(SearchConditionHelper.getAllPredicates(rightCondition));
        } else if (condition instanceof SearchConditionNested) {
            SearchConditionNested nestedConsition = (SearchConditionNested)condition;
            predicates.addAll(SearchConditionHelper.getAllPredicates(nestedConsition.getNestedCondition()));
        } else if (condition instanceof Predicate) {
            predicates.add(condition);
        }
        return predicates;
    }

    private boolean isCompatible(String currentOperator, String newOperator) {
        boolean retVal = false;
        String currOprType = "x";
        String newOprType = "y";
        if (currentOperator.equalsIgnoreCase("") || currentOperator.equalsIgnoreCase("=") || currentOperator.equalsIgnoreCase("<") || currentOperator.equalsIgnoreCase("<=") || currentOperator.equalsIgnoreCase(">") || currentOperator.equalsIgnoreCase(">=") || currentOperator.equalsIgnoreCase("<>")) {
            currOprType = "basic";
        } else if (currentOperator.equalsIgnoreCase("BETWEEN") || currentOperator.equalsIgnoreCase("NOT BETWEEN")) {
            currOprType = "between";
        } else if (currentOperator.equalsIgnoreCase("IS NULL") || currentOperator.equalsIgnoreCase("IS NOT NULL")) {
            currOprType = "null";
        } else if (currentOperator.equalsIgnoreCase("LIKE") || currentOperator.equalsIgnoreCase("NOT LIKE")) {
            currOprType = "like";
        } else if (currentOperator.equalsIgnoreCase("IN") || currentOperator.equalsIgnoreCase("NOT IN")) {
            currOprType = "in";
        } else if (currentOperator.equalsIgnoreCase("EXISTS")) {
            currOprType = "exists";
        }
        if (newOperator.equalsIgnoreCase("") || newOperator.equalsIgnoreCase("=") || newOperator.equalsIgnoreCase("<") || newOperator.equalsIgnoreCase("<=") || newOperator.equalsIgnoreCase(">") || newOperator.equalsIgnoreCase(">=") || newOperator.equalsIgnoreCase("<>")) {
            newOprType = "basic";
        } else if (newOperator.equalsIgnoreCase("BETWEEN") || newOperator.equalsIgnoreCase("NOT BETWEEN")) {
            newOprType = "between";
        } else if (newOperator.equalsIgnoreCase("IS NULL") || newOperator.equalsIgnoreCase("IS NOT NULL")) {
            newOprType = "null";
        } else if (newOperator.equalsIgnoreCase("LIKE") || newOperator.equalsIgnoreCase("NOT LIKE")) {
            newOprType = "like";
        } else if (newOperator.equalsIgnoreCase("IN") || newOperator.equalsIgnoreCase("NOT IN")) {
            newOprType = "in";
        } else if (newOperator.equalsIgnoreCase("EXISTS")) {
            newOprType = "exists";
        }
        if (currOprType.equals(newOprType)) {
            retVal = true;
        }
        return retVal;
    }

    public boolean setLeftInPredicate(Predicate pred, QueryValueExpression value) {
        boolean updated = false;
        if (pred instanceof PredicateBasic) {
            ((PredicateBasic)pred).setLeftValueExpr(value);
            updated = true;
        } else if (pred instanceof PredicateBetween) {
            ((PredicateBetween)pred).setLeftValueExpr(value);
            updated = true;
        } else if (pred instanceof PredicateIsNull) {
            ((PredicateIsNull)pred).setValueExpr(value);
            updated = true;
        } else if (pred instanceof PredicateLike) {
            ((PredicateLike)pred).setMatchingValueExpr(value);
            updated = true;
        } else if (pred instanceof PredicateIn) {
            if (pred instanceof PredicateInValueList) {
                ((PredicateInValueList)pred).setValueExpr(value);
                updated = true;
            }
        } else if (!(pred instanceof PredicateExists)) {
            boolean cfr_ignored_0 = pred instanceof XMLPredicateExists;
        }
        return updated;
    }

    public boolean setOperatorInPredicate(SQLQueryObject currStmt, QuerySearchCondition searchCon, Predicate pred, String value) {
        String newPredOpr;
        boolean updated = false;
        String currPredOpr = this.getPredicateOperator(pred);
        if (!this.isCompatible(currPredOpr, newPredOpr = value.trim())) {
            Predicate newPred = this.buildNewPredicate(currStmt, this.getLeftFromPredicate(pred), this.getRightFromPredicate(pred), newPredOpr);
            String newRight = "";
            QueryValueExpression newLeft = null;
            if (newPred == null) {
                newRight = this.getDefaultRight(newPredOpr);
                newPred = this.buildNewPredicate(currStmt, this.getLeftFromPredicate(pred), newRight, newPredOpr);
            }
            if (newPred == null) {
                newLeft = this.getDefaultLeft(newPredOpr);
                newPred = this.buildNewPredicate(currStmt, newLeft, this.getRightFromPredicate(pred), newPredOpr);
            }
            if (newPred == null) {
                newPred = this.buildNewPredicate(currStmt, newLeft, newRight, newPredOpr);
            }
            if (newPred != null) {
                this.replacePredicate(currStmt, searchCon, pred, newPred);
                updated = true;
            }
            return updated;
        }
        if (pred instanceof PredicateBasic) {
            String compOpratorString = SearchConditionHelper.getComparisonLiteralFromSymbol(newPredOpr);
            if (compOpratorString.length() > 0) {
                PredicateComparisonOperator predOpr = PredicateComparisonOperator.get((String)compOpratorString);
                ((PredicateBasic)pred).setComparisonOperator(predOpr);
            } else if (value.trim().length() == 0) {
                ((PredicateBasic)pred).setComparisonOperator(null);
            }
        } else if (pred instanceof PredicateBetween) {
            if (value.equalsIgnoreCase("NOT BETWEEN")) {
                ((PredicateBetween)pred).setNotBetween(true);
            } else {
                ((PredicateBetween)pred).setNotBetween(false);
            }
        } else if (pred instanceof PredicateIsNull) {
            if (value.equalsIgnoreCase("IS NOT NULL")) {
                ((PredicateIsNull)pred).setNotNull(true);
            } else {
                ((PredicateIsNull)pred).setNotNull(false);
            }
        } else if (pred instanceof PredicateLike) {
            if (value.equalsIgnoreCase("NOT LIKE")) {
                ((PredicateLike)pred).setNotLike(true);
            } else {
                ((PredicateLike)pred).setNotLike(false);
            }
        } else if (pred instanceof PredicateIn) {
            if (value.equalsIgnoreCase("NOT IN")) {
                ((PredicateIn)pred).setNotIn(true);
            } else {
                ((PredicateIn)pred).setNotIn(false);
            }
        } else if (!(pred instanceof PredicateExists)) {
            boolean cfr_ignored_0 = pred instanceof XMLPredicateExists;
        }
        return updated;
    }

    public String getDefaultRight(String predOpr) {
        String retval = "";
        if (predOpr.equalsIgnoreCase("=") || predOpr.equalsIgnoreCase("<") || predOpr.equalsIgnoreCase("<=") || predOpr.equalsIgnoreCase(">") || predOpr.equalsIgnoreCase(">=") || predOpr.equalsIgnoreCase("<>")) {
            retval = "null";
        } else if (predOpr.equalsIgnoreCase("BETWEEN") || predOpr.equalsIgnoreCase("NOT BETWEEN")) {
            retval = "null AND null";
        } else if (predOpr.equalsIgnoreCase("IS NULL") || predOpr.equalsIgnoreCase("IS NOT NULL")) {
            retval = null;
        } else if (predOpr.equalsIgnoreCase("LIKE") || predOpr.equalsIgnoreCase("NOT LIKE")) {
            retval = "'%'";
        } else if (predOpr.equalsIgnoreCase("IN") || predOpr.equalsIgnoreCase("NOT IN")) {
            retval = "(null,null)";
        } else if (predOpr.equalsIgnoreCase("EXISTS")) {
            retval = " (SELECT * FROM temp) ";
        } else if (predOpr.equalsIgnoreCase("XMLEXISTS")) {
            retval = " ('<temp/>') ";
        }
        return retval;
    }

    public QueryValueExpression getDefaultLeft(String predOpr) {
        QueryValueExpression retval = null;
        if (predOpr.equalsIgnoreCase("=") || predOpr.equalsIgnoreCase("<") || predOpr.equalsIgnoreCase("<=") || predOpr.equalsIgnoreCase(">") || predOpr.equalsIgnoreCase(">=") || predOpr.equalsIgnoreCase("<>")) {
            retval = ExpressionHelper.createExpression("null");
        } else if (predOpr.equalsIgnoreCase("BETWEEN") || predOpr.equalsIgnoreCase("NOT BETWEEN")) {
            retval = ExpressionHelper.createExpression("null");
        } else if (predOpr.equalsIgnoreCase("IS NULL") || predOpr.equalsIgnoreCase("IS NOT NULL")) {
            retval = ExpressionHelper.createExpression("null");
        } else if (predOpr.equalsIgnoreCase("LIKE") || predOpr.equalsIgnoreCase("NOT LIKE")) {
            retval = ExpressionHelper.createExpression("null");
        } else if (predOpr.equalsIgnoreCase("IN") || predOpr.equalsIgnoreCase("NOT IN")) {
            retval = ExpressionHelper.createExpression("null");
        } else if (predOpr.equalsIgnoreCase("EXISTS")) {
            retval = null;
        }
        return retval;
    }

    public QuerySearchCondition setAndOrInSearchCondition(SQLQueryObject currStmt, QuerySearchCondition searchCon, Predicate pred, String andOrValue) {
        Predicate tempSearchCon;
        if (pred.getCombinedRight() == null && pred.getCombinedLeft() == null || pred.getCombinedRight() != null && pred.getCombinedRight().getCombinedLeft() == null) {
            searchCon = this.buildSearchCondition(currStmt, searchCon, null, null, "");
        }
        if ((tempSearchCon = pred).getCombinedRight() != null) {
            tempSearchCon = tempSearchCon.getCombinedRight();
        }
        tempSearchCon.getCombinedLeft().setCombinedOperator(SearchConditionCombinedOperator.get((String)andOrValue));
        return searchCon;
    }

    public static QuerySearchCondition replacePredicate(QuerySearchCondition searchCon, Predicate oldPred, Predicate newPred) {
        if (oldPred.getCombinedRight() == null && oldPred.getCombinedLeft() == null) {
            searchCon = newPred;
        } else if (oldPred.getCombinedLeft() != null) {
            oldPred.getCombinedLeft().setLeftCondition((QuerySearchCondition)newPred);
        } else if (oldPred.getCombinedRight() != null) {
            oldPred.getCombinedRight().setRightCondition((QuerySearchCondition)newPred);
        }
        return searchCon;
    }

    public void replacePredicate(SQLQueryObject stmt, QuerySearchCondition searchCon, Predicate oldPred, Predicate newPred) {
        if (oldPred.getCombinedRight() == null && oldPred.getCombinedLeft() == null) {
            searchCon = newPred;
            this.replaceSearchCondition(stmt, searchCon);
        } else if (oldPred.getCombinedLeft() != null) {
            oldPred.getCombinedLeft().setLeftCondition((QuerySearchCondition)newPred);
        } else if (oldPred.getCombinedRight() != null) {
            oldPred.getCombinedRight().setRightCondition((QuerySearchCondition)newPred);
        }
    }

    public void replaceSearchCondition(SQLQueryObject statement, QuerySearchCondition searchCon) {
        QuerySelect query;
        if (statement instanceof QueryUpdateStatement) {
            ((QueryUpdateStatement)statement).setWhereClause(searchCon);
        }
        if (statement instanceof QueryDeleteStatement) {
            ((QueryDeleteStatement)statement).setWhereClause(searchCon);
        }
        if (statement instanceof QuerySelectStatement) {
            query = (QuerySelect)((QuerySelectStatement)statement).getQueryExpr().getQuery();
            if (this.isHavingClause()) {
                query.setHavingClause(searchCon);
            } else {
                query.setWhereClause(searchCon);
            }
        }
        if (statement instanceof QuerySelect) {
            query = (QuerySelect)statement;
            if (this.isHavingClause()) {
                query.setHavingClause(searchCon);
            } else {
                query.setWhereClause(searchCon);
            }
        }
    }

    public boolean isHavingClause() {
        return this.havingClause;
    }

    public void setHavingClause(boolean havingClause) {
        this.havingClause = havingClause;
    }
}

