/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.dltk.core.IModelElement;

public class ElementTypeDescriber {
    private final Map<Integer, String> names = new HashMap<Integer, String>();

    public ElementTypeDescriber() {
        Field[] fieldArray = IModelElement.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (Modifier.isPublic(field.getModifiers()) && Modifier.isStatic(field.getModifiers())) {
                try {
                    Integer value = (Integer)field.get(null);
                    this.names.put((int)value, this.convert(field.getName()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    private String convert(String name) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer e = new StringTokenizer(name, "_");
        while (e.hasMoreElements()) {
            String token = e.nextToken();
            if (token.length() == 0) continue;
            sb.append(Character.toUpperCase(token.charAt(0)));
            sb.append(token.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public String describe(int elementType) {
        Object name = this.names.get(elementType);
        if (name == null) {
            name = "#" + elementType;
        }
        return name;
    }
}

