/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.navigation;

import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.tcl.internal.ui.navigation.ElementsView;

public class NamespacesView
extends ElementsView {
    @Override
    public String getElementName(Object element) {
        if (element instanceof IType) {
            String buffer = "";
            Object type = (IType)element;
            while (type != null) {
                String str = this.getOriginalElementText(type);
                buffer = str.startsWith("::") ? String.valueOf(str) + buffer : "::" + str + buffer;
                IModelElement parent = type.getParent();
                type = parent instanceof IType ? (IType)parent : null;
            }
            String from = ((IType)element).getScriptFolder().getElementName();
            if (from.length() > 0) {
                return String.valueOf(buffer) + " (" + from + ")";
            }
            return buffer;
        }
        return null;
    }

    @Override
    public String getJobTitle() {
        return "Namespaces view search...";
    }

    @Override
    public boolean isElement(IModelElement e) {
        return e instanceof IType;
    }

    @Override
    public boolean needProcessChildren(IModelElement e) {
        return !(e instanceof IMethod);
    }

    @Override
    protected String getPreferencesId() {
        return "NamespacesView_";
    }
}

