/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.action;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ISaveImageFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ISaveImageContext;
import org.eclipse.graphiti.features.context.impl.SaveImageContext;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.jface.action.Action;

public class SaveImageAction
extends Action {
    private IDiagramBehavior diagramBehavior;
    private IConfigurationProvider configurationProvider;
    public static final String TOOL_TIP = Messages.SaveImageAction_1_xmsg;
    public static final String TEXT = Messages.SaveImageAction_0_xmsg;
    public static final String ACTION_ID = "export_diagram_action";
    public static final String ACTION_DEFINITION_ID = "org.eclipse.graphiti.ui.internal.action.SaveImageAction";

    public SaveImageAction(IDiagramBehavior diagramBehavior, IConfigurationProvider configurationProvider) {
        this.diagramBehavior = diagramBehavior;
        this.configurationProvider = configurationProvider;
        this.setText(TEXT);
        this.setToolTipText(TOOL_TIP);
        this.setId(ACTION_ID);
        this.setActionDefinitionId(ACTION_DEFINITION_ID);
    }

    public boolean isEnabled() {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        if (featureProvider == null) {
            return false;
        }
        ISaveImageFeature feature = featureProvider.getSaveImageFeature();
        ISaveImageContext context = this.createSaveImageContext();
        if (feature == null || !feature.canSave(context)) {
            return false;
        }
        return ((IAdaptable)this.diagramBehavior.getDiagramContainer()).getAdapter(GraphicalViewer.class) != null;
    }

    public void run() {
        ISaveImageContext context = this.createSaveImageContext();
        IFeatureProvider featureProvider = this.getFeatureProvider();
        ISaveImageFeature feature = featureProvider.getSaveImageFeature();
        if (feature != null) {
            GenericFeatureCommandWithContext command = new GenericFeatureCommandWithContext((IFeature)feature, (IContext)context);
            this.executeOnCommandStack((ICommand)command);
        }
    }

    private ISaveImageContext createSaveImageContext() {
        SaveImageContext context = new SaveImageContext();
        return context;
    }

    private IFeatureProvider getFeatureProvider() {
        return this.configurationProvider.getDiagramTypeProvider().getFeatureProvider();
    }

    private void executeOnCommandStack(ICommand command) {
        CommandStack commandStack = this.configurationProvider.getDiagramBehavior().getEditDomain().getCommandStack();
        GefCommandWrapper wrapperCommand = new GefCommandWrapper(command, this.configurationProvider.getDiagramBehavior().getEditingDomain());
        commandStack.execute((Command)wrapperCommand);
    }
}

