/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.gen.internal.util;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class StringUtil {
    public static String padLeft(String str, char padChar, int len) {
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen < len) {
            StringBuffer buffer = new StringBuffer(len);
            int count = len - strLen;
            int i = 0;
            while (i < count) {
                buffer.append(padChar);
                ++i;
            }
            buffer.append(str);
            str = buffer.toString();
        }
        return str;
    }

    public static String quote(String str, char c) {
        assert (str != null);
        StringBuffer buffer = new StringBuffer(str.length() + 2);
        buffer.append(c);
        buffer.append(str);
        buffer.append(c);
        return buffer.toString();
    }

    public static String doubleQuote(String str) {
        return StringUtil.quote(str, '\"');
    }

    public static String unquote(String quoted) {
        if (quoted != null && quoted.length() >= 2) {
            char lastChar;
            int len = quoted.length();
            char firstChar = quoted.charAt(0);
            if (firstChar == (lastChar = quoted.charAt(len - 1)) && (firstChar == '\'' || firstChar == '\"')) {
                return quoted.substring(1, len - 1);
            }
        }
        return quoted;
    }

    public static String truncate(String s, int maxLen) {
        if (s == null) {
            return null;
        }
        int len = ((String)s).length();
        if (len > maxLen) {
            int segmentLen = maxLen / 2;
            s = ((String)s).substring(0, segmentLen) + "..." + ((String)s).substring(len - segmentLen);
        }
        return s;
    }

    public static String repeat(char c, int count) {
        StringBuffer buffer = new StringBuffer(count);
        int i = 0;
        while (i < count) {
            buffer.append(c);
            ++i;
        }
        return buffer.toString();
    }

    public static String nullIfEmpty(String s) {
        if (s != null && s.length() == 0) {
            s = null;
        }
        return s;
    }

    public static String getVisibleString(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c <= '\u001f' || c == ' ' && (i == 0 || i == len - 1)) {
                buffer.append("(0x" + Integer.toHexString(c).toUpperCase() + ")");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String strReplace(String str, int offset, int len, String replaceStr) {
        StringBuffer buffer = new StringBuffer(str.length() - len + replaceStr.length());
        buffer.append(str.substring(0, offset));
        buffer.append(replaceStr);
        buffer.append(str.substring(offset + len));
        return buffer.toString();
    }

    public static String strReplace(String str, String pattern, String replaceStr) {
        if (str == null) {
            return null;
        }
        if (pattern == null || pattern.equals("")) {
            return str;
        }
        int index = str.indexOf(pattern);
        if (index < 0) {
            return str;
        }
        if (replaceStr == null) {
            replaceStr = "";
        }
        return str.substring(0, index) + replaceStr + str.substring(index + pattern.length());
    }

    public static String strReplaceAll(String str, String pattern, String replaceStr) {
        if (str == null) {
            return null;
        }
        if (replaceStr == null) {
            replaceStr = "";
        }
        if (pattern == null || pattern.equals("")) {
            return str;
        }
        int index = ((String)str).indexOf(pattern);
        while (index >= 0) {
            str = ((String)str).substring(0, index) + replaceStr + ((String)str).substring(index + pattern.length());
            index = ((String)str).indexOf(pattern, index + replaceStr.length());
        }
        return str;
    }

    public static String strInsert(String str, int index, String insertStr) {
        return str.substring(0, index) + insertStr + str.substring(index);
    }

    public static List<String> strToList(String s, char sep, boolean trim) {
        if (s == null || s.length() == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        char[] delimiters = new char[]{sep};
        StringTokenizer tokenizer = new StringTokenizer(s, new String(delimiters), true);
        String lastTok = null;
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (tok.length() == 1 && tok.charAt(0) == sep) {
                if (tok.equals(lastTok) || lastTok == null) {
                    result.add("");
                }
            } else {
                if (trim) {
                    tok = tok.trim();
                }
                result.add(tok);
            }
            lastTok = tok;
        }
        if (lastTok.length() == 1 && lastTok.charAt(0) == sep) {
            result.add("");
        }
        result.trimToSize();
        return result;
    }

    public static List<String> strToList(String s, char sep) {
        return StringUtil.strToList(s, sep, false);
    }

    public static String listToStr(Collection a, char sep) {
        return StringUtil.listToStr((Collection<Object>)a, String.valueOf(sep));
    }

    public static String listToStr(Collection<Object> a, String sep) {
        if (a == null) {
            return null;
        }
        int count = a.size();
        if (count == 0) {
            return null;
        }
        StringBuffer buffer = null;
        for (Object obj : a) {
            if (obj == null) continue;
            if (buffer == null) {
                buffer = new StringBuffer();
            } else {
                buffer.append(sep);
            }
            if (obj instanceof String) {
                buffer.append((String)obj);
                continue;
            }
            buffer.append(obj);
        }
        return buffer != null ? buffer.toString() : null;
    }

    public static Map<String, String> strToMap(String s, char sep1, char sep2) {
        return StringUtil.strToMap(s, sep1, sep2, false);
    }

    public static Map<String, String> strToMap(String s, char sep1, char sep2, boolean lowercaseKeys) {
        if (s == null || s.length() == 0) {
            return Collections.emptyMap();
        }
        List<String> a = StringUtil.strToList(s, sep2);
        if (a == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        int count = a.size();
        int i = 0;
        while (i < count) {
            String s2 = a.get(i);
            int pos = s2.indexOf(sep1);
            if (pos >= 0) {
                String name = s2.substring(0, pos);
                String val = s2.substring(pos + 1);
                if (lowercaseKeys) {
                    name = name.toLowerCase();
                }
                hm.put(name, val);
            }
            ++i;
        }
        return hm;
    }

    public static String mapToStr(Map hm, char sep1, char sep2) {
        if (hm == null || hm.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iter = hm.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            buffer.append(entry.getKey());
            buffer.append(sep1);
            buffer.append(entry.getValue());
            if (!iter.hasNext()) continue;
            buffer.append(sep2);
        }
        return buffer.toString();
    }

    public static boolean compareAsStrings(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return obj1 == obj2;
        }
        String s1 = obj1 instanceof String ? (String)obj1 : obj1.toString();
        String s2 = obj2 instanceof String ? (String)obj2 : obj2.toString();
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean startsWithAny(String s, List<String> prefixes) {
        int count = prefixes.size();
        int i = 0;
        while (i < count) {
            if (s.startsWith(prefixes.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String initUpper(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String initLower(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static boolean isUpperCase(String s) {
        return s.toUpperCase().equals(s);
    }

    public static int skipWhiteSpaces(String str, int index) {
        int len = str.length();
        while (index < len) {
            if (!Character.isWhitespace(str.charAt(index))) break;
            ++index;
        }
        return index;
    }

    public static String collapseWhiteSpaces(String str) {
        String result = null;
        if (str != null) {
            StringBuffer buffer = new StringBuffer();
            boolean isInWhiteSpace = false;
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (Character.isWhitespace(c)) {
                    isInWhiteSpace = true;
                } else {
                    if (isInWhiteSpace) {
                        buffer.append(" ");
                    }
                    isInWhiteSpace = false;
                    buffer.append(c);
                }
                ++i;
            }
            result = buffer.toString();
        }
        return result;
    }

    public static String pluralise(String name) {
        String lower;
        Object result = name;
        if (name.length() == 1) {
            result = (String)result + "s";
        } else if (!StringUtil.seemsPluralised(name) && !(lower = name.toLowerCase()).endsWith("data")) {
            char secondLast = lower.charAt(name.length() - 2);
            result = !StringUtil.isVowel(secondLast) && lower.endsWith("y") ? name.substring(0, name.length() - 1) + "ies" : (lower.endsWith("ch") || lower.endsWith("s") ? name + "es" : name + "s");
        }
        return result;
    }

    public static String singularise(String name) {
        Object result = name;
        if (StringUtil.seemsPluralised(name)) {
            String lower = name.toLowerCase();
            if (lower.endsWith("ies")) {
                result = name.substring(0, name.length() - 3) + "y";
            } else if (lower.endsWith("ches") || lower.endsWith("ses")) {
                result = name.substring(0, name.length() - 2);
            } else if (lower.endsWith("s")) {
                result = name.substring(0, name.length() - 1);
            }
        }
        return result;
    }

    private static final boolean isVowel(char c) {
        boolean vowel = false;
        vowel |= c == 'a';
        vowel |= c == 'e';
        vowel |= c == 'i';
        vowel |= c == 'o';
        vowel |= c == 'u';
        return vowel |= c == 'y';
    }

    private static boolean seemsPluralised(String name) {
        name = name.toLowerCase();
        boolean pluralised = false;
        pluralised |= name.endsWith("es");
        pluralised |= name.endsWith("s");
        return pluralised &= !name.endsWith("ss") && !name.endsWith("us");
    }

    public static String getPackageName(String className) {
        if (className == null) {
            return null;
        }
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return null;
        }
        return className.substring(0, lastDotIndex);
    }

    public static String getClassName(String fullClassName) {
        if (fullClassName == null) {
            return null;
        }
        int lastDotIndex = fullClassName.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return fullClassName;
        }
        return fullClassName.substring(lastDotIndex + 1);
    }

    public static String columnNameToVarName(String columnName) {
        return StringUtil.dbNameToVarName(columnName);
    }

    public static String tableNameToVarName(String tableName) {
        return StringUtil.dbNameToVarName(tableName);
    }

    private static String dbNameToVarName(String s) {
        if ("".equals(s)) {
            return s;
        }
        StringBuffer result = new StringBuffer();
        boolean capitalize = true;
        boolean lastCapital = false;
        boolean lastDecapitalized = false;
        String p = null;
        int i = 0;
        while (i < s.length()) {
            String c = s.substring(i, i + 1);
            if ("_".equals(c) || " ".equals(c)) {
                capitalize = true;
            } else {
                if (c.toUpperCase().equals(c)) {
                    if (lastDecapitalized && !lastCapital) {
                        capitalize = true;
                    }
                    lastCapital = true;
                } else {
                    lastCapital = false;
                }
                if (capitalize) {
                    if (p == null || !p.equals("_")) {
                        result.append(c.toUpperCase());
                        capitalize = false;
                        p = c;
                    } else {
                        result.append(c.toLowerCase());
                        capitalize = false;
                        p = c;
                    }
                } else {
                    result.append(c.toLowerCase());
                    lastDecapitalized = true;
                    p = c;
                }
            }
            ++i;
        }
        String resultStr = Introspector.decapitalize(result.toString());
        if (resultStr.equals("class")) {
            resultStr = "clazz";
        }
        return resultStr;
    }

    public static boolean equalObjects(Object o1, Object o2, boolean ignoreCaseIfStr) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        boolean result = ignoreCaseIfStr && o1 instanceof String && o2 instanceof String ? ((String)o1).equalsIgnoreCase((String)o2) : o1.equals(o2);
        return result;
    }

    public static boolean equalObjects(Object o1, Object o2) {
        return StringUtil.equalObjects(o1, o2, false);
    }
}

