/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ExecuteInspectionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            String commandName = event.getParameter("org.eclipse.mat.ui.actions.executeInspection.commandName");
            QueryDescriptor query = QueryRegistry.instance().getQuery(commandName);
            if (query == null) {
                throw new ExecutionException(MessageUtil.format((String)Messages.ExecuteInspectionHandler_UnknownInspection, (Object[])new Object[]{commandName}));
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                throw new ExecutionException(Messages.ExecuteInspectionHandler_NoActiveWorkbenchWindow);
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                throw new ExecutionException(Messages.ExecuteInspectionHandler_NoActivePage);
            }
            IEditorPart editor = page.getActiveEditor();
            if (editor == null) {
                throw new ExecutionException(Messages.ExecuteInspectionHandler_NoActiveEditor);
            }
            if (!(editor instanceof MultiPaneEditor)) {
                throw new ExecutionException(Messages.ExecuteInspectionHandler_NotHeapEditor);
            }
            QueryExecution.executeQuery((MultiPaneEditor)editor, query);
            return null;
        }
        catch (SnapshotException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }
}

