/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.OpenActionUtil;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class OpenAction
extends SelectionDispatchAction {
    private PHPStructuredEditor fEditor;

    public OpenAction(IWorkbenchSite site) {
        super(site);
        this.setText(PHPUIMessages.OpenAction_label);
        this.setToolTipText(PHPUIMessages.OpenAction_tooltip);
        this.setDescription(PHPUIMessages.OpenAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_resource_action_context");
    }

    public OpenAction(PHPStructuredEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, (boolean)false) != null);
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (this.checkElement(element)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkElement(Object element) {
        if (element instanceof ISourceReference || element instanceof IAdaptable && ((IAdaptable)element).getAdapter(ISourceReference.class) != null) {
            return true;
        }
        if (element instanceof IFile || element instanceof IAdaptable && ((IAdaptable)element).getAdapter(IFile.class) != null) {
            return true;
        }
        return element instanceof IStorage || element instanceof IAdaptable && ((IAdaptable)element).getAdapter(IStorage.class) != null;
    }

    @Override
    public void run(ITextSelection selection) {
        if (!ActionUtils.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        IModelElement[] element = null;
        try {
            element = SelectionConverter.codeResolve(this.fEditor);
        }
        catch (ModelException e) {
            Logger.logException(e);
        }
        if (element == null) {
            IEditorStatusLine statusLine = (IEditorStatusLine)this.fEditor.getAdapter(IEditorStatusLine.class);
            if (statusLine != null) {
                statusLine.setMessage(true, PHPUIMessages.OpenAction_error_messageBadSelection, null);
            }
            this.getShell().getDisplay().beep();
            return;
        }
        this.run(new Object[]{element}, null);
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run(selection.toArray(), ((TreeViewer)this.getSelectionProvider()).getTree().getSelection());
    }

    public void run(Object[] elements, Object[] treeNodes) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            try {
                boolean activateOnOpen;
                element = this.getElementToOpen(element);
                boolean bl = activateOnOpen = this.fEditor != null ? true : OpenStrategy.activateOnOpen();
                if (element instanceof ISourceModule && treeNodes != null) {
                    Object o = treeNodes[i];
                    if (o instanceof TreeItem) {
                        TreeItem item = (TreeItem)o;
                        o = item.getData();
                    }
                    OpenActionUtil.open(o, activateOnOpen);
                } else {
                    OpenActionUtil.open(element, activateOnOpen);
                }
            }
            catch (PartInitException x) {
                MessageDialog.openError((Shell)this.getShell(), (String)PHPUIMessages.OpenAction_error_messageProblems, (String)"");
            }
            catch (ModelException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)PHPUIMessages.OpenAction_error_messageProblems, (String)"");
            }
            ++i;
        }
    }

    public Object getElementToOpen(Object object) {
        return object;
    }

    private String getDialogTitle() {
        return PHPUIMessages.OpenAction_error_title;
    }
}

