/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.NonSASLAuthentication;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.PacketReader;
import org.jivesoftware.smack.PacketWriter;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.ServerTrustManager;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.dns.HostAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMPPConnection
extends Connection {
    Socket socket;
    String connectionID = null;
    private String user = null;
    private boolean connected = false;
    private volatile boolean socketClosed = false;
    private boolean authenticated = false;
    private boolean wasAuthenticated = false;
    private boolean anonymous = false;
    private boolean usingTLS = false;
    PacketWriter packetWriter;
    PacketReader packetReader;
    Roster roster = null;
    private Collection<String> compressionMethods;
    private boolean serverAckdCompression = false;

    public XMPPConnection(String serviceName, CallbackHandler callbackHandler) {
        super(new ConnectionConfiguration(serviceName));
        this.config.setCompressionEnabled(false);
        this.config.setSASLAuthenticationEnabled(true);
        this.config.setDebuggerEnabled(DEBUG_ENABLED);
        this.config.setCallbackHandler(callbackHandler);
    }

    public XMPPConnection(String serviceName) {
        super(new ConnectionConfiguration(serviceName));
        this.config.setCompressionEnabled(false);
        this.config.setSASLAuthenticationEnabled(true);
        this.config.setDebuggerEnabled(DEBUG_ENABLED);
    }

    public XMPPConnection(ConnectionConfiguration config) {
        super(config);
    }

    public XMPPConnection(ConnectionConfiguration config, CallbackHandler callbackHandler) {
        super(config);
        config.setCallbackHandler(callbackHandler);
    }

    @Override
    public String getConnectionID() {
        if (!this.isConnected()) {
            return null;
        }
        return this.connectionID;
    }

    @Override
    public String getUser() {
        if (!this.isAuthenticated()) {
            return null;
        }
        return this.user;
    }

    @Override
    public synchronized void login(String username, String password, String resource) throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        username = username.toLowerCase().trim();
        String response = this.config.isSASLAuthenticationEnabled() && this.saslAuthentication.hasNonAnonymousAuthentication() ? (password != null ? this.saslAuthentication.authenticate(username, password, resource) : this.saslAuthentication.authenticate(username, resource, this.config.getCallbackHandler())) : new NonSASLAuthentication(this).authenticate(username, password, resource);
        if (response != null) {
            this.user = response;
            this.config.setServiceName(StringUtils.parseServer(response));
        } else {
            this.user = String.valueOf(username) + "@" + this.getServiceName();
            if (resource != null) {
                this.user = String.valueOf(this.user) + "/" + resource;
            }
        }
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        this.authenticated = true;
        this.anonymous = false;
        if (this.roster == null) {
            this.roster = new Roster(this);
        }
        if (this.config.isRosterLoadedAtLogin()) {
            this.roster.reload();
        }
        if (this.config.isSendPresence()) {
            this.packetWriter.sendPacket(new Presence(Presence.Type.available));
        }
        this.config.setLoginInfo(username, password, resource);
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    @Override
    public synchronized void loginAnonymously() throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        String response = this.config.isSASLAuthenticationEnabled() && this.saslAuthentication.hasAnonymousAuthentication() ? this.saslAuthentication.authenticateAnonymously() : new NonSASLAuthentication(this).authenticateAnonymously();
        this.user = response;
        this.config.setServiceName(StringUtils.parseServer(response));
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        this.packetWriter.sendPacket(new Presence(Presence.Type.available));
        this.authenticated = true;
        this.anonymous = true;
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Roster getRoster() {
        Object object = this;
        synchronized (object) {
            if (!this.isAuthenticated() || this.isAnonymous()) {
                if (this.roster == null) {
                    this.roster = new Roster(this);
                }
                return this.roster;
            }
        }
        if (!this.config.isRosterLoadedAtLogin()) {
            this.roster.reload();
        }
        if (!this.roster.rosterInitialized) {
            try {
                object = this.roster;
                synchronized (object) {
                    long waitTime = SmackConfiguration.getPacketReplyTimeout();
                    long start = System.currentTimeMillis();
                    while (!this.roster.rosterInitialized) {
                        if (waitTime <= 0L) break;
                        this.roster.wait(waitTime);
                        long now = System.currentTimeMillis();
                        waitTime -= now - start;
                        start = now;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.roster;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isSecureConnection() {
        return this.isUsingTLS();
    }

    public boolean isSocketClosed() {
        return this.socketClosed;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    protected void shutdown(Presence unavailablePresence) {
        if (this.packetWriter != null) {
            this.packetWriter.sendPacket(unavailablePresence);
        }
        this.setWasAuthenticated(this.authenticated);
        this.authenticated = false;
        if (this.packetReader != null) {
            this.packetReader.shutdown();
        }
        if (this.packetWriter != null) {
            this.packetWriter.shutdown();
        }
        try {
            Thread.sleep(150L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socketClosed = true;
        try {
            this.socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.connected = false;
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.writer = null;
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saslAuthentication.init();
    }

    @Override
    public synchronized void disconnect(Presence unavailablePresence) {
        if (this.packetReader == null || this.packetWriter == null) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        this.shutdown(unavailablePresence);
        if (this.roster != null) {
            this.roster.cleanup();
            this.roster = null;
        }
        this.wasAuthenticated = false;
        this.packetWriter.cleanup();
        this.packetReader.cleanup();
    }

    @Override
    public void sendPacket(Packet packet) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (packet == null) {
            throw new NullPointerException("Packet is null.");
        }
        this.packetWriter.sendPacket(packet);
    }

    public void addPacketWriterInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        this.addPacketInterceptor(packetInterceptor, packetFilter);
    }

    public void removePacketWriterInterceptor(PacketInterceptor packetInterceptor) {
        this.removePacketInterceptor(packetInterceptor);
    }

    public void addPacketWriterListener(PacketListener packetListener, PacketFilter packetFilter) {
        this.addPacketSendingListener(packetListener, packetFilter);
    }

    public void removePacketWriterListener(PacketListener packetListener) {
        this.removePacketSendingListener(packetListener);
    }

    private void connectUsingConfiguration(ConnectionConfiguration config) throws XMPPException {
        XMPPException exception = null;
        Iterator<HostAddress> it = config.getHostAddresses().iterator();
        LinkedList<HostAddress> failedAddresses = new LinkedList<HostAddress>();
        boolean xmppIOError = false;
        while (it.hasNext()) {
            String errorMessage;
            exception = null;
            HostAddress hostAddress = it.next();
            String host = hostAddress.getFQDN();
            int port = hostAddress.getPort();
            try {
                this.socket = config.getSocketFactory() == null ? new Socket(host, port) : config.getSocketFactory().createSocket(host, port);
            }
            catch (UnknownHostException uhe) {
                errorMessage = "Could not connect to " + host + ":" + port + ".";
                exception = new XMPPException(errorMessage, new XMPPError(XMPPError.Condition.remote_server_timeout, errorMessage), uhe);
            }
            catch (IOException ioe) {
                errorMessage = "XMPPError connecting to " + host + ":" + port + ".";
                exception = new XMPPException(errorMessage, new XMPPError(XMPPError.Condition.remote_server_error, errorMessage), ioe);
                xmppIOError = true;
            }
            if (exception == null) {
                config.setUsedHostAddress(hostAddress);
                break;
            }
            hostAddress.setException(exception);
            failedAddresses.add(hostAddress);
            if (it.hasNext()) continue;
            StringBuilder sb = new StringBuilder();
            for (HostAddress fha : failedAddresses) {
                sb.append(fha.getErrorMessage());
                sb.append("; ");
            }
            XMPPError xmppError = xmppIOError ? new XMPPError(XMPPError.Condition.remote_server_error) : new XMPPError(XMPPError.Condition.remote_server_timeout);
            throw new XMPPException(sb.toString(), xmppError);
        }
        this.socketClosed = false;
        this.initConnection();
    }

    private void initConnection() throws XMPPException {
        boolean isFirstInitialization = this.packetReader == null || this.packetWriter == null;
        this.compressionHandler = null;
        this.serverAckdCompression = false;
        this.initReaderAndWriter();
        try {
            if (isFirstInitialization) {
                this.packetWriter = new PacketWriter(this);
                this.packetReader = new PacketReader(this);
                if (this.config.isDebuggerEnabled()) {
                    this.addPacketListener(this.debugger.getReaderListener(), null);
                    if (this.debugger.getWriterListener() != null) {
                        this.addPacketSendingListener(this.debugger.getWriterListener(), null);
                    }
                }
            } else {
                this.packetWriter.init();
                this.packetReader.init();
            }
            this.packetWriter.startup();
            this.packetReader.startup();
            this.connected = true;
            if (isFirstInitialization) {
                for (ConnectionCreationListener listener : XMPPConnection.getConnectionCreationListeners()) {
                    listener.connectionCreated(this);
                }
            } else if (!this.wasAuthenticated) {
                this.notifyReconnection();
            }
        }
        catch (XMPPException ex) {
            if (this.packetWriter != null) {
                try {
                    this.packetWriter.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.packetWriter = null;
            }
            if (this.packetReader != null) {
                try {
                    this.packetReader.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.packetReader = null;
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.reader = null;
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.writer = null;
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.socket = null;
            }
            this.setWasAuthenticated(this.authenticated);
            this.authenticated = false;
            this.connected = false;
            throw ex;
        }
    }

    private void initReaderAndWriter() throws XMPPException {
        try {
            if (this.compressionHandler == null) {
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
            } else {
                try {
                    OutputStream os = this.compressionHandler.getOutputStream(this.socket.getOutputStream());
                    this.writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
                    InputStream is = this.compressionHandler.getInputStream(this.socket.getInputStream());
                    this.reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.compressionHandler = null;
                    this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
                }
            }
        }
        catch (IOException ioe) {
            throw new XMPPException("XMPPError establishing connection with server.", new XMPPError(XMPPError.Condition.remote_server_error, "XMPPError establishing connection with server."), ioe);
        }
        this.initDebugger();
    }

    public boolean isUsingTLS() {
        return this.usingTLS;
    }

    void startTLSReceived(boolean required) {
        if (required && this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.notifyConnectionError(new IllegalStateException("TLS required by server but not allowed by connection configuration"));
            return;
        }
        if (this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            return;
        }
        try {
            this.writer.write("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
            this.writer.flush();
        }
        catch (IOException e) {
            this.notifyConnectionError(e);
        }
    }

    void proceedTLSReceived() throws Exception {
        SSLContext context = this.config.getCustomSSLContext();
        KeyStore ks = null;
        KeyManager[] kms = null;
        PasswordCallback pcb = null;
        if (this.config.getCallbackHandler() == null) {
            ks = null;
        } else if (context == null) {
            if (this.config.getKeystoreType().equals("NONE")) {
                ks = null;
                pcb = null;
            } else if (this.config.getKeystoreType().equals("PKCS11")) {
                try {
                    Constructor<?> c = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
                    String pkcs11Config = "name = SmartCard\nlibrary = " + this.config.getPKCS11Library();
                    ByteArrayInputStream config = new ByteArrayInputStream(pkcs11Config.getBytes());
                    Provider p = (Provider)c.newInstance(config);
                    Security.addProvider(p);
                    ks = KeyStore.getInstance("PKCS11", p);
                    pcb = new PasswordCallback("PKCS11 Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{pcb});
                    ks.load(null, pcb.getPassword());
                }
                catch (Exception e) {
                    ks = null;
                    pcb = null;
                }
            } else if (this.config.getKeystoreType().equals("Apple")) {
                ks = KeyStore.getInstance("KeychainStore", "Apple");
                ks.load(null, null);
            } else {
                ks = KeyStore.getInstance(this.config.getKeystoreType());
                try {
                    pcb = new PasswordCallback("Keystore Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{pcb});
                    ks.load(new FileInputStream(this.config.getKeystorePath()), pcb.getPassword());
                }
                catch (Exception e) {
                    ks = null;
                    pcb = null;
                }
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            try {
                if (pcb == null) {
                    kmf.init(ks, null);
                } else {
                    kmf.init(ks, pcb.getPassword());
                    pcb.clearPassword();
                }
                kms = kmf.getKeyManagers();
            }
            catch (NullPointerException npe) {
                kms = null;
            }
        }
        if (context == null) {
            context = SSLContext.getInstance("TLS");
            context.init(kms, new TrustManager[]{new ServerTrustManager(this.getServiceName(), this.config)}, new SecureRandom());
        }
        Socket plain = this.socket;
        this.socket = context.getSocketFactory().createSocket(plain, plain.getInetAddress().getHostAddress(), plain.getPort(), true);
        this.socket.setSoTimeout(0);
        this.socket.setKeepAlive(true);
        this.initReaderAndWriter();
        ((SSLSocket)this.socket).startHandshake();
        this.usingTLS = true;
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
    }

    void setAvailableCompressionMethods(Collection<String> methods) {
        this.compressionMethods = methods;
    }

    private XMPPInputOutputStream maybeGetCompressionHandler() {
        if (this.compressionMethods != null) {
            for (XMPPInputOutputStream handler : compressionHandlers) {
                String method;
                if (!handler.isSupported() || !this.compressionMethods.contains(method = handler.getCompressionMethod())) continue;
                return handler;
            }
        }
        return null;
    }

    @Override
    public boolean isUsingCompression() {
        return this.compressionHandler != null && this.serverAckdCompression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean useCompression() {
        if (this.authenticated) {
            throw new IllegalStateException("Compression should be negotiated before authentication.");
        }
        this.compressionHandler = this.maybeGetCompressionHandler();
        if (this.compressionHandler != null) {
            this.requestStreamCompression(this.compressionHandler.getCompressionMethod());
            XMPPConnection xMPPConnection = this;
            synchronized (xMPPConnection) {
                try {
                    this.wait(SmackConfiguration.getPacketReplyTimeout() * 5);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isUsingCompression();
        }
        return false;
    }

    private void requestStreamCompression(String method) {
        try {
            this.writer.write("<compress xmlns='http://jabber.org/protocol/compress'>");
            this.writer.write("<method>" + method + "</method></compress>");
            this.writer.flush();
        }
        catch (IOException e) {
            this.notifyConnectionError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startStreamCompression() throws Exception {
        this.serverAckdCompression = true;
        this.initReaderAndWriter();
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
        XMPPConnection xMPPConnection = this;
        synchronized (xMPPConnection) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamCompressionDenied() {
        XMPPConnection xMPPConnection = this;
        synchronized (xMPPConnection) {
            this.notify();
        }
    }

    @Override
    public void connect() throws XMPPException {
        this.connectUsingConfiguration(this.config);
        if (this.connected && this.wasAuthenticated) {
            try {
                if (this.isAnonymous()) {
                    this.loginAnonymously();
                } else {
                    this.login(this.config.getUsername(), this.config.getPassword(), this.config.getResource());
                }
                this.notifyReconnection();
            }
            catch (XMPPException e) {
                e.printStackTrace();
            }
        }
    }

    private void setWasAuthenticated(boolean wasAuthenticated) {
        if (!this.wasAuthenticated) {
            this.wasAuthenticated = wasAuthenticated;
        }
    }

    synchronized void notifyConnectionError(Exception e) {
        if (this.packetReader.done && this.packetWriter.done) {
            return;
        }
        this.packetReader.done = true;
        this.packetWriter.done = true;
        this.shutdown(new Presence(Presence.Type.unavailable));
        e.printStackTrace();
        for (ConnectionListener listener : this.getConnectionListeners()) {
            try {
                listener.connectionClosedOnError(e);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    protected void notifyReconnection() {
        for (ConnectionListener listener : this.getConnectionListeners()) {
            try {
                listener.reconnectionSuccessful();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

