/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery.ui.model.provider;

import java.util.List;
import org.eclipse.ecf.discovery.ui.model.IServiceInfo;
import org.eclipse.ecf.discovery.ui.model.ItemProviderWithStatusLineAdapter;
import org.eclipse.ecf.discovery.ui.model.ModelPackage;
import org.eclipse.ecf.discovery.ui.model.provider.DiscoveryEditPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class IServiceInfoItemProvider
extends ItemProviderWithStatusLineAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public IServiceInfoItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addEcfNamePropertyDescriptor(object);
            this.addEcfLocationPropertyDescriptor(object);
            this.addEcfPriorityPropertyDescriptor(object);
            this.addEcfWeightPropertyDescriptor(object);
            this.addServiceIDPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addEcfNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_IServiceInfo_ecfName_feature"), this.getString("_UI_IServiceInfo_ecfName_description"), (EStructuralFeature)ModelPackage.Literals.ISERVICE_INFO__ECF_NAME, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, this.getString("_UI_DiscoveryPropertyCategory"), null));
    }

    protected void addEcfLocationPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_IServiceInfo_ecfLocation_feature"), this.getString("_UI_IServiceInfo_ecfLocation_description"), (EStructuralFeature)ModelPackage.Literals.ISERVICE_INFO__ECF_LOCATION, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, this.getString("_UI_DiscoveryPropertyCategory"), null));
    }

    protected void addEcfPriorityPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_IServiceInfo_ecfPriority_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_IServiceInfo_ecfPriority_feature", "_UI_IServiceInfo_type"), (EStructuralFeature)ModelPackage.Literals.ISERVICE_INFO__ECF_PRIORITY, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, this.getString("_UI_DiscoveryPropertyCategory"), null));
    }

    protected void addEcfWeightPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_IServiceInfo_ecfWeight_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_IServiceInfo_ecfWeight_feature", "_UI_IServiceInfo_type"), (EStructuralFeature)ModelPackage.Literals.ISERVICE_INFO__ECF_WEIGHT, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, this.getString("_UI_DiscoveryPropertyCategory"), null));
    }

    protected void addServiceIDPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_IServiceInfo_serviceID_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_IServiceInfo_serviceID_feature", "_UI_IServiceInfo_type"), (EStructuralFeature)ModelPackage.Literals.ISERVICE_INFO__SERVICE_ID, false, false, true, null, this.getString("_UI_DiscoveryPropertyCategory"), null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/IServiceInfo"));
    }

    public String getText(Object object) {
        IServiceInfo serviceInfo = (IServiceInfo)object;
        String namingAuthority = serviceInfo.getServiceID().getServiceTypeID().getEcfNamingAuthority();
        EList services = serviceInfo.getServiceID().getServiceTypeID().getEcfServices();
        EList protocols = serviceInfo.getServiceID().getServiceTypeID().getEcfProtocols();
        return String.valueOf(services.size() == 1 ? (String)services.get(0) : services.toString()) + " " + protocols + ":" + namingAuthority;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(IServiceInfo.class)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public ResourceLocator getResourceLocator() {
        return DiscoveryEditPlugin.INSTANCE;
    }
}

