/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jdt.ui.text.java.correction.CUCorrectionProposal;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.s2e.environment.RunnableJob;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ICompletionProposalProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.template.LinkedAsyncProposalModelPresenter;
import org.eclipse.scout.sdk.s2e.ui.internal.template.LinkedAsyncProposalPositionGroup;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TypeProposalContext;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstNodeFactory;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.ILinkedPositionHolder;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractTypeProposal
extends CUCorrectionProposal
implements ILinkedPositionHolder {
    static final char SEARCH_STRING_END_FIX = ';';
    private final TypeProposalContext m_context;
    private final LinkedProposalModel m_linkedProposalModel;
    private final List<ICompletionProposalProvider> m_asyncProposalProviders;
    private ASTRewrite m_rewrite;
    private AstNodeFactory m_nodeFactory;
    private static volatile IAstNodeFactoryProvider astNodeFactoryProvider = proposal -> {
        TypeProposalContext ctx = proposal.getProposalContext();
        return new AstNodeFactory(ctx.getDeclaringType(), ctx.getIcu(), ctx.getProvider(), ctx.getScoutModelHierarchy().api(), ctx.getDeclaringTypeBinding(), proposal);
    };

    public static IAstNodeFactoryProvider getAstNodeFactoryProvider() {
        return astNodeFactoryProvider;
    }

    public static void setAstNodeFactoryProvider(IAstNodeFactoryProvider provider) {
        astNodeFactoryProvider = (IAstNodeFactoryProvider)Ensure.notNull((Object)provider);
    }

    protected AbstractTypeProposal(String displayName, int relevance, String imageId, ICompilationUnit cu, TypeProposalContext context) {
        super(displayName, cu, null, relevance, S2ESdkUiActivator.getImage(imageId));
        this.m_context = context;
        this.m_linkedProposalModel = new LinkedProposalModel();
        this.m_asyncProposalProviders = new ArrayList<ICompletionProposalProvider>();
    }

    protected abstract void fillRewrite(AstNodeFactory var1, Type var2) throws CoreException;

    public String getAdditionalProposalInfo() {
        return null;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return null;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.m_rewrite == null) {
            AstNodeFactory factory = this.getFactory();
            Type superType = this.getBestMatchingSuperType(this.m_context.getDefaultSuperClasses());
            this.m_rewrite = factory.getRewrite();
            this.fillRewrite(factory, superType);
        }
        return this.m_rewrite;
    }

    protected Type getBestMatchingSuperType(Iterable<String> candidates) {
        IJavaEnvironment env = this.getFactory().getScoutElementProvider().toScoutJavaEnvironment(this.getFactory().getJavaProject());
        for (String superTypeCandidate : candidates) {
            if (!env.exists(superTypeCandidate)) continue;
            return this.getFactory().newTypeReference(superTypeCandidate);
        }
        throw new IllegalArgumentException("No default super type available in context.");
    }

    protected synchronized AstNodeFactory getFactory() {
        if (this.m_nodeFactory == null) {
            this.m_nodeFactory = astNodeFactoryProvider.createFactoryFor(this);
        }
        return this.m_nodeFactory;
    }

    public TypeProposalContext getProposalContext() {
        return this.m_context;
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
        try {
            ASTRewrite rewrite = this.getRewrite();
            TextEdit edit = rewrite.rewriteAST();
            String searchString = this.m_context.getSearchString();
            if (searchString != null) {
                int len = searchString.length();
                edit.addChild((TextEdit)new DeleteEdit(this.m_context.getInsertPosition() - len, len + String.valueOf(';').length()));
            }
            editRoot.addChild(edit);
            editRoot.addChild(this.getFactory().getImportRewrite().rewriteImports(null));
        }
        catch (IllegalArgumentException e) {
            throw new CoreException(JavaUIStatus.createError((int)4, (Throwable)e));
        }
    }

    protected void performChange(IEditorPart part, IDocument document) {
        try {
            this.applySearchStringFix(document);
            this.scheduleAstRetrieval();
            this.getRewrite();
            for (ICompletionProposalProvider a : this.m_asyncProposalProviders) {
                a.load();
            }
            super.performChange(part, document);
            this.tryEnterLinkedMode(part);
        }
        catch (CoreException | BadLocationException e) {
            SdkLog.error((CharSequence)"Unable to insert new element.", (Object[])new Object[]{e});
        }
    }

    private void applySearchStringFix(IDocument document) throws CoreException {
        if (this.m_context.getSearchString() == null) {
            return;
        }
        try {
            InsertEdit insertFixEdit = new InsertEdit(this.m_context.getInsertPosition(), String.valueOf(';'));
            TextEditProcessor proc = new TextEditProcessor(document, (TextEdit)insertFixEdit, 2);
            proc.performEdits();
        }
        catch (BadLocationException | MalformedTreeException e) {
            throw new CoreException(JavaUIStatus.createError((int)4, (Throwable)e));
        }
    }

    private void scheduleAstRetrieval() {
        FutureTask<CompilationUnit> astInitializer = new FutureTask<CompilationUnit>(new P_AstInitCallable(this.m_context.getIcu()));
        RunnableJob astInitializerJob = new RunnableJob("Get AST", astInitializer);
        astInitializerJob.setUser(false);
        astInitializerJob.setSystem(true);
        astInitializerJob.setPriority(10);
        astInitializerJob.schedule();
        this.m_context.setCompilationUnit(astInitializer);
    }

    private void tryEnterLinkedMode(IEditorPart part) throws BadLocationException {
        LinkedProposalPositionGroupCore.PositionInformation endPosition;
        if (this.m_linkedProposalModel.hasLinkedPositions() && part instanceof JavaEditor) {
            ISourceViewer viewer = ((JavaEditor)part).getViewer();
            LinkedAsyncProposalModelPresenter.enterLinkedMode((ITextViewer)viewer, part, this.didOpenEditor(), this.m_linkedProposalModel);
        } else if (part instanceof ITextEditor && (endPosition = this.m_linkedProposalModel.getEndPosition()) != null) {
            int pos = endPosition.getOffset() + endPosition.getLength();
            ((ITextEditor)part).selectAndReveal(pos, 0);
        }
    }

    @Override
    public void addLinkedPositionProposalsHierarchy(String groupId, String hierarchyBaseTypeFqn) {
        this.addLinkedPositionProposalProvider(groupId, new P_HierarchyCallable(hierarchyBaseTypeFqn));
    }

    @Override
    public void addLinkedPositionProposalsBoolean(String groupId) {
        this.addLinkedPositionProposal(groupId, Boolean.FALSE.toString());
        this.addLinkedPositionProposal(groupId, Boolean.TRUE.toString());
    }

    private void addLinkedPositionProposalProvider(String groupId, Callable<LinkedProposalPositionGroup.Proposal[]> callable) {
        FutureTask<LinkedProposalPositionGroup.Proposal[]> future = new FutureTask<LinkedProposalPositionGroup.Proposal[]>(callable);
        LinkedProposalPositionGroup group = this.m_linkedProposalModel.getPositionGroup(groupId, false);
        if (!(group instanceof ICompletionProposalProvider)) {
            LinkedAsyncProposalPositionGroup newGroup = new LinkedAsyncProposalPositionGroup(groupId, future);
            this.m_asyncProposalProviders.add(newGroup);
            if (group != null) {
                for (LinkedProposalPositionGroupCore.PositionInformation info : group.getPositions()) {
                    newGroup.addPosition(info);
                }
            }
            group = newGroup;
            this.m_linkedProposalModel.addPositionGroup((LinkedProposalPositionGroupCore)group);
        }
    }

    @Override
    public void addLinkedPosition(ITrackedNodePosition position, boolean isFirst, String groupID) {
        this.m_linkedProposalModel.getPositionGroup(groupID, true).addPosition(position, isFirst);
    }

    @Override
    public void addLinkedPositionProposal(String groupId, String proposal) {
        this.m_linkedProposalModel.getPositionGroup(groupId, true).addProposal(proposal, null, 10);
    }

    @Override
    public void addLinkedPositionProposal(String groupID, ITypeBinding type) {
        this.m_linkedProposalModel.getPositionGroup(groupID, true).addProposal(type, this.getCompilationUnit(), 10);
    }

    public void setEndPosition(ITrackedNodePosition position) {
        this.m_linkedProposalModel.setEndPosition(position);
    }

    private static final class P_JavaLinkedModeProposal
    extends LinkedProposalPositionGroup.Proposal {
        private final ITypeBinding m_typeProposal;
        private final ICompilationUnit m_compilationUnit;

        private P_JavaLinkedModeProposal(ICompilationUnit unit, ITypeBinding typeProposal, int relevance) {
            super(BindingLabelProvider.getBindingLabel((IBinding)typeProposal, (long)4471370418441L), null, relevance);
            this.m_typeProposal = typeProposal;
            this.m_compilationUnit = unit;
            ImageDescriptor desc = BindingLabelProvider.getBindingImageDescriptor((IBinding)this.m_typeProposal, (int)1);
            if (desc != null) {
                this.setImage(JavaPlugin.getImageDescriptorRegistry().get(desc));
            }
        }

        public TextEdit computeEdits(int offset, LinkedPosition position, char trigger, int stateMask, LinkedModeModel model) throws CoreException {
            ImportRewrite impRewrite = CodeStyleConfiguration.createImportRewrite((ICompilationUnit)this.m_compilationUnit, (boolean)true);
            String replaceString = impRewrite.addImport(this.m_typeProposal);
            MultiTextEdit composedEdit = new MultiTextEdit();
            composedEdit.addChild((TextEdit)new ReplaceEdit(position.getOffset(), position.getLength(), replaceString));
            composedEdit.addChild(impRewrite.rewriteImports(null));
            return composedEdit;
        }
    }

    private final class P_HierarchyCallable
    implements Callable<LinkedProposalPositionGroup.Proposal[]> {
        private final String m_hierarchyBaseTypeFqn;

        private P_HierarchyCallable(String hierarchyBaseTypeFqn) {
            this.m_hierarchyBaseTypeFqn = (String)Ensure.notNull((Object)hierarchyBaseTypeFqn);
        }

        @Override
        public LinkedProposalPositionGroup.Proposal[] call() {
            Set abstractClassesInHierarchy = JdtUtils.findAbstractClassesInHierarchy((IJavaProject)AbstractTypeProposal.this.getFactory().getJavaProject(), (String)this.m_hierarchyBaseTypeFqn, null);
            return (LinkedProposalPositionGroup.Proposal[])abstractClassesInHierarchy.stream().map(type -> AbstractTypeProposal.this.getFactory().resolveTypeBinding(type.getFullyQualifiedName())).filter(Objects::nonNull).map(binding -> new P_JavaLinkedModeProposal(AbstractTypeProposal.this.getFactory().getIcu(), (ITypeBinding)binding, 10)).toArray(LinkedProposalPositionGroup.Proposal[]::new);
        }
    }

    private static final class P_AstInitCallable
    implements Callable<CompilationUnit> {
        private final ICompilationUnit m_icu;

        private P_AstInitCallable(ICompilationUnit icu) {
            this.m_icu = icu;
        }

        @Override
        public CompilationUnit call() {
            CompilationUnit shared = SharedASTProviderCore.getAST((ITypeRoot)this.m_icu, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_ACTIVE_ONLY, null);
            if (shared.getAST().hasResolvedBindings()) {
                return shared;
            }
            ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
            parser.setKind(8);
            parser.setSource(this.m_icu);
            parser.setResolveBindings(true);
            return (CompilationUnit)parser.createAST(null);
        }
    }

    @FunctionalInterface
    public static interface IAstNodeFactoryProvider {
        public AstNodeFactory createFactoryFor(AbstractTypeProposal var1);
    }
}

